/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.drools.CommonTestMethodBase;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.xml.XmlPackageReader;
import org.drools.compiler.xml.rules.DumperTestHelper;
import org.drools.core.util.StringUtils;
import org.drools.lang.DrlDumper;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.MVELExprDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.junit.Test;

public class XmlPackageReaderTest
extends CommonTestMethodBase {
    @Test
    public void testParseFrom() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseFrom.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        PatternDescr patterndescr = (PatternDescr)obj.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)patterndescr.getSource();
        MVELExprDescr accessordescriptor = (MVELExprDescr)from.getDataSource();
        XmlPackageReaderTest.assertEquals((String)"cheesery.getCheeses(i+4)", (String)accessordescriptor.getExpression());
        XmlPackageReaderTest.assertEquals((String)patterndescr.getObjectType(), (String)"Cheese");
        XmlPackageReaderTest.assertEquals((String)patterndescr.getIdentifier(), (String)"cheese");
    }

    @Test
    public void testAccumulate() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        XmlPackageReaderTest.assertEquals((String)patterncheese.getIdentifier(), (String)"cheese");
        XmlPackageReaderTest.assertEquals((String)patterncheese.getObjectType(), (String)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        XmlPackageReaderTest.assertEquals((String)"total += $cheese.getPrice();", (String)accumulatedescr.getActionCode());
        XmlPackageReaderTest.assertEquals((String)"int total = 0;", (String)accumulatedescr.getInitCode());
        XmlPackageReaderTest.assertEquals((String)"new Integer( total ) );", (String)accumulatedescr.getResultCode());
        patternobj = obj.getLhs().getDescrs().get(1);
        XmlPackageReaderTest.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patternmax = (PatternDescr)patternobj;
        XmlPackageReaderTest.assertEquals((String)patternmax.getIdentifier(), (String)"max");
        XmlPackageReaderTest.assertEquals((String)patternmax.getObjectType(), (String)"Number");
        accumulatedescr = (AccumulateDescr)patternmax.getSource();
        XmlPackageReaderTest.assertTrue((boolean)accumulatedescr.isExternalFunction());
        XmlPackageReaderTest.assertEquals((String)"max", (String)((AccumulateDescr.AccumulateFunctionCallDescr)accumulatedescr.getFunctions().get(0)).getFunction());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getInitCode());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getActionCode());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getResultCode());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getReverseCode());
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(1);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        XmlPackageReaderTest.assertEquals((String)patterncheese.getIdentifier(), (String)"cheese");
        XmlPackageReaderTest.assertEquals((String)patterncheese.getObjectType(), (String)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        XmlPackageReaderTest.assertEquals((String)"total += $cheese.getPrice();", (String)accumulatedescr.getActionCode());
        XmlPackageReaderTest.assertEquals((String)"int total = 0;", (String)accumulatedescr.getInitCode());
        XmlPackageReaderTest.assertEquals((String)"new Integer( total ) );", (String)accumulatedescr.getResultCode());
        AndDescr anddescr = (AndDescr)accumulatedescr.getInput();
        List descrlist = anddescr.getDescrs();
        PatternDescr[] listpattern = descrlist.toArray(new PatternDescr[descrlist.size()]);
        XmlPackageReaderTest.assertEquals((String)listpattern[0].getObjectType(), (String)"Milk");
        XmlPackageReaderTest.assertEquals((String)listpattern[1].getObjectType(), (String)"Cup");
    }

    @Test
    public void testParseForall() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseForall.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        ForallDescr forall = (ForallDescr)obj.getLhs().getDescrs().get(0);
        List forallPaterns = forall.getDescrs();
        PatternDescr pattarnState = (PatternDescr)forallPaterns.get(0);
        PatternDescr personState = (PatternDescr)forallPaterns.get(1);
        PatternDescr cheeseState = (PatternDescr)forallPaterns.get(2);
        XmlPackageReaderTest.assertEquals((String)pattarnState.getObjectType(), (String)"State");
        XmlPackageReaderTest.assertEquals((String)personState.getObjectType(), (String)"Person");
        XmlPackageReaderTest.assertEquals((String)cheeseState.getObjectType(), (String)"Cheese");
    }

    @Test
    public void testParseExists() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseExists.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object existdescr = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(existdescr instanceof ExistsDescr));
        Object patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        XmlPackageReaderTest.assertEquals((String)((PatternDescr)patternDescriptor).getObjectType(), (String)"Person");
        Object notDescr = obj.getLhs().getDescrs().get(1);
        XmlPackageReaderTest.assertEquals((String)notDescr.getClass().getName(), (String)NotDescr.class.getName());
        existdescr = ((NotDescr)notDescr).getDescrs().get(0);
        patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        XmlPackageReaderTest.assertEquals((String)((PatternDescr)patternDescriptor).getObjectType(), (String)"Cheese");
    }

    @Test
    public void testParseCollect() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseCollect.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseCollect.drl")));
        String actual = new DrlDumper().dump(packageDescr);
        DumperTestHelper.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testParsePackageName() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParsePackageName.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
    }

    @Test
    public void testParseImport() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseImport.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List functionImport = packageDescr.getFunctionImports();
        XmlPackageReaderTest.assertEquals((String)"org.drools.function", (String)((FunctionImportDescr)functionImport.get(0)).getTarget());
    }

    @Test
    public void testParseGlobal() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseGlobal.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
    }

    @Test
    public void testParseFunction() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseFunction.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
    }

    @Test
    public void testParseRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseRule.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseRule.drl")));
        String actual = new DrlDumper().dump(packageDescr);
        DumperTestHelper.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testParseSimpleRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SimpleRule1.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.List", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.Person", (String)((ImportDescr)imports.get(1)).getTarget());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"simple_rule1", (String)ruleDescr.getName());
        AndDescr lhs = ruleDescr.getLhs();
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Person", (String)patternDescr.getObjectType());
        ExprConstraintDescr expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"name == \"darth\"", (String)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(1);
        XmlPackageReaderTest.assertEquals((String)"simple_rule2", (String)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Person", (String)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"age == 35 || == -3.5", (String)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(2);
        XmlPackageReaderTest.assertEquals((String)"simple_rule3", (String)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Person", (String)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"age == 35 || (!= 7.0 && != -70)", (String)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(3);
        XmlPackageReaderTest.assertEquals((String)"simple_rule3", (String)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        XmlPackageReaderTest.assertEquals((String)"Person", (String)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"name == $s", (String)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(4);
        XmlPackageReaderTest.assertEquals((String)"simple_rule4", (String)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        XmlPackageReaderTest.assertEquals((String)"Person", (String)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"(name == $s) || (age == 35 || (!= 7.0 && != -70))", (String)expr.getExpression());
        ruleDescr = (RuleDescr)packageDescr.getRules().get(5);
        XmlPackageReaderTest.assertEquals((String)"simple_rule5", (String)ruleDescr.getName());
        lhs = ruleDescr.getLhs();
        patternDescr = (PatternDescr)lhs.getDescrs().get(1);
        XmlPackageReaderTest.assertEquals((String)"Person", (String)patternDescr.getObjectType());
        expr = (ExprConstraintDescr)((AndDescr)patternDescr.getConstraint()).getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"(name == $s) || ((age != 34) && (age != 37) && (name != \"yoda\"))", (String)expr.getExpression());
    }

    @Test
    public void testParseLhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseLhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        String expected = StringUtils.readFileAsString((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseLhs.drl")));
        String actual = new DrlDumper().dump(packageDescr);
        DumperTestHelper.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testParseRhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseRhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"my rule", (String)ruleDescr.getName());
        String consequence = (String)ruleDescr.getConsequence();
        XmlPackageReaderTest.assertNotNull((Object)consequence);
        XmlPackageReaderTest.assertEquals((String)"System.out.println( \"hello\" );", (String)consequence.trim());
    }

    @Test
    public void testParseQuery() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseQuery.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
        QueryDescr queryDescr = (QueryDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"my query", (String)queryDescr.getName());
        AndDescr lhs = queryDescr.getLhs();
        XmlPackageReaderTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Foo", (String)patternDescr.getObjectType());
    }

    private XmlPackageReader getXmReader() {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlPackageReader xmlReader = new XmlPackageReader(conf.getSemanticModules());
        xmlReader.getParser().setClassLoader(XmlPackageReaderTest.class.getClassLoader());
        return xmlReader;
    }
}

