/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.definition.type.FactType;
import org.drools.factmodel.traits.Entity;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TraitTest
extends CommonTestMethodBase {
    private static long t0;

    @BeforeClass
    public static void init() {
        t0 = new Date().getTime();
    }

    @AfterClass
    public static void finish() {
        System.out.println("TIME : " + (new Date().getTime() - t0));
    }

    @Before
    public void reset() {
        TraitRegistry.reset();
        TraitFactory.reset();
    }

    @Test
    public void testTraitWrapper_GetAndSet() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            Class trait = kb.getFactType("org.test", "Student").getFactClass();
            TraitProxy proxy = (TraitProxy)new TraitFactory(kb).getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            wrapper.put("name", "john");
            wrapper.put("virtualField", "xyz");
            wrapper.entrySet();
            TraitTest.assertEquals((int)4, (int)wrapper.size());
            TraitTest.assertEquals((int)2, (int)virtualFields.size());
            TraitTest.assertEquals((Object)"john", wrapper.get("name"));
            TraitTest.assertEquals((Object)"xyz", wrapper.get("virtualField"));
            TraitTest.assertEquals((Object)"john", (Object)impClass.get((Object)imp, "name"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitShed() {
        String source = "org/drools/factmodel/traits/testTraitShed.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        TraitTest.assertTrue((boolean)info.isEmpty());
        ks.fireAllRules();
        TraitTest.assertTrue((boolean)info.contains("Student"));
        TraitTest.assertEquals((int)1, (int)info.size());
        ks.insert((Object)"hire");
        ks.fireAllRules();
        Collection c = ks.getObjects();
        TraitTest.assertTrue((boolean)info.contains("Worker"));
        TraitTest.assertEquals((int)2, (int)info.size());
        ks.insert((Object)"check");
        ks.fireAllRules();
        TraitTest.assertEquals((int)4, (int)info.size());
        TraitTest.assertTrue((boolean)info.contains("Conflict"));
        TraitTest.assertTrue((boolean)info.contains("Nothing"));
    }

    @Test
    public void testTraitDon() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Collection wm = ks.getObjects();
        ks.insert((Object)"die");
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("DON"));
        Assert.assertTrue((boolean)info.contains("SHED"));
    }

    @Test
    public void testMixin() {
        String source = "org/drools/factmodel/traits/testTraitMixin.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        TraitTest.assertTrue((boolean)info.contains("27"));
    }

    @Test
    public void testTraitMethodsWithObjects() {
        String source = "org/drools/factmodel/traits/testTraitWrapping.drl";
        Character c = Character.valueOf('\u0000');
        System.out.println(">>>>" + c + "<<<<");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            System.err.println(((Object)errors).toString());
        }
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testTraitMethodsWithPrimitives() {
        String source = "org/drools/factmodel/traits/testTraitWrappingPrimitives.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            System.err.println(errors);
        }
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testTraitProxy() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"aaa");
            Class trait = kb.getFactType("org.test", "Student").getFactClass();
            Class trait2 = kb.getFactType("org.test", "Role").getFactClass();
            TraitTest.assertNotNull((Object)trait);
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            proxy.getFields().put("field", "xyz");
            TraitTest.assertNotNull((Object)proxy);
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy(imp, trait);
            TraitTest.assertSame((Object)proxy2, (Object)proxy);
            TraitProxy proxy3 = (TraitProxy)traitBuilder.getProxy(imp, trait2);
            TraitTest.assertNotNull((Object)proxy3);
            TraitTest.assertEquals((Object)"xyz", proxy3.getFields().get("field"));
            TraitTest.assertEquals((Object)"aaa", proxy3.getFields().get("name"));
            TraitableBean imp2 = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp2, "name", (Object)"aaa");
            TraitProxy proxy4 = (TraitProxy)traitBuilder.getProxy(imp2, trait);
            proxy4.getFields().put("field", "xyz");
            Assert.assertEquals((Object)proxy2, (Object)proxy4);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_Size() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            TraitTest.assertEquals((int)3, (int)wrapper.size());
            TraitTest.assertEquals((int)1, (int)virtualFields.size());
            impClass.set((Object)imp, "name", (Object)"john");
            TraitTest.assertEquals((int)3, (int)wrapper.size());
            TraitTest.assertEquals((int)1, (int)virtualFields.size());
            proxy.getFields().put("school", "skol");
            TraitTest.assertEquals((int)3, (int)wrapper.size());
            TraitTest.assertEquals((int)1, (int)virtualFields.size());
            proxy.getFields().put("surname", "xxx");
            TraitTest.assertEquals((int)4, (int)wrapper.size());
            TraitTest.assertEquals((int)2, (int)virtualFields.size());
            Entity ind = new Entity();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind, trait);
            Map virtualFields2 = ind.getDynamicProperties();
            Map wrapper2 = proxy2.getFields();
            TraitTest.assertEquals((int)3, (int)wrapper2.size());
            TraitTest.assertEquals((int)3, (int)virtualFields2.size());
            traitClass.set((Object)proxy2, "name", (Object)"john");
            TraitTest.assertEquals((int)3, (int)wrapper2.size());
            TraitTest.assertEquals((int)3, (int)virtualFields2.size());
            proxy2.getFields().put("school", "skol");
            TraitTest.assertEquals((int)3, (int)wrapper2.size());
            TraitTest.assertEquals((int)3, (int)virtualFields2.size());
            proxy2.getFields().put("surname", "xxx");
            TraitTest.assertEquals((int)4, (int)wrapper2.size());
            TraitTest.assertEquals((int)4, (int)virtualFields2.size());
            FactType traitClass2 = kb.getFactType("org.test", "Role");
            Class trait2 = traitClass2.getFactClass();
            Entity ind2 = new Entity();
            TraitProxy proxy99 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind2, trait2);
            proxy99.getFields().put("surname", "xxx");
            proxy99.getFields().put("name", "xyz");
            proxy99.getFields().put("school", "skol");
            TraitTest.assertEquals((int)3, (int)proxy99.getFields().size());
            TraitProxy proxy100 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind2, trait);
            TraitTest.assertEquals((int)4, (int)proxy100.getFields().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_IsEmpty() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType studentClass = kb.getFactType("org.test", "Student");
            Class trait = studentClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            TraitTest.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "name", (Object)"john");
            TraitTest.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "name", null);
            TraitTest.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "age", (Object)32);
            TraitTest.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "age", null);
            TraitTest.assertFalse((boolean)wrapper.isEmpty());
            Entity ind = new Entity();
            FactType RoleClass = kb.getFactType("org.test", "Role");
            Class trait2 = RoleClass.getFactClass();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind, trait2);
            Map wrapper2 = proxy2.getFields();
            TraitTest.assertTrue((boolean)wrapper2.isEmpty());
            proxy2.getFields().put("name", "john");
            TraitTest.assertFalse((boolean)wrapper2.isEmpty());
            proxy2.getFields().put("name", null);
            TraitTest.assertFalse((boolean)wrapper2.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_ContainsKey() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"john");
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            TraitTest.assertTrue((boolean)wrapper.containsKey("name"));
            TraitTest.assertTrue((boolean)wrapper.containsKey("school"));
            TraitTest.assertTrue((boolean)wrapper.containsKey("age"));
            TraitTest.assertFalse((boolean)wrapper.containsKey("surname"));
            proxy.getFields().put("school", "skol");
            proxy.getFields().put("surname", "xxx");
            TraitTest.assertTrue((boolean)wrapper.containsKey("surname"));
            Entity ind = new Entity();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind, trait);
            Map virtualFields2 = ind.getDynamicProperties();
            Map wrapper2 = proxy2.getFields();
            TraitTest.assertTrue((boolean)wrapper2.containsKey("name"));
            TraitTest.assertTrue((boolean)wrapper2.containsKey("school"));
            TraitTest.assertTrue((boolean)wrapper2.containsKey("age"));
            TraitTest.assertFalse((boolean)wrapper2.containsKey("surname"));
            traitClass.set((Object)proxy2, "name", (Object)"john");
            proxy2.getFields().put("school", "skol");
            proxy2.getFields().put("surname", "xxx");
            TraitTest.assertTrue((boolean)wrapper2.containsKey("surname"));
            FactType traitClass2 = kb.getFactType("org.test", "Role");
            Class trait2 = traitClass2.getFactClass();
            Entity ind2 = new Entity();
            TraitProxy proxy99 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind2, trait2);
            Map wrapper99 = proxy99.getFields();
            TraitTest.assertFalse((boolean)wrapper99.containsKey("name"));
            TraitTest.assertFalse((boolean)wrapper99.containsKey("school"));
            TraitTest.assertFalse((boolean)wrapper99.containsKey("age"));
            TraitTest.assertFalse((boolean)wrapper99.containsKey("surname"));
            proxy99.getFields().put("surname", "xxx");
            proxy99.getFields().put("name", "xyz");
            proxy99.getFields().put("school", "skol");
            TraitTest.assertTrue((boolean)wrapper99.containsKey("name"));
            TraitTest.assertTrue((boolean)wrapper99.containsKey("school"));
            TraitTest.assertFalse((boolean)wrapper99.containsKey("age"));
            TraitTest.assertTrue((boolean)wrapper99.containsKey("surname"));
            TraitTest.assertEquals((int)3, (int)proxy99.getFields().size());
            Entity ind0 = new Entity();
            TraitProxy proxy100 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind0, trait2);
            Map wrapper100 = proxy100.getFields();
            TraitTest.assertFalse((boolean)wrapper100.containsKey("name"));
            TraitTest.assertFalse((boolean)wrapper100.containsKey("school"));
            TraitTest.assertFalse((boolean)wrapper100.containsKey("age"));
            TraitTest.assertFalse((boolean)wrapper100.containsKey("surname"));
            TraitProxy proxy101 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind0, trait);
            TraitTest.assertTrue((boolean)wrapper100.containsKey("name"));
            TraitTest.assertTrue((boolean)wrapper100.containsKey("school"));
            TraitTest.assertTrue((boolean)wrapper100.containsKey("age"));
            TraitTest.assertFalse((boolean)wrapper100.containsKey("surname"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_keySetAndValues() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            impClass.set((Object)imp, "name", (Object)"john");
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            HashSet<String> set = new HashSet<String>();
            set.add("name");
            set.add("surname");
            set.add("age");
            set.add("school");
            set.add("name2");
            set.add("nfield");
            TraitTest.assertEquals((int)6, (int)proxy.getFields().keySet().size());
            TraitTest.assertEquals(set, proxy.getFields().keySet());
            Collection col1 = proxy.getFields().values();
            List<Serializable> col2 = Arrays.asList("john", null, 0, "xxx", "john", null);
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            };
            Collections.sort((List)col1, comp);
            Collections.sort(col2, comp);
            TraitTest.assertEquals(col1, col2);
            TraitTest.assertTrue((boolean)proxy.getFields().containsValue(null));
            TraitTest.assertTrue((boolean)proxy.getFields().containsValue("john"));
            TraitTest.assertTrue((boolean)proxy.getFields().containsValue(0));
            TraitTest.assertTrue((boolean)proxy.getFields().containsValue("xxx"));
            TraitTest.assertFalse((boolean)proxy.getFields().containsValue("randomString"));
            TraitTest.assertFalse((boolean)proxy.getFields().containsValue(-96));
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_ClearAndRemove() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"john");
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            HashSet<String> set = new HashSet<String>();
            set.add("name");
            set.add("surname");
            set.add("age");
            set.add("school");
            set.add("name2");
            set.add("nfield");
            TraitTest.assertEquals((int)6, (int)proxy.getFields().keySet().size());
            TraitTest.assertEquals(set, proxy.getFields().keySet());
            proxy.getFields().clear();
            Map fields = proxy.getFields();
            TraitTest.assertEquals((int)3, (int)fields.size());
            TraitTest.assertTrue((boolean)fields.containsKey("age"));
            TraitTest.assertTrue((boolean)fields.containsKey("school"));
            TraitTest.assertTrue((boolean)fields.containsKey("name"));
            TraitTest.assertEquals((Object)0, fields.get("age"));
            TraitTest.assertNull(fields.get("school"));
            TraitTest.assertNotNull(fields.get("name"));
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            proxy.getFields().put("age", 24);
            TraitTest.assertEquals((Object)"john", proxy.getFields().get("name"));
            TraitTest.assertEquals((Object)"xxx", proxy.getFields().get("surname"));
            TraitTest.assertEquals((Object)"john", proxy.getFields().get("name2"));
            TraitTest.assertEquals(null, proxy.getFields().get("nfield"));
            TraitTest.assertEquals((Object)24, proxy.getFields().get("age"));
            TraitTest.assertEquals(null, proxy.getFields().get("school"));
            proxy.getFields().remove("surname");
            proxy.getFields().remove("name2");
            proxy.getFields().remove("age");
            proxy.getFields().remove("school");
            proxy.getFields().remove("nfield");
            TraitTest.assertEquals((int)3, (int)proxy.getFields().size());
            TraitTest.assertEquals((Object)0, proxy.getFields().get("age"));
            TraitTest.assertEquals(null, proxy.getFields().get("school"));
            TraitTest.assertEquals((Object)"john", proxy.getFields().get("name"));
            TraitTest.assertEquals(null, proxy.getFields().get("nfield"));
            TraitTest.assertFalse((boolean)proxy.getFields().containsKey("nfield"));
            TraitTest.assertEquals(null, proxy.getFields().get("name2"));
            TraitTest.assertFalse((boolean)proxy.getFields().containsKey("name2"));
            TraitTest.assertEquals(null, proxy.getFields().get("surname"));
            TraitTest.assertFalse((boolean)proxy.getFields().containsKey("surname"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TraitTest.fail((String)e.getMessage());
        }
    }

    @Test
    @Ignore
    public void testIsA() {
        String source = "org/drools/factmodel/traits/testTraitIsA.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        int num = 10;
        System.out.println(info);
        TraitTest.assertEquals((int)num, (int)info.size());
        for (int j = 0; j < num; ++j) {
            TraitTest.assertTrue((boolean)info.contains("" + j));
        }
    }

    @Test
    public void testTraitOverrideType() {
        String source = "org/drools/factmodel/traits/testTraitOverride.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Collection wm = ks.getObjects();
        TraitTest.assertTrue((boolean)info.contains("OK"));
    }

    @Test
    public void testTraitLegacy() {
        String source = "org/drools/factmodel/traits/testTraitLegacyTrait.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        TraitTest.assertEquals((int)5, (int)info.size());
        TraitTest.assertTrue((boolean)info.contains("OK"));
        TraitTest.assertTrue((boolean)info.contains("OK2"));
        TraitTest.assertTrue((boolean)info.contains("OK3"));
        TraitTest.assertTrue((boolean)info.contains("OK4"));
        TraitTest.assertTrue((boolean)info.contains("OK5"));
    }

    @Test
    public void testTraitCollections() {
        String source = "org/drools/factmodel/traits/testTraitCollections.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        TraitTest.assertEquals((int)1, (int)info.size());
        TraitTest.assertTrue((boolean)info.contains("OK"));
    }

    @Test
    public void testTraitCore() {
        String source = "org/drools/factmodel/traits/testTraitLegacyCore.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        TraitTest.assertTrue((boolean)info.contains("OK"));
        TraitTest.assertTrue((boolean)info.contains("OK2"));
        TraitTest.assertEquals((int)2, (int)info.size());
    }

    @Test
    public void testTraitWithEquality() {
        String source = "org/drools/factmodel/traits/testTraitWithEquality.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        TraitTest.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TraitTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConf.setOption((KnowledgeBaseOption)AssertBehaviorOption.EQUALITY);
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("DON"));
        Assert.assertTrue((boolean)info.contains("EQUAL"));
    }
}

