/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.Expander;
import org.drools.lang.dsl.DefaultExpanderResolver;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Ignore;
import org.junit.Test;

public class DslTest
extends CommonTestMethodBase {
    @Test
    public void testMultiLineTemplates() throws Exception {
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("rule_with_expander_multiline.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_dsl_multiline.dsl"));
        Expander ex = new DefaultExpanderResolver((Reader)dsl).get("*", null);
        String r = ex.expand((Reader)source);
        DslTest.assertEquals((String)"when Car(color==\"Red\") then doSomething();", (String)r.trim());
    }

    @Test
    public void testWithExpanderDSL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", ((Object)((Object)this)).getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rule_with_expander_dsl.dslr", ((Object)((Object)this)).getClass()), ResourceType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)1, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.insert((Object)new Person("Bob", "http://foo.bar"));
        session.insert((Object)new Cheese("stilton", 42));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        DslTest.assertEquals((int)1, (int)messages.size());
    }

    @Test
    public void testWithExpanderMore() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", ((Object)((Object)this)).getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rule_with_expander_dsl_more.dslr", ((Object)((Object)this)).getClass()), ResourceType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)1, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.insert((Object)new Person("rage"));
        session.insert((Object)new Cheese("cheddar", 15));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        DslTest.assertEquals((int)0, (int)messages.size());
        session.insert((Object)new Person("fire"));
        session.fireAllRules();
        DslTest.assertEquals((int)0, (int)messages.size());
        session.insert((Object)new Cheese("brie", 15));
        session.fireAllRules();
        DslTest.assertEquals((int)1, (int)messages.size());
    }

    @Test
    @Ignore
    public void testEmptyDSL() throws Exception {
        String DSL = "# This is an empty dsl file.";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", ((Object)((Object)this)).getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader("# This is an empty dsl file.")), ResourceType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)0, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        pkgs = SerializationHelper.serializeObject(pkgs);
        DslTest.assertNull((Object)pkgs);
    }

    @Test
    public void testDSLWithIndividualConstraintMappings() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_dslWithIndividualConstraints.dsl", ((Object)((Object)this)).getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_dslWithIndividualConstraints.dslr", ((Object)((Object)this)).getClass()), ResourceType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)1, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Cheese cheese = new Cheese("stilton", 42);
        session.insert((Object)cheese);
        session.fireAllRules();
        DslTest.assertEquals((int)1, (int)results.size());
        DslTest.assertEquals((Object)cheese, results.get(0));
    }
}

