/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Assert;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicRulesChangesTest {
    private static final int PARALLEL_THREADS = 3;
    private static final ExecutorService executor = Executors.newFixedThreadPool(3);
    private static InternalKnowledgeBase kbase;
    private static RuleBase ruleBase;
    private static Map<String, String> rules;

    @Before
    public void setUp() throws Exception {
        kbase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        ruleBase = kbase.getRuleBase();
        DynamicRulesChangesTest.addRule("raiseAlarm");
    }

    protected static StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        return kbase.newStatefulKnowledgeSession();
    }

    @Test(timeout=10000L)
    @Ignore
    public void testConcurrentRuleAdditions() throws Exception {
        this.parallelExecute(RulesExecutor.getSolvers());
    }

    @Test(timeout=10000L)
    @Ignore
    public void testBatchRuleAdditions() throws Exception {
        this.parallelExecute(BatchRulesExecutor.getSolvers());
    }

    private void parallelExecute(Collection<Callable<List<String>>> solvers) throws Exception {
        ExecutorCompletionService<List<String>> ecs = new ExecutorCompletionService<List<String>>(executor);
        for (Callable<List<String>> s : solvers) {
            ecs.submit(s);
        }
        for (int i = 0; i < 3; ++i) {
            List events = (List)ecs.take().get();
            Assert.assertEquals((int)5, (int)events.size());
        }
    }

    public static void addRule(String ruleName) throws Exception {
        String rule = rules.get(ruleName);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        ruleBase.addPackage(builder.getPackage());
    }

    static {
        rules = new HashMap<String, String>(){
            {
                this.put("raiseAlarm", "global java.util.List events\nrule \"Raise the alarm when we have one or more fires\" lock-on-active\nwhen\n    exists org.drools.integrationtests.DynamicRulesChangesTest.Fire()\nthen\n    insert( new org.drools.integrationtests.DynamicRulesChangesTest.Alarm() );\n    events.add( \"Raise the alarm\" );\n    org.drools.integrationtests.DynamicRulesChangesTest.addRule(\"onFire\");\nend");
                this.put("onFire", "global java.util.List events\nrule \"When there is a fire turn on the sprinkler\" lock-on-active\nwhen\n    $fire: org.drools.integrationtests.DynamicRulesChangesTest.Fire($room : room)\n    $sprinkler : org.drools.integrationtests.DynamicRulesChangesTest.Sprinkler( room == $room, on == false )\nthen\n    modify( $sprinkler ) { setOn( true ) };\n    events.add( \"Turn on the sprinkler for room \" + $room.getName() );\n    org.drools.integrationtests.DynamicRulesChangesTest.addRule(\"fireGone\");\nend");
                this.put("fireGone", "global java.util.List events\nrule \"When the fire is gone turn off the sprinkler\" lock-on-active\nwhen\n    $room : org.drools.integrationtests.DynamicRulesChangesTest.Room( )\n    $sprinkler : org.drools.integrationtests.DynamicRulesChangesTest.Sprinkler( room == $room, on == true )\n    not org.drools.integrationtests.DynamicRulesChangesTest.Fire( room == $room )\nthen\n    modify( $sprinkler ) { setOn( false ) };\n    events.add( \"Turn off the sprinkler for room \" + $room.getName() );\n    org.drools.integrationtests.DynamicRulesChangesTest.addRule(\"cancelAlarm\");\nend");
                this.put("cancelAlarm", "global java.util.List events\nrule \"Cancel the alarm when all the fires have gone\"\nwhen\n    not org.drools.integrationtests.DynamicRulesChangesTest.Fire()\n    $alarm : org.drools.integrationtests.DynamicRulesChangesTest.Alarm()\nthen\n    retract( $alarm );\n    events.add( \"Cancel the alarm\" );\n    org.drools.integrationtests.DynamicRulesChangesTest.addRule(\"status\");\nend");
                this.put("status", "global java.util.List events\nrule \"Status output when things are ok\"\nwhen\n    not org.drools.integrationtests.DynamicRulesChangesTest.Alarm()\n    not org.drools.integrationtests.DynamicRulesChangesTest.Sprinkler( on == true )\nthen\n    events.add( \"Everything is ok\" );\nend");
            }
        };
    }

    public static class Sprinkler {
        private Room room;
        private boolean on = false;

        public Sprinkler() {
        }

        public Sprinkler(Room room) {
            this.room = room;
        }

        public Room getRoom() {
            return this.room;
        }

        public void setRoom(Room room) {
            this.room = room;
        }

        public boolean isOn() {
            return this.on;
        }

        public void setOn(boolean on) {
            this.on = on;
        }

        public int hashCode() {
            return this.room.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Sprinkler)) {
                return false;
            }
            return this.room.equals(((Sprinkler)obj).getRoom());
        }

        public String toString() {
            return "Sprinkler for " + this.room;
        }
    }

    public static class Room {
        private String name;

        public Room() {
        }

        public Room(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Room)) {
                return false;
            }
            return this.name.equals(((Room)obj).getName());
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Fire {
        private Room room;

        public Fire() {
        }

        public Fire(Room room) {
            this.room = room;
        }

        public Room getRoom() {
            return this.room;
        }

        public void setRoom(Room room) {
            this.room = room;
        }
    }

    public static class Alarm {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BatchRulesExecutor
    implements Callable<List<String>> {
        @Override
        public List<String> call() throws Exception {
            ArrayList<String> events = new ArrayList<String>();
            try {
                StatefulKnowledgeSession ksession = DynamicRulesChangesTest.createKnowledgeSession((KnowledgeBase)kbase);
                ksession.setGlobal("events", events);
                Room room1 = new Room("Room 1");
                Fire fire1 = new Fire(room1);
                ArrayList<Command> cmds = new ArrayList<Command>();
                cmds.add(CommandFactory.newInsert((Object)room1, (String)"room1"));
                cmds.add(CommandFactory.newInsert((Object)fire1, (String)"fire1"));
                cmds.add(CommandFactory.newFireAllRules());
                ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
                Assert.assertEquals((int)1, (int)events.size());
                cmds = new ArrayList();
                cmds.add(CommandFactory.newInsert((Object)new Sprinkler(room1), (String)"sprinkler1"));
                cmds.add(CommandFactory.newFireAllRules());
                ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
                Assert.assertEquals((int)2, (int)events.size());
                cmds = new ArrayList();
                cmds.add(CommandFactory.newRetract((org.drools.runtime.rule.FactHandle)ksession.getFactHandle((Object)fire1)));
                cmds.add(CommandFactory.newFireAllRules());
                ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
            }
            catch (Exception e) {
                System.err.println("Exception in thread " + Thread.currentThread().getName() + ": " + e.getLocalizedMessage());
                throw e;
            }
            return events;
        }

        public static Collection<Callable<List<String>>> getSolvers() {
            ArrayList<Callable<List<String>>> solvers = new ArrayList<Callable<List<String>>>();
            for (int i = 0; i < 3; ++i) {
                solvers.add(new BatchRulesExecutor());
            }
            return solvers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RulesExecutor
    implements Callable<List<String>> {
        @Override
        public List<String> call() throws Exception {
            ArrayList<String> events = new ArrayList<String>();
            try {
                StatefulSession ksession = ruleBase.newStatefulSession();
                ksession.setGlobal("events", events);
                Room room1 = new Room("Room 1");
                ksession.insert((Object)room1);
                FactHandle fireFact1 = ksession.insert((Object)new Fire(room1));
                ksession.fireAllRules();
                Assert.assertEquals((int)1, (int)events.size());
                Sprinkler sprinkler1 = new Sprinkler(room1);
                ksession.insert((Object)sprinkler1);
                ksession.fireAllRules();
                Assert.assertEquals((int)2, (int)events.size());
                ksession.retract((org.drools.runtime.rule.FactHandle)fireFact1);
                ksession.fireAllRules();
            }
            catch (Exception e) {
                System.err.println("Exception in thread " + Thread.currentThread().getName() + ": " + e.getLocalizedMessage());
                throw e;
            }
            return events;
        }

        public static Collection<Callable<List<String>>> getSolvers() {
            ArrayList<Callable<List<String>>> solvers = new ArrayList<Callable<List<String>>>();
            for (int i = 0; i < 3; ++i) {
                solvers.add(new RulesExecutor());
            }
            return solvers;
        }
    }
}

