/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.drools.Cell;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.Neighbor;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.compiler.PackageBuilder;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.DefaultAgendaEventListener;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaGroup;
import org.junit.Test;

public class ExecutionFlowControlTest
extends CommonTestMethodBase {
    @Test
    public void testSalienceIntegerAndDepthCrs() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_salienceIntegerRule.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person person = new Person("Edson", "cheese");
        workingMemory.insert((Object)person);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((String)"Three rules should have been fired", (int)3, (int)list.size());
        ExecutionFlowControlTest.assertEquals((String)"Rule 4 should have been fired first", (Object)"Rule 4", list.get(0));
        ExecutionFlowControlTest.assertEquals((String)"Rule 2 should have been fired second", (Object)"Rule 2", list.get(1));
        ExecutionFlowControlTest.assertEquals((String)"Rule 3 should have been fired third", (Object)"Rule 3", list.get(2));
    }

    @Test
    public void testSalienceExpression() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_salienceExpressionRule.drl")));
        if (builder.hasErrors()) {
            ExecutionFlowControlTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person person10 = new Person("bob", "cheese", 10);
        workingMemory.insert((Object)person10);
        Person person20 = new Person("mic", "cheese", 20);
        workingMemory.insert((Object)person20);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((String)"Two rules should have been fired", (int)2, (int)list.size());
        ExecutionFlowControlTest.assertEquals((String)"Rule 3 should have been fired first", (Object)"Rule 3", list.get(0));
        ExecutionFlowControlTest.assertEquals((String)"Rule 2 should have been fired second", (Object)"Rule 2", list.get(1));
    }

    @Test
    public void testSalienceMinInteger() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        String text = "package org.drools.test\nglobal java.util.List list\nrule a\nwhen\nthen\n    list.add( \"a\" );\nend\n\nrule b\n   salience ( Integer.MIN_VALUE )\nwhen\nthen\n    list.add( \"b\" );\nend\n\nrule c\nwhen\nthen\n    list.add( \"c\" );\nend\n";
        builder.addPackageFromDrl((Reader)new StringReader(text));
        if (builder.hasErrors()) {
            ExecutionFlowControlTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((Object)"b", list.get(2));
    }

    @Test
    public void testNoLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("no-loop.drl")));
        if (builder.hasErrors()) {
            ExecutionFlowControlTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((String)"Should not loop  and thus size should be 1", (int)1, (int)list.size());
    }

    @Test
    public void testNoLoopWithModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("no-loop_with_modify.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((String)"Should not loop  and thus size should be 1", (int)1, (int)list.size());
        ExecutionFlowControlTest.assertEquals((int)50, (int)brie.getPrice());
    }

    @Test
    public void testLockOnActive() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LockOnActive.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie12 = new Cheese("brie", 12);
        workingMemory.insert((Object)brie12);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        AgendaGroup group1 = agenda.getAgendaGroup("group1");
        ExecutionFlowControlTest.assertEquals((int)1, (int)group1.size());
        workingMemory.setFocus("group1");
        Cheese brie10 = new Cheese("brie", 10);
        workingMemory.insert((Object)brie10);
        ExecutionFlowControlTest.assertEquals((int)1, (int)group1.size());
        Cheese cheddar20 = new Cheese("cheddar", 20);
        workingMemory.insert((Object)cheddar20);
        AgendaGroup group2 = agenda.getAgendaGroup("group1");
        ExecutionFlowControlTest.assertEquals((int)1, (int)group2.size());
        RuleFlowGroupImpl rfg = (RuleFlowGroupImpl)agenda.getRuleFlowGroup("ruleflow2");
        rfg.setActive(true);
        Cheese cheddar17 = new Cheese("cheddar", 17);
        workingMemory.insert((Object)cheddar17);
        ExecutionFlowControlTest.assertEquals((int)1, (int)group2.size());
    }

    @Test
    public void testLockOnActiveForMain() {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    lock-on-active true \n";
        str = str + "when \n";
        str = str + "    $str : String() \n";
        str = str + "then \n";
        str = str + "    list.add( $str ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        ExecutionFlowControlTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"hello1");
        ksession.insert((Object)"hello2");
        ksession.insert((Object)"hello3");
        ksession.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)3, (int)list.size());
        ksession.insert((Object)"hello4");
        ksession.insert((Object)"hello5");
        ksession.insert((Object)"hello6");
        ksession.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)6, (int)list.size());
    }

    @Test
    public void testLockOnActiveForMainWithHalt() {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    lock-on-active true \n";
        str = str + "when \n";
        str = str + "    $str : String() \n";
        str = str + "then \n";
        str = str + "    list.add( $str ); \n";
        str = str + "    if ( list.size() == 2 ) {\n        drools.halt();\n    }";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        ExecutionFlowControlTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"hello1");
        ksession.insert((Object)"hello2");
        ksession.insert((Object)"hello3");
        ksession.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)2, (int)list.size());
        ksession.insert((Object)"hello4");
        ksession.insert((Object)"hello5");
        ksession.insert((Object)"hello6");
        ksession.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testLockOnActiveWithModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LockOnActiveWithUpdate.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 13);
        Person bob = new Person("bob");
        bob.setCheese(brie);
        Person mic = new Person("mic");
        mic.setCheese(brie);
        Person mark = new Person("mark");
        mark.setCheese(brie);
        FactHandle brieHandle = wm.insert((Object)brie);
        wm.insert((Object)bob);
        wm.insert((Object)mic);
        wm.insert((Object)mark);
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        AgendaGroup group1 = agenda.getAgendaGroup("group1");
        agenda.setFocus(group1);
        ExecutionFlowControlTest.assertEquals((int)3, (int)group1.size());
        agenda.fireNextItem(null);
        ExecutionFlowControlTest.assertEquals((int)2, (int)group1.size());
        wm.update((org.drools.runtime.rule.FactHandle)brieHandle, (Object)brie);
        ExecutionFlowControlTest.assertEquals((int)2, (int)group1.size());
        AgendaGroup group2 = agenda.getAgendaGroup("group2");
        agenda.setFocus(group2);
        RuleFlowGroupImpl rfg = (RuleFlowGroupImpl)((DefaultAgenda)wm.getAgenda()).getRuleFlowGroup("ruleflow2");
        ExecutionFlowControlTest.assertEquals((int)3, (int)rfg.size());
        agenda.activateRuleFlowGroup("ruleflow2");
        agenda.fireNextItem(null);
        ExecutionFlowControlTest.assertEquals((int)2, (int)rfg.size());
        wm.update((org.drools.runtime.rule.FactHandle)brieHandle, (Object)brie);
        ExecutionFlowControlTest.assertEquals((int)2, (int)group2.size());
    }

    @Test
    public void testLockOnActiveWithModify2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LockOnActiveWithModify.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        int size = 3;
        Cell[][] cells = new Cell[3][];
        FactHandle[][] handles = new FactHandle[3][];
        for (int row = 0; row < 3; ++row) {
            cells[row] = new Cell[3];
            handles[row] = new FactHandle[3];
            for (int col = 0; col < 3; ++col) {
                cells[row][col] = new Cell(2, row, col);
                handles[row][col] = session.insert((Object)cells[row][col]);
                if (row >= 1 && col >= 1) {
                    session.insert((Object)new Neighbor(cells[row - 1][col - 1], cells[row][col]));
                    session.insert((Object)new Neighbor(cells[row][col], cells[row - 1][col - 1]));
                }
                if (row >= 1) {
                    session.insert((Object)new Neighbor(cells[row - 1][col], cells[row][col]));
                    session.insert((Object)new Neighbor(cells[row][col], cells[row - 1][col]));
                }
                if (row >= 1 && col < 2) {
                    session.insert((Object)new Neighbor(cells[row - 1][col + 1], cells[row][col]));
                    session.insert((Object)new Neighbor(cells[row][col], cells[row - 1][col + 1]));
                }
                if (col < 1) continue;
                session.insert((Object)new Neighbor(cells[row][col - 1], cells[row][col]));
                session.insert((Object)new Neighbor(cells[row][col], cells[row][col - 1]));
            }
        }
        session.clearAgendaGroup("calculate");
        int fired = session.fireAllRules(100);
        ExecutionFlowControlTest.assertEquals((int)0, (int)fired);
        session.setFocus("calculate");
        fired = session.fireAllRules(100);
        ExecutionFlowControlTest.assertEquals((int)0, (int)fired);
        ExecutionFlowControlTest.assertEquals((String)"MAIN", (String)session.getAgenda().getFocusName());
        cells[0][0].setState(1);
        session.update((org.drools.runtime.rule.FactHandle)handles[0][0], (Object)cells[0][0]);
        session.setFocus("birth");
        session.setFocus("calculate");
        fired = session.fireAllRules(100);
        int[][] expected = new int[][]{{0, 1, 0}, {1, 1, 0}, {0, 0, 0}};
        this.assertEqualsMatrix(3, cells, expected);
        ExecutionFlowControlTest.assertEquals((String)"MAIN", (String)session.getAgenda().getFocusName());
        cells[1][1].setState(1);
        session.update((org.drools.runtime.rule.FactHandle)handles[1][1], (Object)cells[1][1]);
        session.setFocus("calculate");
        session.fireAllRules(100);
        expected = new int[][]{{1, 2, 1}, {2, 1, 1}, {1, 1, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        ExecutionFlowControlTest.assertEquals((String)"MAIN", (String)session.getAgenda().getFocusName());
        session.setFocus("birth");
        session.fireAllRules(100);
        expected = new int[][]{{1, 2, 1}, {2, 1, 1}, {1, 1, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        ExecutionFlowControlTest.assertEquals((String)"MAIN", (String)session.getAgenda().getFocusName());
        session.setFocus("calculate");
        session.fireAllRules(100);
        expected = new int[][]{{3, 3, 2}, {3, 3, 2}, {2, 2, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        ExecutionFlowControlTest.assertEquals((String)"MAIN", (String)session.getAgenda().getFocusName());
        cells[0][0].setState(2);
        session.update((org.drools.runtime.rule.FactHandle)handles[0][0], (Object)cells[0][0]);
        session.setFocus("calculate");
        session.fireAllRules(100);
        expected = new int[][]{{3, 2, 2}, {2, 2, 2}, {2, 2, 1}};
        this.assertEqualsMatrix(3, cells, expected);
        ExecutionFlowControlTest.assertEquals((String)"MAIN", (String)session.getAgenda().getFocusName());
    }

    private void assertEqualsMatrix(int size, Cell[][] cells, int[][] expected) {
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                ExecutionFlowControlTest.assertEquals((String)("Wrong value at " + row + "," + col + ": "), (int)expected[row][col], (int)cells[row][col].getValue());
            }
        }
    }

    @Test
    public void testAgendaGroups() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_AgendaGroups.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        ExecutionFlowControlTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)7, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"group3", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"group4", list.get(1));
        ExecutionFlowControlTest.assertEquals((Object)"group3", list.get(2));
        ExecutionFlowControlTest.assertEquals((Object)"MAIN", list.get(3));
        ExecutionFlowControlTest.assertEquals((Object)"group1", list.get(4));
        ExecutionFlowControlTest.assertEquals((Object)"group1", list.get(5));
        ExecutionFlowControlTest.assertEquals((Object)"MAIN", list.get(6));
        session.getAgenda().getAgendaGroup("group2").setFocus();
        session.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)8, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"group2", list.get(7));
        list.clear();
        session.insert((Object)new Cheese("cheddar"));
        session.getAgenda().getAgendaGroup("MAIN").clear();
        session.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)3, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"group3", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"group4", list.get(1));
        ExecutionFlowControlTest.assertEquals((Object)"group3", list.get(2));
    }

    @Test
    public void testActivationGroups() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ActivationGroups.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        ActivationGroup activationGroup0 = agenda.getActivationGroup("activation-group-0");
        ExecutionFlowControlTest.assertEquals((int)2, (int)activationGroup0.size());
        ActivationGroup activationGroup3 = agenda.getActivationGroup("activation-group-3");
        ExecutionFlowControlTest.assertEquals((int)1, (int)activationGroup3.size());
        AgendaGroup agendaGroup3 = agenda.getAgendaGroup("agenda-group-3");
        ExecutionFlowControlTest.assertEquals((int)1, (int)agendaGroup3.size());
        AgendaGroup agendaGroupMain = agenda.getAgendaGroup("MAIN");
        ExecutionFlowControlTest.assertEquals((int)3, (int)agendaGroupMain.size());
        workingMemory.clearAgendaGroup("agenda-group-3");
        ExecutionFlowControlTest.assertEquals((int)0, (int)activationGroup3.size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)agendaGroup3.size());
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)activationGroup0.size());
        ExecutionFlowControlTest.assertEquals((int)2, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"rule0", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"rule2", list.get(1));
    }

    @Test
    public void testActivationGroupWithTroubledSyntax() {
        String str = "package BROKEN_TEST;\nimport " + Holder.class.getCanonicalName() + ";\n" + "rule \"_12\"\n" + "    \n" + "    salience 3\n" + "    activation-group \"BROKEN\"\n" + "    when\n" + "        $a : Holder(value in (0))\n" + "    then\n" + "        System.out.println(\"setting 0\");\n" + "        $a.setOutcome(\"setting 0\");\n" + "end\n" + "\n" + "rule \"_13\"\n" + "    \n" + "    salience 2\n" + "    activation-group \"BROKEN\"\n" + "    when\n" + "        $a : Holder(value in (1))\n" + "    then\n" + "        System.out.println(\"setting 1\");\n" + "        $a.setOutcome(\"setting 1\");\n" + "end\n" + "\n" + "rule \"_22\"\n" + "    \n" + "    salience 1\n" + "    activation-group \"BROKEN\"\n" + "    when\n" + "        $a : Holder(value == null)\n" + "    then\n" + "        System.out.println(\"setting null\");\n" + "        $a.setOutcome(\"setting null\");\n" + "end\n" + "\n" + "";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println("Errors");
            KnowledgeBuilderErrors errors = kBuilder.getErrors();
            for (KnowledgeBuilderError kbe : errors) {
                System.err.println(kbe.getMessage());
                for (int errLine : kbe.getLines()) {
                    System.err.println(errLine);
                }
            }
            System.exit(1);
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection knowledgePackages = kBuilder.getKnowledgePackages();
        kbase.addKnowledgePackages(knowledgePackages);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Holder inrec = new Holder(1);
        System.out.println("Holds: " + inrec.getValue());
        session.insert((Object)inrec);
        session.fireAllRules();
        Assert.assertEquals((int)1, (int)session.getFactHandles().size());
        Assert.assertEquals((String)"setting 1", (String)inrec.getOutcome());
        session.dispose();
        session = this.createKnowledgeSession(kbase);
        inrec = new Holder(null);
        System.out.println("Holds: " + inrec.getValue());
        session.insert((Object)inrec);
        session.fireAllRules();
        Assert.assertEquals((int)1, (int)session.getFactHandles().size());
        Assert.assertEquals((String)"setting null", (String)inrec.getOutcome());
        session.dispose();
        session = this.createKnowledgeSession(kbase);
        inrec = new Holder(0);
        System.out.println("Holds: " + inrec.getValue());
        session.insert((Object)inrec);
        session.fireAllRules();
        Assert.assertEquals((int)1, (int)session.getFactHandles().size());
        Assert.assertEquals((String)"setting 0", (String)inrec.getOutcome());
    }

    @Test
    public void testInsertRetractNoloop() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Insert_Retract_Noloop.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 15));
        wm.fireAllRules();
    }

    @Test
    public void testUpdateNoLoop() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_UpdateNoloop.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 15));
        wm.fireAllRules();
    }

    @Test
    public void testUpdateActivationCreationNoLoop() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_UpdateActivationCreationNoLoop.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        InternalWorkingMemoryActions wm = (InternalWorkingMemoryActions)ruleBase.newStatefulSession();
        final ArrayList created = new ArrayList();
        final ArrayList cancelled = new ArrayList();
        DefaultAgendaEventListener l = new DefaultAgendaEventListener(){

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                created.add(event);
            }

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                cancelled.add(event);
            }
        };
        wm.addEventListener((AgendaEventListener)l);
        Cheese stilton = new Cheese("stilton", 15);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        Person p1 = new Person("p1");
        p1.setCheese(stilton);
        wm.insert((Object)p1);
        Person p2 = new Person("p2");
        p2.setCheese(stilton);
        wm.insert((Object)p2);
        Person p3 = new Person("p3");
        p3.setCheese(stilton);
        wm.insert((Object)p3);
        ExecutionFlowControlTest.assertEquals((int)3, (int)created.size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)cancelled.size());
        Activation item = ((ActivationCreatedEvent)created.get(2)).getActivation();
        wm.update(stiltonHandle, (Object)stilton, Long.MAX_VALUE, item);
        ExecutionFlowControlTest.assertEquals((int)3, (int)created.size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)cancelled.size());
    }

    @Test
    public void testRuleFlowGroup() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflowgroup.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)"Test");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        workingMemory.getAgenda().activateRuleFlowGroup("Group1");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testRuleFlowGroupDeactivate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflowgroup2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)"Test");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        ExecutionFlowControlTest.assertEquals((int)2, (int)workingMemory.getAgenda().getRuleFlowGroup("Group1").size());
        workingMemory.getAgenda().activateRuleFlowGroup("Group1");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testRuleFlowGroupInActiveMode() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflowgroup.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)"Test");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        workingMemory.getAgenda().activateRuleFlowGroup("Group1");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)1, (int)list.size());
        workingMemory.halt();
    }

    @Test
    public void testDateEffective() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EffectiveDate.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Message message = new Message("hola");
        workingMemory.insert((Object)message);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertFalse((boolean)message.isFired());
    }

    public static class Holder {
        private Integer val;
        private String outcome;

        public Holder(Integer val) {
            this.val = val;
        }

        public void setValue(Integer val) {
            this.val = val;
        }

        public Integer getValue() {
            return this.val;
        }

        public void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        public String getOutcome() {
            return this.outcome;
        }
    }
}

