/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.Mailbox;
import org.drools.Message;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionConstraintsTest
extends CommonTestMethodBase {
    @Test
    public void testExpressionConstraints1() {
        String drl = "package org.drools\nimport org.drools.Mailbox.FolderType;\nrule R1\n        dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $folderType : getDefaultFolderType(),\n                FolderType.INBOX == $folderType,\n                $folderType == FolderType.INBOX,\n                $mailForFolder2 : getMailTypeForFolderType(getDefaultFolderType()),\n                FolderType.SENT != getDefaultFolderType(), \n                getDefaultFolderType() != FolderType.SENT, \n                getMailTypeForFolderType($folderType) == MailType.WORK,\n                1 > 0\n        )\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Mailbox mbox = new Mailbox("me@test.com");
        Message message = new Message();
        message.setMessage("Welcome");
        message.setStatus(0);
        mbox.getFolder(Mailbox.FolderType.INBOX).add(message);
        ksession.insert((Object)mbox);
        ksession.insert((Object)message);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testExpressionConstraints2() {
        String drl = "package org.drools\nimport org.drools.Mailbox.FolderType;\nrule R1\n    dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $me : owneremail,\n                recentContacts[Mailbox.TEST_EMAIL] != null,\n                recentContacts[\"me@test.com\"] != null,\n                $d1 : recentContacts[Mailbox.TEST_EMAIL],\n                $d2 : recentContacts[\"me@test.com\"],\n                recentContacts.get(owneremail) != null,\n                recentContacts.get($me) != null,\n                recentContacts[$me] != null,\n                $d3: recentContacts.get(owneremail),\n                // Waiting for MVEL fixes for the following 2 scenarios                // recentContacts[owneremail] != null,\n                // recentContacts[getOwneremail()] != null,\n                0 < 1\n        )\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Mailbox mbox = new Mailbox("me@test.com");
        Message message = new Message();
        message.setMessage("Welcome");
        message.setStatus(0);
        mbox.getFolder(Mailbox.FolderType.INBOX).add(message);
        ksession.insert((Object)mbox);
        ksession.insert((Object)message);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testExpressionConstraints3() {
        String drl = "package org.drools\nimport org.drools.Mailbox.FolderType\nrule R1\n    dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $type1 : FolderType.INBOX,\n                $type2 : org.drools.Mailbox$FolderType.INBOX,\n                $work1 : getFolder(null),\n                $work2 : getFolder(org.drools.Mailbox$FolderType.INBOX),\n                $work3 : getFolder(FolderType.INBOX),\n                getFolder($type1) != null,\n                getFolder($type1).size() > 0,\n                ! getFolder($type1).isEmpty(),\n                $work6 : folders,\n                $work7 : folders.size,\n                //folders.containsKey(FolderType.INBOX),\n                folders.containsKey(org.drools.Mailbox$FolderType.INBOX),\n                folders.containsKey($type2),\n                !folders.isEmpty,\n                getFolder(FolderType.INBOX) != null,\n                //$v1 : folders[FolderType.INBOX], \n                //$v2 : folders[com.sample.Mailbox.FolderType.INBOX],\n                //$v3 : folders[com.sample.Mailbox$FolderType.INBOX],\n                //folders[$type1]!=null,\n                //folders.get(FolderType.INBOX)!=null, // sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl cannot be cast to java.lang.Class\n                //folders.isEmpty(),  // SAME ERROR\n                0 < 1\n        )\n    then\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Mailbox mbox = new Mailbox("me@test.com");
        Message message = new Message();
        message.setMessage("Welcome");
        message.setStatus(0);
        mbox.getFolder(Mailbox.FolderType.INBOX).add(message);
        ksession.insert((Object)mbox);
        ksession.insert((Object)message);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testExpressionConstraints4() {
        String drl = "package org.drools\nrule R1\n        dialect \"mvel\"\n    when\n        Mailbox( owneremail == 'bob@mail' || owneremail == 'john@mail' )\n    then\nend\nrule R2\n        dialect \"mvel\"\n    when\n        Mailbox( ( owneremail == 'bob@mail' ) || ( owneremail == 'john@mail' ) )\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Mailbox("foo@mail"));
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)rules);
        ksession.insert((Object)new Mailbox("john@mail"));
        rules = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)rules);
    }
}

