/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.type.FactType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ByteArrayResource;
import org.drools.runtime.ClassObjectFilter;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class ExtendsTest
extends CommonTestMethodBase {
    public StatefulKnowledgeSession genSession(String source) {
        return this.genSession(new String[]{source}, 0);
    }

    public StatefulKnowledgeSession genSession(String source, int numerrors) {
        return this.genSession(new String[]{source}, numerrors);
    }

    public StatefulKnowledgeSession genSession(String[] sources, int numerrors) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String source : sources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)source, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        }
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.getErrors().size() > 0) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
        }
        ExtendsTest.assertEquals((int)numerrors, (int)errors.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return this.createKnowledgeSession(kbase);
    }

    @Test
    public void testExtends() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_Extends.drl");
        FactType person = ksession.getKnowledgeBase().getFactType("defaultpkg", "Person");
        FactType eqPair = ksession.getKnowledgeBase().getFactType("defaultpkg", "EqualityPair");
        Object p = person.newInstance();
        ExtendsTest.assertNotNull((Object)p);
        ksession.insert((Object)"Populate");
        ksession.fireAllRules();
        ExtendsTest.assertEquals((int)6, (int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(person.getFactClass())).size());
        ExtendsTest.assertEquals((int)10, (int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(eqPair.getFactClass())).size());
        ksession.dispose();
    }

    @Test
    public void testGeneratedMethods() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_Extends.drl");
        FactType student = ksession.getKnowledgeBase().getFactType("defaultpkg", "Student");
        Constructor constructor = student.getFactClass().getConstructor(String.class, Integer.TYPE, String.class);
        ExtendsTest.assertNotNull(constructor);
        Method equals = student.getFactClass().getMethod("equals", Object.class);
        ExtendsTest.assertNotNull((Object)equals);
        Object s1 = constructor.newInstance("John", 18, "Skool");
        ExtendsTest.assertNotNull(s1);
        ExtendsTest.assertEquals((String)"Student( name=John, age=18, school=Skool )", (String)s1.toString());
        Object s2 = constructor.newInstance("John", 25, "Skool");
        ExtendsTest.assertNotNull(s2);
        ExtendsTest.assertEquals((String)"Student( name=John, age=25, school=Skool )", (String)s2.toString());
        ExtendsTest.assertEquals((int)s1.hashCode(), (int)s2.hashCode());
        ExtendsTest.assertTrue((boolean)((Boolean)equals.invoke(s1, s2)));
        ExtendsTest.assertTrue((boolean)s1.equals(s2));
        Object s3 = constructor.newInstance("Mark", 18, "Skool");
        ExtendsTest.assertNotNull(s3);
        ExtendsTest.assertEquals((String)"Student( name=Mark, age=18, school=Skool )", (String)s3.toString());
        ExtendsTest.assertNotSame((Object)s1.hashCode(), (Object)s3.hashCode());
        ExtendsTest.assertNotSame((Object)s2.hashCode(), (Object)s3.hashCode());
        ExtendsTest.assertFalse((boolean)s1.equals(s3));
        ExtendsTest.assertFalse((boolean)s2.equals(s3));
        Object s4 = constructor.newInstance("John", 25, "AnotherSkool");
        ExtendsTest.assertNotNull(s4);
        ExtendsTest.assertEquals((String)"Student( name=John, age=25, school=AnotherSkool )", (String)s4.toString());
        ExtendsTest.assertNotSame((Object)s1.hashCode(), (Object)s4.hashCode());
        ExtendsTest.assertNotSame((Object)s2.hashCode(), (Object)s4.hashCode());
        ExtendsTest.assertNotSame((Object)s3.hashCode(), (Object)s4.hashCode());
        ExtendsTest.assertFalse((boolean)s1.equals(s4));
        ExtendsTest.assertFalse((boolean)s2.equals(s4));
        ExtendsTest.assertFalse((boolean)s3.equals(s4));
        ksession.dispose();
    }

    @Test
    public void testDeepExt() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_Extends.drl");
        FactType LTstudent = ksession.getKnowledgeBase().getFactType("defaultpkg", "LongTermStudent");
        Constructor constructor = LTstudent.getFactClass().getConstructor(String.class, Integer.TYPE, String.class, String.class, Integer.TYPE);
        ExtendsTest.assertNotNull(constructor);
        Object ls1 = constructor.newInstance("John", 18, "Skool", "C1245", 4);
        Object ls2 = constructor.newInstance("John", 33, "Skool", "C1421", 4);
        ExtendsTest.assertEquals(ls1, ls2);
        ksession.dispose();
    }

    @Test
    public void testIllegalExtendsLegacy() throws Exception {
        this.genSession("test_ExtLegacyIllegal.drl", 2);
    }

    @Test
    public void testExtendsLegacy() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_ExtLegacy.drl", 0);
        FactType leg = ksession.getKnowledgeBase().getFactType("org.drools", "BetterLegacy");
        ExtendsTest.assertNotNull((Object)leg);
        Object b = leg.newInstance();
        ExtendsTest.assertEquals((Object)3.3, (Object)leg.get(b, "doubleField"));
        ExtendsTest.assertNull((Object)leg.get(b, "objField"));
        ExtendsTest.assertEquals((Object)245, (Object)leg.get(b, "intField"));
        ExtendsTest.assertEquals((Object)"XX", (Object)leg.get(b, "strField"));
        ExtendsTest.assertEquals((Object)true, (Object)leg.get(b, "prop"));
        ExtendsTest.assertEquals((Object)"Hello", (Object)leg.get(b, "oneMoreField"));
        System.out.println(b);
    }

    public void testExtendsAcrossFiles() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession(new String[]{"test_Ext1.drl", "test_Ext2.drl", "test_Ext3.drl", "test_Ext4.drl"}, 0);
        FactType person = ksession.getKnowledgeBase().getFactType("org.drools.compiler.test", "Person");
        ExtendsTest.assertNotNull((Object)person);
        FactType student = ksession.getKnowledgeBase().getFactType("org.drools.compiler.test", "Student");
        ExtendsTest.assertNotNull((Object)student);
        FactType worker = ksession.getKnowledgeBase().getFactType("org.drools.compiler.anothertest", "Worker");
        ExtendsTest.assertNotNull((Object)worker);
        FactType ltss = ksession.getKnowledgeBase().getFactType("defaultpkg", "SubLTStudent");
        ExtendsTest.assertNotNull((Object)ltss);
        Constructor ctor = worker.getFactClass().getConstructor(String.class, Integer.TYPE, String.class, Double.TYPE, Integer.TYPE);
        ExtendsTest.assertNotNull(ctor);
        Object w = ctor.newInstance("Adam", 20, "Carpenter", 150.0, 40);
        System.out.println(w);
        ExtendsTest.assertEquals((Object)"Adam", (Object)worker.get(w, "name"));
        ksession.fireAllRules();
    }

    public void testFieldInit() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_ExtFieldInit.drl");
        FactType test = ksession.getKnowledgeBase().getFactType("org.drools.compiler", "MyBean3");
        Object x = test.newInstance();
        ExtendsTest.assertNotNull((Object)x);
        ExtendsTest.assertEquals((Object)12, (Object)test.get(x, "fieldint"));
        ExtendsTest.assertEquals((Object)"xyz", (Object)test.get(x, "fieldstr"));
        ExtendsTest.assertEquals((Object)3.23, (Object)test.get(x, "fielddbl"));
        ExtendsTest.assertEquals((Object)0, (Object)test.get(x, "field0"));
        ExtendsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)test.get(x, "field1"));
        ExtendsTest.assertEquals((Object)Float.valueOf(1.2f), (Object)test.get(x, "fieldflt"));
        short sht = 2;
        ExtendsTest.assertEquals((Object)sht, (Object)test.get(x, "fieldsht"));
        ExtendsTest.assertEquals((Object)0, (Object)test.get(x, "field2"));
        byte byt = 1;
        ExtendsTest.assertEquals((Object)byt, (Object)test.get(x, "fieldbyt"));
        ExtendsTest.assertEquals((Object)true, (Object)test.get(x, "fieldbln"));
        ExtendsTest.assertEquals((Object)Character.valueOf('x'), (Object)test.get(x, "fieldchr"));
        ExtendsTest.assertEquals((Object)9999L, (Object)test.get(x, "fieldlng"));
        System.out.println(x);
    }

    public void testBoxedFieldInit() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_ExtFieldInit.drl");
        FactType test = ksession.getKnowledgeBase().getFactType("org.drools.compiler", "MyBoxBean");
        Object x = test.newInstance();
        ExtendsTest.assertNotNull((Object)x);
        ExtendsTest.assertEquals((Object)12, (Object)test.get(x, "fieldint"));
        ExtendsTest.assertEquals((Object)3.23, (Object)test.get(x, "fielddbl"));
        ExtendsTest.assertEquals((Object)Float.valueOf(1.2f), (Object)test.get(x, "fieldflt"));
        short sht = 2;
        ExtendsTest.assertEquals((Object)sht, (Object)test.get(x, "fieldsht"));
        byte byt = 1;
        ExtendsTest.assertEquals((Object)byt, (Object)test.get(x, "fieldbyt"));
        ExtendsTest.assertEquals((Object)true, (Object)test.get(x, "fieldbln"));
        ExtendsTest.assertEquals((Object)Character.valueOf('x'), (Object)test.get(x, "fieldchr"));
        ExtendsTest.assertEquals((Object)9999L, (Object)test.get(x, "fieldlng"));
        System.out.println(x);
    }

    public void testExpressionFieldInit() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_ExtFieldInit.drl");
        FactType test = ksession.getKnowledgeBase().getFactType("org.drools.compiler", "MyBoxExpressionBean");
        Object x = test.newInstance();
        ExtendsTest.assertNotNull((Object)x);
        ExtendsTest.assertEquals((Object)"foobar", (Object)test.get(x, "f0"));
        ExtendsTest.assertEquals((Object)-32, (Object)test.get(x, "fieldint"));
        ExtendsTest.assertEquals((Object)4.0, (Object)test.get(x, "fielddbl"));
        ExtendsTest.assertEquals((Object)Float.valueOf(0.5f), (Object)test.get(x, "fieldflt"));
        short sht = 6;
        ExtendsTest.assertEquals((Object)sht, (Object)test.get(x, "fieldsht"));
        byte byt = 2;
        ExtendsTest.assertEquals((Object)byt, (Object)test.get(x, "fieldbyt"));
        ExtendsTest.assertEquals((Object)true, (Object)test.get(x, "fieldbln"));
        ExtendsTest.assertEquals((Object)Character.valueOf('x'), (Object)test.get(x, "fieldchr"));
        ExtendsTest.assertEquals((Object)9999L, (Object)test.get(x, "fieldlng"));
        System.out.println(x);
        FactType test2 = ksession.getKnowledgeBase().getFactType("org.drools.compiler", "MySimpleExpressionBean");
        x = test2.newInstance();
        ExtendsTest.assertNotNull((Object)x);
        ExtendsTest.assertEquals((Object)"foobar", (Object)test2.get(x, "f0"));
        ExtendsTest.assertEquals((Object)-32, (Object)test2.get(x, "fieldint"));
        ExtendsTest.assertEquals((Object)4.0, (Object)test2.get(x, "fielddbl"));
        ExtendsTest.assertEquals((Object)Float.valueOf(0.5f), (Object)test2.get(x, "fieldflt"));
        sht = 6;
        ExtendsTest.assertEquals((Object)sht, (Object)test2.get(x, "fieldsht"));
        byt = 2;
        ExtendsTest.assertEquals((Object)byt, (Object)test2.get(x, "fieldbyt"));
        ExtendsTest.assertEquals((Object)true, (Object)test2.get(x, "fieldbln"));
        ExtendsTest.assertEquals((Object)Character.valueOf('x'), (Object)test2.get(x, "fieldchr"));
        ExtendsTest.assertEquals((Object)9999L, (Object)test2.get(x, "fieldlng"));
        System.out.println(x);
    }

    public void testHierarchy() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_ExtHierarchy.drl");
        ksession.setGlobal("list", new LinkedList());
        ksession.fireAllRules();
        ExtendsTest.assertEquals((int)1, (int)((List)ksession.getGlobal("list")).size());
    }

    @Test
    public void testExtendOverride() {
        String drl = "package test.beans;\n\nimport java.util.List;\nimport java.util.ArrayList;\n\nglobal List ans;\n\ndeclare ArrayList\nend\ndeclare Bean extends ArrayList\n  fld : int = 4 \n  myField : String = \"xxx\" \nend\n\ndeclare Bean2 extends Bean\n  moref : double\n  myField : String\nend\nrule \"Init\"\nwhen\nthen\n  Bean b = new Bean2();\n  ans.add(b);  System.out.println(b);\t\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ExtendsTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList out = new ArrayList();
        ksession.setGlobal("ans", out);
        ksession.fireAllRules();
        Object x = out.get(0);
        FactType type = kbase.getFactType("test.beans", "Bean2");
        ExtendsTest.assertEquals((Object)4, (Object)type.get(x, "fld"));
        ExtendsTest.assertEquals((Object)"xxx", (Object)type.get(x, "myField"));
        ExtendsTest.assertEquals((Object)0.0, (Object)type.get(x, "moref"));
        ExtendsTest.assertTrue((boolean)(x instanceof ArrayList));
    }

    @Test
    public void testRedefineDefaults() throws Exception {
        StatefulKnowledgeSession ksession = this.genSession("test_Extends.drl");
        FactType person = ksession.getKnowledgeBase().getFactType("defaultpkg", "Person");
        FactType student = ksession.getKnowledgeBase().getFactType("defaultpkg", "Student");
        Object p = person.newInstance();
        Object s = student.newInstance();
        ExtendsTest.assertNotNull((Object)p);
        ExtendsTest.assertNotNull((Object)s);
        ExtendsTest.assertEquals((Object)99, (Object)person.get(p, "age"));
        ExtendsTest.assertEquals((Object)18, (Object)person.get(s, "age"));
        ksession.dispose();
    }
}

