/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Properties;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.conf.DefaultDialectOption;
import org.drools.builder.conf.KnowledgeBuilderOption;
import org.drools.compiler.DroolsParserException;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.SequentialOption;
import org.drools.conf.ShareAlphaNodesOption;
import org.drools.conf.ShareBetaNodesOption;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailureOnRemovalTest
extends CommonTestMethodBase {
    private static final String LS = System.getProperty("line.separator");
    private static final String PACKAGE = "failure_on_removal";
    private static final String RULE_1 = "rule_1";
    private static final String RULE_2 = "rule_2";
    private static final String RULE_3 = "rule_3";
    private static final boolean SHARE_BETA_NODES = true;
    private static final boolean NOT_SHARE_BETA_NODES = false;

    @Test
    public void testWithBetaNodeSharing() throws Exception {
        this.runTest(true);
    }

    @Test
    public void testWithoutBetaNodeSharing() throws Exception {
        this.runTest(false);
    }

    private void runTest(boolean shareBetaNodes) throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase(shareBetaNodes);
        Collection<KnowledgePackage> rule1 = this.compileRule(RULE_1);
        kbase.addKnowledgePackages(rule1);
        Collection<KnowledgePackage> rule2 = this.compileRule(RULE_2);
        kbase.addKnowledgePackages(rule2);
        kbase.removeRule(PACKAGE, RULE_1);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int fired = ksession.fireAllRules();
        ksession.dispose();
        FailureOnRemovalTest.assertEquals((int)1, (int)fired);
        Collection<KnowledgePackage> rule3 = this.compileRule(RULE_3);
        kbase.addKnowledgePackages(rule3);
    }

    private Collection<KnowledgePackage> compileRule(String name) throws DroolsParserException, IOException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.createKnowledgeBuilderConfiguration());
        String drl = this.getDrl(name);
        StringReader drlReader = new StringReader(drl);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)drlReader), ResourceType.DRL);
        FailureOnRemovalTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.getKnowledgePackages();
    }

    private KnowledgeBuilderConfiguration createKnowledgeBuilderConfiguration() {
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilderConfiguration kconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)properties, (ClassLoader[])new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()});
        kconf.setOption((KnowledgeBuilderOption)DefaultDialectOption.get((String)"java"));
        return kconf;
    }

    private KnowledgeBase createKnowledgeBase(boolean shareBetaNodes) {
        KnowledgeBaseConfiguration ruleBaseConfiguration = this.createKnowledgeBaseConfiguration(shareBetaNodes);
        return KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)ruleBaseConfiguration);
    }

    private KnowledgeBaseConfiguration createKnowledgeBaseConfiguration(boolean shareBetaNodes) {
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)SequentialOption.NO);
        kconf.setOption((KnowledgeBaseOption)ShareAlphaNodesOption.YES);
        kconf.setOption((KnowledgeBaseOption)(shareBetaNodes ? ShareBetaNodesOption.YES : ShareBetaNodesOption.NO));
        return kconf;
    }

    private String getDrl(String name) {
        return new StringBuffer("package ").append(PACKAGE).append(LS).append("rule '").append(name).append('\'').append(LS).append("when").append(LS).append("eval (true)").append(LS).append("then").append(LS).append("end").append(LS).toString();
    }
}

