/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import java.util.List;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class FunctionsTest
extends CommonTestMethodBase {
    private KnowledgeBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbconf, String ... classPathResources) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbconf);
        for (String classPathResource : classPathResources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)classPathResource, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            FunctionsTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testFunction() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FunctionInConsequence.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        FunctionsTest.assertEquals((Object)new Integer(5), ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testFunctionException() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FunctionException.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        try {
            ksession.fireAllRules();
            FunctionsTest.fail((String)"Should throw an Exception from the Function");
        }
        catch (Exception e) {
            FunctionsTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    @Test
    public void testFunctionWithPrimitives() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FunctionWithPrimitives.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        FunctionsTest.assertEquals((Object)new Integer(10), list.get(0));
    }

    @Test
    public void testFunctionCallingFunctionWithEclipse() throws Exception {
        KnowledgeBuilderConfiguration kbconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbconf.setProperty("drools.dialect.java.compiler", "ECLIPSE");
        KnowledgeBase kbase = this.loadKnowledgeBase(kbconf, "test_functionCallingFunction.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.fireAllRules();
        FunctionsTest.assertEquals((int)1, (int)list.size());
        FunctionsTest.assertEquals((int)12, (int)((Integer)list.get(0)));
    }

    @Test
    public void testFunctionCallingFunctionWithJanino() throws Exception {
        KnowledgeBuilderConfiguration kbconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbconf.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBase kbase = this.loadKnowledgeBase(kbconf, "test_functionCallingFunction.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.fireAllRules();
        FunctionsTest.assertEquals((int)1, (int)list.size());
        FunctionsTest.assertEquals((int)12, (int)((Integer)list.get(0)));
    }

    @Test
    public void testJBRULES3117() {
        String str = "package org.drools\nfunction boolean isOutOfRange( Object value, int lower ) { return true; }\nfunction boolean isNotContainedInt( Object value, int[] values ) { return true; }\nrule R1\nwhen\nthen\n    boolean x = isOutOfRange( Integer.MAX_VALUE, 1 );\n    boolean y = isNotContainedInt( Integer.MAX_VALUE, new int[] { 1, 2, 3 } );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int rulesFired = ksession.fireAllRules();
        FunctionsTest.assertEquals((int)1, (int)rulesFired);
    }
}

