/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.runtime.Channel;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class IntegrationInterfacesTest
extends CommonTestMethodBase {
    private KnowledgeBase getKnowledgeBase(String resourceName) throws IOException, ClassNotFoundException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)resourceName, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        IntegrationInterfacesTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = this.getKnowledgeBase(kbuilder);
        return kbase;
    }

    private KnowledgeBase getKnowledgeBase(Reader[] readers) throws IOException, ClassNotFoundException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (Reader reader : readers) {
            kbuilder.add(ResourceFactory.newReaderResource((Reader)reader), ResourceType.DRL);
        }
        IntegrationInterfacesTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = this.getKnowledgeBase(kbuilder);
        return kbase;
    }

    private KnowledgeBase getKnowledgeBase(KnowledgeBuilder kbuilder) throws IOException, ClassNotFoundException {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        return kbase;
    }

    @Test
    public void testGlobals() throws Exception {
        KnowledgeBase kbase = this.getKnowledgeBase("globals_rule_test.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        List list = (List)Mockito.mock(List.class);
        ksession.setGlobal("list", (Object)list);
        ksession.setGlobal("string", (Object)"stilton");
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)list, (VerificationMode)Mockito.times((int)1))).add(new Integer(5));
    }

    @Test
    public void testGlobals2() throws Exception {
        KnowledgeBase kbase = this.getKnowledgeBase("test_globalsAsConstraints.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        List results = (List)Mockito.mock(List.class);
        ksession.setGlobal("results", (Object)results);
        List cheeseTypes = (List)Mockito.mock(List.class);
        ksession.setGlobal("cheeseTypes", (Object)cheeseTypes);
        Mockito.when((Object)cheeseTypes.contains("stilton")).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)cheeseTypes.contains("muzzarela")).thenReturn((Object)Boolean.TRUE);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).add("memberOf");
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).add("not memberOf");
    }

    @Test
    public void testGlobalMerge() throws Exception {
        String rule1 = "package com.sample\nrule \"rule 1\"\n    salience 10\n    when\n        l : java.util.List()\n    then\n        l.add( \"rule 1 executed\" );\nend\n";
        String rule2 = "package com.sample\nglobal String str;\nrule \"rule 2\"\n    when\n        l : java.util.List()\n    then\n        l.add( \"rule 2 executed \" + str);\nend\n";
        Reader[] readers = new StringReader[]{new StringReader(rule1), new StringReader(rule2)};
        KnowledgeBase kbase = this.getKnowledgeBase(readers);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("str", (Object)"boo");
        ArrayList list = new ArrayList();
        ksession.insert(list);
        ksession.fireAllRules();
        IntegrationInterfacesTest.assertEquals((String)"rule 1 executed", (String)((String)list.get(0)));
        IntegrationInterfacesTest.assertEquals((String)"rule 2 executed boo", (String)((String)list.get(1)));
    }

    @Test
    public void testChannels() throws IOException, ClassNotFoundException {
        KnowledgeBase kbase = this.getKnowledgeBase("test_Channels.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Channel someChannel = (Channel)Mockito.mock(Channel.class);
        ksession.registerChannel("someChannel", someChannel);
        ksession.insert((Object)new Cheese("brie", 30));
        ksession.insert((Object)new Cheese("stilton", 5));
        ksession.fireAllRules();
        ((Channel)Mockito.verify((Object)someChannel)).send((Object)"brie");
        ((Channel)Mockito.verify((Object)someChannel, (VerificationMode)Mockito.never())).send((Object)"stilton");
    }
}

