/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.ActivationListenerFactory;
import org.drools.Address;
import org.drools.Attribute;
import org.drools.Bar;
import org.drools.Cat;
import org.drools.Cell;
import org.drools.Cheese;
import org.drools.CheeseEqual;
import org.drools.Cheesery;
import org.drools.Child;
import org.drools.ClassObjectFilter;
import org.drools.CommonTestMethodBase;
import org.drools.DomainObjectHolder;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.FactC;
import org.drools.FactHandle;
import org.drools.FirstClass;
import org.drools.FromTestClass;
import org.drools.Guess;
import org.drools.IndexedNumber;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.MockPersistentSet;
import org.drools.Move;
import org.drools.ObjectWithSet;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.OuterClass;
import org.drools.Person;
import org.drools.PersonFinal;
import org.drools.PersonInterface;
import org.drools.PersonWithEquals;
import org.drools.Pet;
import org.drools.PolymorphicFact;
import org.drools.Primitives;
import org.drools.RandomNumber;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SecondClass;
import org.drools.Sensor;
import org.drools.SpecialString;
import org.drools.State;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.StockTick;
import org.drools.Target;
import org.drools.TestParam;
import org.drools.Triangle;
import org.drools.Win;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryConsoleLogger;
import org.drools.base.RuleNameEndsWithAgendaFilter;
import org.drools.base.RuleNameEqualsAgendaFilter;
import org.drools.base.RuleNameMatchesAgendaFilter;
import org.drools.base.RuleNameStartsWithAgendaFilter;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.DefaultAgenda;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.drools.compiler.xml.XmlDumper;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.type.FactType;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.DefaultWorkingMemoryEventListener;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.ObjectUpdatedEvent;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.DrlDumper;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidRulePackage;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.runtime.Environment;
import org.drools.runtime.Globals;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.AgendaFilter;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.Activation;
import org.drools.spi.ConsequenceExceptionHandler;
import org.drools.spi.GlobalResolver;
import org.drools.spi.PropagationContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscTest
extends CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(MiscTest.class);

    @Test
    public void testImportFunctions() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ImportFunctions.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese cheese = new Cheese("stilton", 15);
        session.insert((Object)cheese);
        List list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        int fired = session.fireAllRules();
        list = (List)session.getGlobal("list");
        MiscTest.assertEquals((int)4, (int)fired);
        MiscTest.assertEquals((int)4, (int)list.size());
        MiscTest.assertEquals((Object)"rule1", list.get(0));
        MiscTest.assertEquals((Object)"rule2", list.get(1));
        MiscTest.assertEquals((Object)"rule3", list.get(2));
        MiscTest.assertEquals((Object)"rule4", list.get(3));
    }

    @Test
    public void testStaticFieldReference() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_StaticField.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheesery cheesery1 = new Cheesery();
        cheesery1.setStatus(1);
        cheesery1.setMaturity(Cheesery.Maturity.OLD);
        session.insert((Object)cheesery1);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        Cheesery cheesery2 = new Cheesery();
        cheesery2.setStatus(0);
        cheesery2.setMaturity(Cheesery.Maturity.YOUNG);
        session.insert((Object)cheesery2);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)cheesery1, list.get(0));
        MiscTest.assertEquals((Object)cheesery2, list.get(1));
    }

    @Test
    public void testMetaConsequence() throws Exception {
        Package pkg = this.loadPackage("test_MetaConsequence.drl");
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        List results = new ArrayList();
        session.setGlobal("results", results);
        session.insert((Object)new Person("Michael"));
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        results = (List)session.getGlobal("results");
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"bar", results.get(0));
        MiscTest.assertEquals((Object)"bar2", results.get(1));
    }

    @Test
    public void testEnabledExpression() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_enabledExpression.drl")));
        Package pkg = builder.getPackage();
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        List results = new ArrayList();
        session.setGlobal("results", results);
        session.insert((Object)new Person("Michael"));
        results = (List)session.getGlobal("results");
        session.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains("1"));
        MiscTest.assertTrue((boolean)results.contains("2"));
        MiscTest.assertTrue((boolean)results.contains("3"));
    }

    @Test
    public void testGetStatefulKnowledgeSessions() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"empty.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession_1 = this.createKnowledgeSession(kbase);
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        org.drools.runtime.rule.FactHandle handle_1 = ksession_1.insert((Object)expected_1);
        org.drools.runtime.rule.FactHandle handle_2 = ksession_1.insert((Object)expected_2);
        ksession_1.fireAllRules();
        Collection coll_1 = kbase.getStatefulKnowledgeSessions();
        MiscTest.assertTrue((coll_1.size() == 1 ? 1 : 0) != 0);
        StatefulKnowledgeSession ksession_2 = (StatefulKnowledgeSession)coll_1.iterator().next();
        Object actual_1 = ksession_2.getObject(handle_1);
        Object actual_2 = ksession_2.getObject(handle_2);
        MiscTest.assertEquals((Object)expected_1, (Object)actual_1);
        MiscTest.assertEquals((Object)expected_2, (Object)actual_2);
        ksession_1.dispose();
        Collection coll_2 = kbase.getStatefulKnowledgeSessions();
        MiscTest.assertTrue((coll_2.size() == 0 ? 1 : 0) != 0);
        ksession_1.dispose();
        Collection coll_3 = kbase.getStatefulKnowledgeSessions();
        MiscTest.assertTrue((coll_3.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetFactHandle() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"empty.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 20; ++i) {
            Object object = new Object();
            ksession.insert(object);
            org.drools.runtime.rule.FactHandle factHandle = ksession.getFactHandle(object);
            MiscTest.assertNotNull((Object)factHandle);
            MiscTest.assertEquals((Object)object, (Object)ksession.getObject(factHandle));
        }
        ksession.dispose();
    }

    @Test
    public void testPrimitiveArray() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_primitiveArray.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        List result = new ArrayList();
        session.setGlobal("result", result);
        Primitives p1 = new Primitives();
        p1.setPrimitiveIntArray(new int[]{1, 2, 3});
        p1.setArrayAttribute(new String[]{"a", "b"});
        session.insert((Object)p1);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        result = (List)session.getGlobal("result");
        session.fireAllRules();
        MiscTest.assertEquals((int)3, (int)result.size());
        MiscTest.assertEquals((int)3, (int)((Integer)result.get(0)));
        MiscTest.assertEquals((int)2, (int)((Integer)result.get(1)));
        MiscTest.assertEquals((int)3, (int)((Integer)result.get(2)));
    }

    @Test
    public void testMVELSoundex() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"MVEL_soundex.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese c = new Cheese("fubar", 2);
        ksession.insert((Object)c);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)42, (int)c.getPrice());
    }

    @Test
    public void testMVELSoundexNoCharParam() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"MVEL_soundexNPE2500.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese foobarCheese = new Cheese("foobar", 2);
        Cheese nullCheese = new Cheese(null, 2);
        Cheese starCheese = new Cheese("*", 2);
        ksession.insert((Object)foobarCheese);
        ksession.insert((Object)nullCheese);
        ksession.insert((Object)starCheese);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)42, (int)foobarCheese.getPrice());
        MiscTest.assertEquals((int)2, (int)nullCheese.getPrice());
        MiscTest.assertEquals((int)2, (int)starCheese.getPrice());
    }

    @Test
    public void testMVELRewrite() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_MVELrewrite.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese brie = new Cheese("brie", 2);
        Cheese stilton = new Cheese("stilton", 2);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(brie);
        cheesery.addCheese(stilton);
        ksession.insert((Object)cheesery);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)cheesery, results.get(0));
    }

    @Test
    public void testVariableDeclaration() throws Exception {
        String str = "rule KickOff\ndialect \"mvel\"\nwhen\nthen\nint i;\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testMissingImport() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "    $i : Cheese() \n";
        str = str + "         MissingClass( fieldName == $i ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testInvalidModify1() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    no-loop \n";
        str = str + "when \n";
        str = str + "    $i : Cheese() \n";
        str = str + "then \n";
        str = str + "    modify( $i ); ";
        str = str + "    list.add( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testInvalidModify2() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    no-loop \n";
        str = str + "when \n";
        str = str + "    $i : Cheese() \n";
        str = str + "then \n";
        str = str + "    modify( $i ) { setType( \"stilton\" ); setType( \"stilton\" );}; ";
        str = str + "    list.add( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testIncrementOperator() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"java\" \n";
        str = str + "when \n";
        str = str + "    $I : Integer() \n";
        str = str + "then \n";
        str = str + "    int i = $I.intValue(); \n";
        str = str + "    i += 5; \n";
        str = str + "    list.add( i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)10, list.get(0));
    }

    @Test
    public void testKnowledgeRuntimeAccess() throws Exception {
        String str = "";
        str = str + "package org.test\n";
        str = str + "import org.drools.Message\n";
        str = str + "rule \"Hello World\"\n";
        str = str + "when\n";
        str = str + "    Message( )\n";
        str = str + "then\n";
        str = str + "    System.out.println( drools.getKnowledgeRuntime() );\n";
        str = str + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("help"));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testEvalWithBigDecimal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import java.math.BigDecimal; \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"java\" \n";
        str = str + "when \n";
        str = str + "    $bd : BigDecimal() \n";
        str = str + "    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \n";
        str = str + "then \n";
        str = str + "    list.add( $bd ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BigDecimal(1.5));
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)new BigDecimal(1.5), list.get(0));
    }

    @Test
    public void testCustomGlobalResolver() throws Exception {
        Package pkg = this.loadPackage("test_globalCustomResolver.drl");
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        String string = "stilton";
        map.put("list", list);
        map.put("string", string);
        workingMemory.setGlobalResolver(new GlobalResolver(){

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public Object resolveGlobal(String identifier) {
                return map.get(identifier);
            }

            public void setGlobal(String identifier, Object value) {
                map.put(identifier, value);
            }

            public Object get(String identifier) {
                return this.resolveGlobal(identifier);
            }

            public void set(String identifier, Object value) {
                this.setGlobal(identifier, value);
            }

            public void setDelegate(Globals delegate) {
            }
        });
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
    }

    @Test
    public void testCustomGlobalResolverWithWorkingMemoryObject() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_globalCustomResolver.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        String string = "stilton";
        map.put("list", list);
        map.put("string", string);
        workingMemory.setGlobalResolver(new GlobalResolver(){

            public Object resolveGlobal(String identifier) {
                return map.get(identifier);
            }

            public void setGlobal(String identifier, Object value) {
                map.put(identifier, value);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public Object get(String identifier) {
                return this.resolveGlobal(identifier);
            }

            public void set(String identifier, Object value) {
                this.setGlobal(identifier, value);
            }

            public void setDelegate(Globals delegate) {
            }
        });
        Cheese bree = new Cheese();
        bree.setPrice(100);
        workingMemory.insert((Object)bree);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)5, list.get(0));
        MiscTest.assertEquals((Object)6, list.get(1));
    }

    @Test
    public void testFieldBiningsAndEvalSharing() throws Exception {
        String drl = "test_FieldBindingsAndEvalSharing.drl";
        this.evalSharingTest("test_FieldBindingsAndEvalSharing.drl");
    }

    @Test
    public void testFieldBiningsAndPredicateSharing() throws Exception {
        String drl = "test_FieldBindingsAndPredicateSharing.drl";
        this.evalSharingTest("test_FieldBindingsAndPredicateSharing.drl");
    }

    private void evalSharingTest(String drl) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(drl)));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        TestParam tp1 = new TestParam();
        tp1.setValue2("boo");
        session.insert((Object)tp1);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testGeneratedBeans1() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeans.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgePackage kpkg = kbuilder.getKnowledgePackages().toArray(new KnowledgePackage[1])[0];
        MiscTest.assertEquals((int)2, (int)kpkg.getRules().size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        MiscTest.assertEquals((Object)"stilton", (Object)cheeseFact.get(cheese, "type"));
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "age", (Object)42);
        Map personMap = personType.getAsMap(ps);
        MiscTest.assertEquals((Object)42, personMap.get("age"));
        personMap.put("age", 43);
        personType.setFromMap(ps, personMap);
        MiscTest.assertEquals((Object)43, (Object)personType.get(ps, "age"));
        MiscTest.assertEquals((Object)"stilton", (Object)cheeseFact.getField("type").get(cheese));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Object cg = cheeseFact.newInstance();
        ksession.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        ksession.setGlobal("list", result);
        ksession.insert(cheese);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)result.size());
        MiscTest.assertEquals((Object)new Integer(5), result.get(0));
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        ksession.insert(person);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)result.size());
        MiscTest.assertEquals((Object)person, result.get(1));
    }

    @Test
    public void testGeneratedBeansMVEL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeansMVEL.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgePackage kpkg = kbuilder.getKnowledgePackages().toArray(new KnowledgePackage[1])[0];
        MiscTest.assertEquals((int)1, (int)kpkg.getRules().size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        FactType pf = kbase.getFactType("mortgages", "Applicant");
        FactType af = kbase.getFactType("mortgages", "LoanApplication");
        Object person = pf.newInstance();
        pf.set(person, "creditRating", (Object)"OK");
        Object application = af.newInstance();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert(person);
        ksession.insert(application);
        ksession.fireAllRules();
    }

    @Test
    public void testGeneratedBeans2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeans2.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgePackage kpkg = kbuilder.getKnowledgePackages().toArray(new KnowledgePackage[1])[0];
        MiscTest.assertEquals((int)2, (int)kpkg.getRules().size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        MiscTest.assertEquals((Object)"stilton", (Object)cheeseFact.get(cheese, "type"));
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"stilton");
        MiscTest.assertEquals((Object)cheese, (Object)cheese2);
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "name", (Object)"mark");
        personType.set(ps, "last", (Object)"proctor");
        personType.set(ps, "age", (Object)42);
        Object ps2 = personType.newInstance();
        personType.set(ps2, "name", (Object)"mark");
        personType.set(ps2, "last", (Object)"proctor");
        personType.set(ps2, "age", (Object)30);
        MiscTest.assertEquals((Object)ps, (Object)ps2);
        personType.set(ps2, "last", (Object)"little");
        MiscTest.assertFalse((boolean)ps.equals(ps2));
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        Object cg = cheeseFact.newInstance();
        wm.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        wm.setGlobal("list", result);
        wm.insert(cheese);
        wm.fireAllRules();
        MiscTest.assertEquals((int)1, (int)result.size());
        MiscTest.assertEquals((Object)new Integer(5), result.get(0));
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        wm.insert(person);
        wm.fireAllRules();
        MiscTest.assertEquals((int)2, (int)result.size());
        MiscTest.assertEquals((Object)person, result.get(1));
    }

    @Test
    public void testDeclaredFactAndFunction() throws Exception {
        String rule = "package com.jboss.qa;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "declare Address\n";
        rule = rule + "    street: String\n";
        rule = rule + "end\n";
        rule = rule + "function void myFunction() {\n";
        rule = rule + "}\n";
        rule = rule + "rule \"r1\"\n";
        rule = rule + "    dialect \"mvel\"\n";
        rule = rule + "when\n";
        rule = rule + "    Address()\n";
        rule = rule + "then\n";
        rule = rule + "    list.add(\"r1\");\n";
        rule = rule + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        FactType addressFact = ruleBase.getFactType("com.jboss.qa.Address");
        Object address = addressFact.newInstance();
        session.insert(address);
        session.fireAllRules();
        list = (List)session.getGlobal("list");
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testUppercaseField() throws Exception {
        String rule = "package org.drools;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "declare Address\n";
        rule = rule + "    Street: String\n";
        rule = rule + "end\n";
        rule = rule + "rule \"r1\"\n";
        rule = rule + "when\n";
        rule = rule + "    Address($street: Street)\n";
        rule = rule + "then\n";
        rule = rule + "    list.add($street);\n";
        rule = rule + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("list", new ArrayList());
        FactType addressType = kbase.getFactType("org.drools", "Address");
        Object address = addressType.newInstance();
        addressType.set(address, "Street", (Object)"5th Avenue");
        ksession.insert(address);
        ksession.fireAllRules();
        List list = (List)ksession.getGlobal("list");
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"5th Avenue", list.get(0));
        ksession.dispose();
    }

    @Test
    public void testUppercaseField2() throws Exception {
        String rule = "package org.drools\ndeclare SomeFact\n    Field : String\n    aField : String\nend\nrule X\nwhen\n    SomeFact( Field == \"foo\", aField == \"bar\" )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        FactType factType = kbase.getFactType("org.drools", "SomeFact");
        Object fact = factType.newInstance();
        factType.set(fact, "Field", (Object)"foo");
        factType.set(fact, "aField", (Object)"bar");
        ksession.insert(fact);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
        ksession.dispose();
    }

    @Test
    public void testNullHandling() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NullHandling.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese nullCheese = new Cheese(null, 2);
        session.insert((Object)nullCheese);
        Person notNullPerson = new Person("shoes butt back");
        notNullPerson.setBigDecimal(new BigDecimal("42.42"));
        session.insert((Object)notNullPerson);
        Person nullPerson = new Person("whee");
        nullPerson.setBigDecimal(null);
        session.insert((Object)nullPerson);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)3, (int)((List)session.getGlobal("list")).size());
        nullPerson = new Person(null);
        session.insert((Object)nullPerson);
        session.fireAllRules();
        MiscTest.assertEquals((int)4, (int)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testNullFieldOnCompositeSink() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_NullFieldOnCompositeSink.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Attribute());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)ksession.getGlobal("list")).size());
        MiscTest.assertEquals((Object)"X", ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testEmptyPattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EmptyPattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)5, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testExplicitAnd() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_ExplicitAnd.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message("hola"));
        ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        ksession.insert((Object)new Cheese("brie", 33));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)ksession.getGlobal("list")).size());
    }

    @Test
    public void testHelloWorld() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"HelloWorld.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Message message = new Message("hola");
        message.addToList("hello");
        message.setNumber(42);
        ksession.insert((Object)message);
        ksession.insert((Object)"boo");
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)message.isFired());
        MiscTest.assertEquals((Object)message, ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testExtends() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("extend_rule_test.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese mycheese = new Cheese("cheddar", 4);
        FactHandle handle = session.insert((Object)mycheese);
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"rule 4", list.get(0));
        MiscTest.assertEquals((Object)"rule 2b", list.get(1));
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract((org.drools.runtime.rule.FactHandle)handle);
        Cheese mycheese2 = new Cheese("notcheddar", 4);
        FactHandle handle2 = session.insert((Object)mycheese2);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"rule 4", list.get(0));
        MiscTest.assertEquals((int)1, (int)list.size());
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract((org.drools.runtime.rule.FactHandle)handle2);
        Cheese mycheese3 = new Cheese("stilton", 6);
        FactHandle handle3 = session.insert((Object)mycheese3);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"rule 3", list.get(0));
        MiscTest.assertEquals((int)1, (int)list.size());
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract((org.drools.runtime.rule.FactHandle)handle3);
        Cheese mycheese4 = new Cheese("notstilton", 6);
        FactHandle handle4 = session.insert((Object)mycheese4);
        session.fireAllRules();
        MiscTest.assertTrue((((List)session.getGlobal("list")).size() == 0 ? 1 : 0) != 0);
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract((org.drools.runtime.rule.FactHandle)handle4);
        Cheese mycheese5 = new Cheese("stilton", 7);
        FactHandle handle5 = session.insert((Object)mycheese5);
        session.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testExtends2() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_RuleExtend.drl")), ResourceType.DRL);
            MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheese stilton = new Cheese("stilton", 5);
            Cheese cheddar = new Cheese("cheddar", 7);
            Cheese brie = new Cheese("brie", 5);
            ksession.insert((Object)stilton);
            ksession.insert((Object)cheddar);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            MiscTest.assertEquals((int)2, (int)results.size());
            MiscTest.assertEquals((Object)"stilton", results.get(0));
            MiscTest.assertEquals((Object)"brie", results.get(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (kbuilder.hasErrors()) {
                logger.info(kbuilder.getErrors().toString());
            }
            MiscTest.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatinLocale() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("pt", "BR"));
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_LatinLocale.drl")), ResourceType.DRL);
            MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheese mycheese = new Cheese("cheddar", 4);
            org.drools.runtime.rule.FactHandle handle = ksession.insert((Object)mycheese);
            ksession.fireAllRules();
            MiscTest.assertEquals((int)1, (int)results.size());
            MiscTest.assertEquals((String)"1", (String)((String)results.get(0)));
            mycheese.setPrice(8);
            mycheese.setDoublePrice(8.5);
            ksession.update(handle, (Object)mycheese);
            ksession.fireAllRules();
            MiscTest.assertEquals((int)2, (int)results.size());
            MiscTest.assertEquals((String)"3", (String)((String)results.get(1)));
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    @Test
    public void testLiteral() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"stilton", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testLiteralWithEscapes() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_literal_with_escapes.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        String expected = "s\tti\"lto\nn";
        Cheese stilton = new Cheese(expected, 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        int fired = session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)fired);
        MiscTest.assertEquals((Object)expected, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testLiteralWithBoolean() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_with_boolean.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person bill = new Person("bill", null, 12);
        bill.setAlive(true);
        session.insert((Object)bill);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)bill, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testFactBindings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FactBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        final ArrayList events = new ArrayList();
        DefaultWorkingMemoryEventListener listener = new DefaultWorkingMemoryEventListener(){

            public void objectUpdated(ObjectUpdatedEvent event) {
                events.add(event);
            }
        };
        workingMemory.addEventListener((org.drools.event.WorkingMemoryEventListener)listener);
        Person bigCheese = new Person("big cheese");
        Cheese cheddar = new Cheese("cheddar", 15);
        bigCheese.setCheese(cheddar);
        FactHandle bigCheeseHandle = workingMemory.insert((Object)bigCheese);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        ObjectUpdatedEvent event = (ObjectUpdatedEvent)events.get(0);
        MiscTest.assertSame((Object)cheddarHandle, (Object)event.getFactHandle());
        MiscTest.assertSame((Object)cheddar, (Object)event.getOldObject());
        MiscTest.assertSame((Object)cheddar, (Object)event.getObject());
        event = (ObjectUpdatedEvent)events.get(1);
        MiscTest.assertSame((Object)bigCheeseHandle, (Object)event.getFactHandle());
        MiscTest.assertSame((Object)bigCheese, (Object)event.getOldObject());
        MiscTest.assertSame((Object)bigCheese, (Object)event.getObject());
    }

    @Test
    public void testPropertyChangeSupportOldAPI() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_PropertyChange.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulSession session = ruleBase.newStatefulSession(null, env);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        State state = new State("initial");
        session.insert((Object)state, true);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        state.setFlag(true);
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)((List)session.getGlobal("list")).size());
        state.setState("finished");
        StatefulKnowledgeSession ksesion = SerializationHelper.getSerialisedStatefulKnowledgeSession((StatefulKnowledgeSession)new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)session), false);
        ksesion.fireAllRules();
        MiscTest.assertEquals((int)3, (int)((List)session.getGlobal("list")).size());
        session.dispose();
        MiscTest.assertEquals((int)0, (int)state.getPropertyChangeListeners().length);
    }

    @Test
    public void testPropertyChangeSupportNewAPI() throws Exception {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_PropertyChangeTypeDecl.drl")), ResourceType.DRL);
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Collection pkgs = builder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        State state = new State("initial");
        session.insert((Object)state);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        state.setFlag(true);
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)((List)session.getGlobal("list")).size());
        state.setState("finished");
        session.dispose();
        MiscTest.assertEquals((int)0, (int)state.getPropertyChangeListeners().length);
    }

    @Test
    public void testDisconnectedFactHandle() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        DefaultFactHandle helloHandle = (DefaultFactHandle)ksession.insert((Object)"hello");
        DefaultFactHandle goodbyeHandle = (DefaultFactHandle)ksession.insert((Object)"goodbye");
        DefaultFactHandle key = new DefaultFactHandle(helloHandle.toExternalForm());
        MiscTest.assertEquals((Object)"hello", (Object)ksession.getObject((org.drools.runtime.rule.FactHandle)key));
        key = new DefaultFactHandle(goodbyeHandle.toExternalForm());
        MiscTest.assertEquals((Object)"goodbye", (Object)ksession.getObject((org.drools.runtime.rule.FactHandle)key));
    }

    @Test
    public void testBigDecimal() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("big_decimal_and_comparable.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person bill = new Person("bill", null, 42);
        bill.setBigDecimal(new BigDecimal("42"));
        Person ben = new Person("ben", null, 43);
        ben.setBigDecimal(new BigDecimal("43"));
        session.insert((Object)bill);
        session.insert((Object)new Cheese("gorgonzola", 43));
        session.insert((Object)ben);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testBigDecimalIntegerLiteral() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("big_decimal_and_literal.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person bill = new Person("bill", null, 12);
        bill.setBigDecimal(new BigDecimal("42"));
        bill.setBigInteger(new BigInteger("42"));
        session.insert((Object)bill);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)6, (int)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testBigDecimalWithFromAndEval() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $dec : java.math.BigDecimal() from java.math.BigDecimal.TEN;\n";
        rule = rule + "    eval( $dec.compareTo(java.math.BigDecimal.ONE) > 0 )\n";
        rule = rule + "then\n";
        rule = rule + "    System.out.println(\"OK!\");\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        MiscTest.assertFalse((String)builder.getErrors().toString(), (boolean)builder.hasErrors());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.fireAllRules();
    }

    @Test
    public void testImport() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.integrationtests;\n";
        rule = rule + "import java.lang.Math;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  dialect \"mvel\"\n";
        rule = rule + "  when\n";
        rule = rule + "  then\n";
        rule = rule + "    new TestFact(TestFact.TEST);\n";
        rule = rule + "end";
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        try {
            kbase.addKnowledgePackages(builder.getKnowledgePackages());
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"Should execute with out exceptions");
        }
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.fireAllRules();
    }

    @Test
    public void testMVELConsequenceWithMapsAndArrays() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import java.util.ArrayList\n";
        rule = rule + "import java.util.HashMap\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "    dialect \"mvel\"";
        rule = rule + "when\n";
        rule = rule + "then\n";
        rule = rule + "    m = new HashMap();\n";
        rule = rule + "    l = new ArrayList();\n";
        rule = rule + "    l.add(\"first\");\n";
        rule = rule + "    m.put(\"content\", l);\n";
        rule = rule + "    System.out.println(((ArrayList)m[\"content\"])[0]);\n";
        rule = rule + "    list.add(((ArrayList)m[\"content\"])[0]);\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        MiscTest.assertEquals((Object)"first", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testCell() throws Exception {
        Cell cell1 = new Cell(9);
        Cell cell = new Cell(0);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("evalmodify.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        Package pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulSession session = ruleBase.newStatefulSession(null, env);
        session.insert((Object)cell1);
        FactHandle cellHandle = session.insert((Object)cell);
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((StatefulKnowledgeSession)new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)session), false);
        session.fireAllRules();
        MiscTest.assertEquals((int)9, (int)cell.getValue());
    }

    @Test
    public void testNesting() throws Exception {
        Person p = new Person();
        p.setName("Michael");
        Address add1 = new Address();
        add1.setStreet("High");
        Address add2 = new Address();
        add2.setStreet("Low");
        ArrayList<Address> l = new ArrayList<Address>();
        l.add(add1);
        l.add(add2);
        p.setAddresses(l);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested_fields.drl")));
        MiscTest.assertFalse((String)builder.getErrors().toString(), (boolean)builder.hasErrors());
        DrlParser parser = new DrlParser();
        PackageDescr desc = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested_fields.drl")));
        List packageAttrs = desc.getAttributes();
        MiscTest.assertEquals((int)1, (int)desc.getRules().size());
        MiscTest.assertEquals((int)1, (int)packageAttrs.size());
        RuleDescr rule = (RuleDescr)desc.getRules().get(0);
        Map ruleAttrs = rule.getAttributes();
        MiscTest.assertEquals((int)1, (int)ruleAttrs.size());
        MiscTest.assertEquals((String)"mvel", (String)((AttributeDescr)ruleAttrs.get("dialect")).getValue());
        MiscTest.assertEquals((String)"dialect", (String)((AttributeDescr)ruleAttrs.get("dialect")).getName());
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
    }

    @Test
    public void testOr() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("or_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 5);
        FactHandle h = session.insert((Object)cheddar);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"got cheese", list.get(0));
        MiscTest.assertEquals((int)1, (int)list.size());
        session.retract((org.drools.runtime.rule.FactHandle)h);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        session.insert((Object)new Cheese("stilton", 5));
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("eval_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("five", (Object)new Integer(5));
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)stilton, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testJaninoEval() throws Exception {
        PackageBuilderConfiguration config = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)config.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        PackageBuilder builder = new PackageBuilder(config);
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("eval_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("five", (Object)new Integer(5));
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)stilton, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testEvalMore() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("eval_rule_test_more.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person foo = new Person("foo");
        session.insert((Object)foo);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)foo, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testReturnValue() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("returnvalue_rule_test.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("two", (Object)new Integer(2));
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person peter = new Person("peter", null, 12);
        session.insert((Object)peter);
        Person jane = new Person("jane", null, 10);
        session.insert((Object)jane);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)jane, ((List)session.getGlobal("list")).get(0));
        MiscTest.assertEquals((Object)peter, ((List)session.getGlobal("list")).get(1));
    }

    @Test
    public void testPredicate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("predicate_rule_test.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("two", (Object)new Integer(2));
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person peter = new Person("peter", null, 12);
        session.insert((Object)peter);
        Person jane = new Person("jane", null, 10);
        session.insert((Object)jane);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((Object)jane, ((List)session.getGlobal("list")).get(0));
        MiscTest.assertEquals((Object)peter, ((List)session.getGlobal("list")).get(1));
    }

    @Test
    public void testNullBehaviour() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("null_behaviour.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        Person p1 = new Person("michael", "food", 40);
        Person p2 = new Person(null, "drink", 30);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
    }

    @Test
    public void testNullConstraint() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("null_constraint.drl")));
        if (builder.hasErrors()) {
            for (DroolsError error : builder.getErrors().getErrors()) {
                logger.warn(error.toString());
            }
        }
        MiscTest.assertFalse((String)builder.getErrors().toString(), (boolean)builder.hasErrors());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList foo = new ArrayList();
        session.setGlobal("messages", foo);
        Person p1 = new Person(null, "food", 40);
        Primitives p2 = new Primitives();
        p2.setArrayAttribute(null);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)((List)session.getGlobal("messages")).size());
    }

    @Test
    public void testBasicFrom() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_From.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list1 = new ArrayList();
        ksession.setGlobal("list1", list1);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        ArrayList list3 = new ArrayList();
        ksession.setGlobal("list3", list3);
        Cheesery cheesery = new Cheesery();
        Cheese stilton = new Cheese("stilton", 12);
        Cheese cheddar = new Cheese("cheddar", 15);
        cheesery.addCheese(stilton);
        cheesery.addCheese(cheddar);
        ksession.setGlobal("cheesery", (Object)cheesery);
        ksession.insert((Object)cheesery);
        Person p = new Person("stilton");
        ksession.insert((Object)p);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)((List)ksession.getGlobal("list1")).size());
        MiscTest.assertEquals((Object)cheddar, ((List)ksession.getGlobal("list1")).get(0));
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list1")).get(1));
        MiscTest.assertEquals((int)2, (int)((List)ksession.getGlobal("list2")).size());
        MiscTest.assertEquals((Object)cheddar, ((List)ksession.getGlobal("list2")).get(0));
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list2")).get(1));
        MiscTest.assertEquals((int)1, (int)((List)ksession.getGlobal("list3")).size());
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list3")).get(0));
    }

    @Test
    public void testFromWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromWithParams.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        Object globalObject = new Object();
        workingMemory.setGlobal("list", list);
        workingMemory.setGlobal("testObject", (Object)new FromTestClass());
        workingMemory.setGlobal("globalObject", globalObject);
        Person bob = new Person("bob");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)((List)workingMemory.getGlobal("list")).size());
        List array = (List)((List)workingMemory.getGlobal("list")).get(0);
        MiscTest.assertEquals((int)3, (int)array.size());
        Person p = (Person)array.get(0);
        MiscTest.assertEquals((Object)p, (Object)bob);
        MiscTest.assertEquals((Object)new Integer(42), array.get(1));
        List nested = (List)array.get(2);
        MiscTest.assertEquals((Object)"x", nested.get(0));
        MiscTest.assertEquals((Object)"y", nested.get(1));
        Map map = (Map)((List)workingMemory.getGlobal("list")).get(1);
        MiscTest.assertEquals((int)2, (int)map.keySet().size());
        MiscTest.assertTrue((boolean)map.keySet().contains(bob));
        MiscTest.assertEquals((Object)globalObject, map.get(bob));
        MiscTest.assertTrue((boolean)map.keySet().contains("key1"));
        Map nestedMap = (Map)map.get("key1");
        MiscTest.assertEquals((int)1, (int)nestedMap.keySet().size());
        MiscTest.assertTrue((boolean)nestedMap.keySet().contains("key2"));
        MiscTest.assertEquals((Object)"value2", nestedMap.get("key2"));
        MiscTest.assertEquals((Object)new Integer(42), ((List)workingMemory.getGlobal("list")).get(2));
        MiscTest.assertEquals((Object)"literal", ((List)workingMemory.getGlobal("list")).get(3));
        MiscTest.assertEquals((Object)bob, ((List)workingMemory.getGlobal("list")).get(4));
        MiscTest.assertEquals((Object)globalObject, ((List)workingMemory.getGlobal("list")).get(5));
    }

    @Test
    public void testFromWithNewConstructor() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromWithNewConstructor.drl")));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(descr);
        Package pkg = builder.getPackage();
        pkg.checkValidity();
        pkg = SerializationHelper.serializeObject(pkg);
    }

    @Test
    public void testFromDeclarationWithWorkingMemoryLogger() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Cheesery\n";
        rule = rule + "import org.drools.Cheese\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $cheesery : Cheesery()\n";
        rule = rule + "    Cheese( $type : type) from $cheesery.cheeses\n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $type );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 22));
        session.insert((Object)cheesery);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        MiscTest.assertEquals((Object)"stilton", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testWithInvalidRule() throws Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        JavaDialectConfiguration jconf = (JavaDialectConfiguration)conf.getDialectConfiguration("java");
        jconf.setCompiler(0);
        PackageBuilder builder = new PackageBuilder(conf);
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("invalid_rule.drl")));
        Package pkg = builder.getPackage();
        RuntimeException runtime = null;
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        try {
            ruleBase.addPackage(pkg);
            MiscTest.fail((String)"Should have thrown an exception as the rule is NOT VALID.");
        }
        catch (RuntimeException e) {
            MiscTest.assertNotNull((Object)e.getMessage());
            runtime = e;
        }
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        MiscTest.assertTrue((builder.getErrors().getErrors().length > 0 ? 1 : 0) != 0);
        String pretty = builder.getErrors().toString();
        MiscTest.assertFalse((boolean)pretty.equals(""));
        MiscTest.assertEquals((String)pretty, (String)runtime.getMessage());
    }

    @Test
    public void testWithInvalidRule2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("invalid_rule2.drl")));
        MiscTest.assertTrue((boolean)builder.hasErrors());
        String err = builder.getErrors().toString();
        logger.info(err);
    }

    @Test
    public void testErrorLineNumbers() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("errors_in_rule.drl")));
        Package pkg = builder.getPackage();
        DroolsError[] errors = builder.getErrors().getErrors();
        MiscTest.assertEquals((int)3, (int)errors.length);
        DescrBuildError stiltonError = (DescrBuildError)errors[0];
        MiscTest.assertTrue((boolean)stiltonError.getMessage().contains("Stilton"));
        MiscTest.assertNotNull((Object)stiltonError.getDescr());
        MiscTest.assertTrue((stiltonError.getLine() != -1 ? 1 : 0) != 0);
        MiscTest.assertEquals((int)stiltonError.getLine(), (int)stiltonError.getDescr().getLine());
        MiscTest.assertEquals((int)11, (int)stiltonError.getLine());
        DescrBuildError poisonError = (DescrBuildError)errors[1];
        MiscTest.assertTrue((boolean)poisonError.getMessage().contains("Poison"));
        MiscTest.assertEquals((int)13, (int)poisonError.getLine());
        MiscTest.assertTrue((boolean)errors[2].getMessage().contains("add"));
        DescrBuildError rhsError = (DescrBuildError)errors[2];
        MiscTest.assertTrue((rhsError.getLine() >= 8 && rhsError.getLine() <= 17 ? 1 : 0) != 0);
    }

    @Test
    public void testErrorsParser() throws Exception {
        DrlParser parser = new DrlParser();
        MiscTest.assertEquals((int)0, (int)parser.getErrors().size());
        parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("errors_parser_multiple.drl")));
        MiscTest.assertTrue((boolean)parser.hasErrors());
        MiscTest.assertTrue((parser.getErrors().size() > 0 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)(parser.getErrors().get(0) instanceof ParserError));
        ParserError first = (ParserError)parser.getErrors().get(0);
        MiscTest.assertTrue((first.getMessage() != null ? 1 : 0) != 0);
        MiscTest.assertFalse((boolean)first.getMessage().equals(""));
    }

    @Test
    public void testAssertRetract() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("assert_retract.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person person = new Person("michael", "cheese");
        person.setStatus("start");
        workingMemory.insert((Object)person);
        workingMemory.fireAllRules();
        List results = (List)workingMemory.getGlobal("list");
        for (String result : results) {
            logger.info(result);
        }
        MiscTest.assertEquals((int)5, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains("first"));
        MiscTest.assertTrue((boolean)results.contains("second"));
        MiscTest.assertTrue((boolean)results.contains("third"));
        MiscTest.assertTrue((boolean)results.contains("fourth"));
        MiscTest.assertTrue((boolean)results.contains("fifth"));
    }

    @Test
    public void testPredicateAsFirstPattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("predicate_as_first_pattern.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese mussarela = new Cheese("Mussarela", 35);
        workingMemory.insert((Object)mussarela);
        Cheese provolone = new Cheese("Provolone", 20);
        workingMemory.insert((Object)provolone);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"The rule is being incorrectly fired", (int)35, (int)mussarela.getPrice());
        MiscTest.assertEquals((String)"Rule is incorrectly being fired", (int)20, (int)provolone.getPrice());
    }

    @Test
    public void testConsequenceException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        try {
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Consequence");
        }
        catch (ConsequenceException e) {
            MiscTest.assertEquals((String)"Throw Consequence Exception", (String)e.getActivation().getRule().getName());
            MiscTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    @Test
    public void testCustomConsequenceException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceException.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setConsequenceExceptionHandler(CustomConsequenceExceptionHandler.class.getName());
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)((CustomConsequenceExceptionHandler)((DefaultAgenda)workingMemory.getAgenda()).getConsequenceExceptionHandler()).isCalled());
    }

    @Test
    public void testEvalException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            workingMemory.insert((Object)brie);
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Eval");
        }
        catch (Exception e) {
            MiscTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    @Test
    public void testPredicateException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_PredicateException.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            workingMemory.insert((Object)brie);
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Predicate");
        }
        catch (Exception e) {
            MiscTest.assertTrue((boolean)e.getCause().getMessage().contains("this should throw an exception"));
        }
    }

    @Test
    public void testReturnValueException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ReturnValueException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            workingMemory.insert((Object)brie);
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the ReturnValue");
        }
        catch (Exception e) {
            Throwable root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            root.getMessage().contains("this should throw an exception");
        }
    }

    @Test
    public void testMultiRestrictionFieldConstraint() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MultiRestrictionFieldConstraint.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list1 = new ArrayList();
        workingMemory.setGlobal("list1", list1);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        ArrayList list3 = new ArrayList();
        workingMemory.setGlobal("list3", list3);
        ArrayList list4 = new ArrayList();
        workingMemory.setGlobal("list4", list4);
        Person youngChili1 = new Person("young chili1");
        youngChili1.setAge(12);
        youngChili1.setHair("blue");
        Person youngChili2 = new Person("young chili2");
        youngChili2.setAge(25);
        youngChili2.setHair("purple");
        Person chili1 = new Person("chili1");
        chili1.setAge(35);
        chili1.setHair("red");
        Person chili2 = new Person("chili2");
        chili2.setAge(38);
        chili2.setHair("indigigo");
        Person oldChili1 = new Person("old chili2");
        oldChili1.setAge(45);
        oldChili1.setHair("green");
        Person oldChili2 = new Person("old chili2");
        oldChili2.setAge(48);
        oldChili2.setHair("blue");
        workingMemory.insert((Object)youngChili1);
        workingMemory.insert((Object)youngChili2);
        workingMemory.insert((Object)chili1);
        workingMemory.insert((Object)chili2);
        workingMemory.insert((Object)oldChili1);
        workingMemory.insert((Object)oldChili2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list1.size());
        MiscTest.assertTrue((boolean)list1.contains(chili1));
        MiscTest.assertEquals((int)2, (int)list2.size());
        MiscTest.assertTrue((boolean)list2.contains(chili1));
        MiscTest.assertTrue((boolean)list2.contains(chili2));
        MiscTest.assertEquals((int)2, (int)list3.size());
        MiscTest.assertTrue((boolean)list3.contains(youngChili1));
        MiscTest.assertTrue((boolean)list3.contains(youngChili2));
        MiscTest.assertEquals((int)2, (int)list4.size());
        MiscTest.assertTrue((boolean)list4.contains(youngChili1));
        MiscTest.assertTrue((boolean)list4.contains(chili1));
    }

    @Test
    @Ignore
    public void testDumpers() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dumpers.drl")));
        if (parser.hasErrors()) {
            for (DroolsError error : parser.getErrors()) {
                logger.warn(error.toString());
            }
            MiscTest.fail((String)parser.getErrors().toString());
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(pkg);
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
        DrlDumper drlDumper = new DrlDumper();
        String drlResult = drlDumper.dump(pkg);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(drlResult));
        if (builder.hasErrors()) {
            for (DroolsError error : builder.getErrors().getErrors()) {
                logger.warn(error.toString());
            }
            MiscTest.fail((String)parser.getErrors().toString());
        }
        ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        workingMemory = ruleBase.newStatefulSession();
        list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
        XmlDumper xmlDumper = new XmlDumper();
        String xmlResult = xmlDumper.dump(pkg);
        builder = new PackageBuilder();
        builder.addPackageFromXml((Reader)new StringReader(xmlResult));
        if (builder.hasErrors()) {
            for (DroolsError error : builder.getErrors().getErrors()) {
                logger.warn(error.toString());
            }
            MiscTest.fail((String)parser.getErrors().toString());
        }
        ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        workingMemory = ruleBase.newStatefulSession();
        list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
    }

    @Test
    public void testContainsCheese() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ContainsCheese.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        workingMemory.insert((Object)stilton);
        Cheese brie = new Cheese("brie", 10);
        workingMemory.insert((Object)brie);
        Cheesery cheesery = new Cheesery();
        cheesery.getCheeses().add(stilton);
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)brie, list.get(1));
    }

    @Test
    public void testDuplicateRuleNames() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DuplicateRuleName1.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DuplicateRuleName2.drl")));
        ruleBase.addPackage(builder.getPackage());
    }

    @Test
    public void testNullValuesIndexing() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NullValuesIndexing.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg1);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person bob = new Person(null, null);
        bob.setStatus("P1");
        Person pete = new Person(null, null);
        bob.setStatus("P2");
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)pete);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"Indexing with null values is not working correctly.", (String)"OK", (String)bob.getStatus());
        MiscTest.assertEquals((String)"Indexing with null values is not working correctly.", (String)"OK", (String)pete.getStatus());
    }

    @Test
    public void testEmptyRule() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EmptyRule.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("fired1"));
        MiscTest.assertTrue((boolean)list.contains("fired2"));
    }

    @Test
    public void testjustEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NoPatterns.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("fired1"));
        MiscTest.assertTrue((boolean)list.contains("fired3"));
    }

    @Test
    public void testOrWithBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OrWithBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person hola = new Person("hola");
        workingMemory.insert((Object)hola);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        Cheese brie = new Cheese("brie");
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(hola));
        MiscTest.assertTrue((boolean)list.contains(brie));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinNodeModifyObject() throws Exception {
        IndexedNumber n;
        int i;
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_JoinNodeModifyObject.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg1);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList orderedFacts = new ArrayList();
        ArrayList errors = new ArrayList();
        workingMemory.setGlobal("orderedNumbers", orderedFacts);
        workingMemory.setGlobal("errors", errors);
        int MAX = 2;
        for (i = 1; i <= 2; ++i) {
            n = new IndexedNumber(i, 2 - i + 1);
            workingMemory.insert((Object)n);
        }
        workingMemory.fireAllRules();
        MiscTest.assertTrue((String)("Processing generated errors: " + ((Object)errors).toString()), (boolean)errors.isEmpty());
        for (i = 1; i <= 2; ++i) {
            n = (IndexedNumber)orderedFacts.get(i - 1);
            MiscTest.assertEquals((String)"Fact is out of order", (int)i, (int)n.getIndex());
        }
    }

    @Test
    public void testInsurancePricingExample() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"insurance_pricing_example.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Driver driver = new Driver();
        Policy policy = new Policy();
        ksession.insert((Object)driver);
        ksession.insert((Object)policy);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)120, (int)policy.getBasePrice());
    }

    @Test
    public void testLLR() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_JoinNodeModifyTuple.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Target tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.26544f));
        tgt.setLon(new Float(28.952137f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.8666667f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236874f));
        tgt.setLon(new Float(28.992579f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.8666667f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.265343f));
        tgt.setLon(new Float(28.952267f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236935f));
        tgt.setLon(new Float(28.992493f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.26525f));
        tgt.setLon(new Float(28.952396f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9333333f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236996f));
        tgt.setLon(new Float(28.992405f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9333333f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.265163f));
        tgt.setLon(new Float(28.952526f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9666667f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.237057f));
        tgt.setLon(new Float(28.99232f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9666667f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
    }

    @Test
    public void testReturnValueAndGlobal() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ReturnValueAndGlobal.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList matchlist = new ArrayList();
        workingMemory.setGlobal("matchingList", matchlist);
        ArrayList nonmatchlist = new ArrayList();
        workingMemory.setGlobal("nonMatchingList", nonmatchlist);
        workingMemory.setGlobal("cheeseType", (Object)"stilton");
        Cheese stilton1 = new Cheese("stilton", 5);
        Cheese stilton2 = new Cheese("stilton", 7);
        Cheese brie = new Cheese("brie", 4);
        workingMemory.insert((Object)stilton1);
        workingMemory.insert((Object)stilton2);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)matchlist.size());
        MiscTest.assertEquals((int)1, (int)nonmatchlist.size());
    }

    @Test
    public void testDeclaringAndUsingBindsInSamePattern() throws Exception {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setRemoveIdentities(true);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DeclaringAndUsingBindsInSamePattern.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase(config);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList sensors = new ArrayList();
        workingMemory.setGlobal("sensors", sensors);
        Sensor sensor1 = new Sensor(100, 150);
        workingMemory.insert((Object)sensor1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)sensors.size());
        Sensor sensor2 = new Sensor(200, 150);
        workingMemory.insert((Object)sensor2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)sensors.size());
    }

    @Test
    public void testMissingImports() {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_missing_import.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getSinglethreadRuleBase();
            ruleBase.addPackage(pkg);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            MiscTest.fail((String)"Should have thrown an InvalidRulePackage");
        }
        catch (InvalidRulePackage e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("Should have thrown an InvalidRulePackage Exception instead of " + e.getMessage()));
        }
    }

    @Test
    public void testNestedConditionalElements() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NestedConditionalElements.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        State state = new State("SP");
        workingMemory.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setLikes("stilton");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)new Cheese(bob.getLikes(), 10));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testDeclarationUsage() throws Exception {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DeclarationUsage.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getSinglethreadRuleBase();
            ruleBase.addPackage(pkg);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            MiscTest.fail((String)"Should have trown an exception");
        }
        catch (InvalidRulePackage e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("Wrong exception raised: " + e.getMessage()));
        }
    }

    @Test
    public void testDeclareAndFrom() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_DeclareWithFrom.drl");
        FactType profileType = kbase.getFactType("org.drools", "Profile");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Object profile = profileType.newInstance();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("internet", 2);
        profileType.set(profile, "pageFreq", map);
        ksession.insert(profile);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testDeclarationNonExistingField() throws Exception {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DeclarationOfNonExistingField.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getSinglethreadRuleBase();
            ruleBase.addPackage(pkg);
            MiscTest.fail((String)"Should have trown an exception");
        }
        catch (InvalidRulePackage e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("Wrong exception raised: " + e.getMessage()));
        }
    }

    @Test
    public void testUnbalancedTrees() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_UnbalancedTrees.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Cheese("a", 10));
        wm.insert((Object)new Cheese("b", 10));
        wm.insert((Object)new Cheese("c", 10));
        wm.insert((Object)new Cheese("d", 10));
        Cheese e = new Cheese("e", 10);
        wm.insert((Object)e);
        wm.fireAllRules();
        MiscTest.assertEquals((String)"Rule should have fired twice, seting the price to 30", (int)30, (int)e.getPrice());
    }

    @Test
    public void testImportConflict() throws Exception {
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ImportConflict.drl")));
        Package pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
    }

    @Test
    public void testEmptyIdentifier() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_emptyIdentifier.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList result = new ArrayList();
        workingMemory.setGlobal("results", result);
        Person person = new Person("bob");
        Cheese cheese = new Cheese("brie", 10);
        workingMemory.insert((Object)person);
        workingMemory.insert((Object)cheese);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)result.size());
    }

    @Test
    public void testDuplicateVariableBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_duplicateVariableBinding.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        HashMap result = new HashMap();
        workingMemory.setGlobal("results", result);
        Cheese stilton = new Cheese("stilton", 20);
        Cheese brie = new Cheese("brie", 10);
        workingMemory.insert((Object)stilton);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)result.size());
        MiscTest.assertEquals((int)stilton.getPrice(), (int)((Integer)result.get(stilton.getType())));
        MiscTest.assertEquals((int)brie.getPrice(), (int)((Integer)result.get(brie.getType())));
        MiscTest.assertEquals((int)stilton.getPrice(), (int)((Integer)result.get(stilton)));
        MiscTest.assertEquals((int)brie.getPrice(), (int)((Integer)result.get(brie)));
        MiscTest.assertEquals((int)stilton.getPrice(), (int)((Integer)result.get("test3" + stilton.getType())));
        workingMemory.insert((Object)new Person("bob", brie.getType()));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)result.size());
        MiscTest.assertEquals((int)brie.getPrice(), (int)((Integer)result.get("test3" + brie.getType())));
    }

    @Test
    public void testShadowProxyInHirarchies() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ShadowProxyInHirarchies.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new Child("gp"));
        workingMemory.fireAllRules();
    }

    @Test
    public void testSelfReference() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SelfReference.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order(10, "Bob");
        OrderItem item1 = new OrderItem(order, 1);
        OrderItem item2 = new OrderItem(order, 2);
        OrderItem anotherItem1 = new OrderItem(null, 3);
        OrderItem anotherItem2 = new OrderItem(null, 4);
        workingMemory.insert((Object)order);
        workingMemory.insert((Object)item1);
        workingMemory.insert((Object)item2);
        workingMemory.insert((Object)anotherItem1);
        workingMemory.insert((Object)anotherItem2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains(item1));
        MiscTest.assertTrue((boolean)results.contains(item2));
    }

    @Test
    public void testNumberComparisons() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NumberComparisons.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        RandomNumber rn = new RandomNumber();
        rn.setValue(10);
        workingMemory.insert((Object)rn);
        Guess guess = new Guess();
        guess.setValue(new Integer(5));
        FactHandle handle = workingMemory.insert((Object)guess);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"HIGHER", list.get(0));
        guess.setValue(new Integer(15));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)guess);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"LOWER", list.get(1));
        guess.setValue(new Integer(10));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)guess);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"CORRECT", list.get(2));
    }

    @Test
    public void testSkipModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_skipModify.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Cheese cheese = new Cheese("brie", 10);
        FactHandle handle = workingMemory.insert((Object)cheese);
        Person bob = new Person("bob", "stilton");
        workingMemory.insert((Object)bob);
        cheese.setType("stilton");
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)cheese);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
    }

    @Test
    public void testEventModel() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EventModel.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wm = ruleBase.newStatefulSession();
        final ArrayList agendaList = new ArrayList();
        org.drools.event.AgendaEventListener agendaEventListener = new org.drools.event.AgendaEventListener(){

            public void activationCancelled(org.drools.event.ActivationCancelledEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }
        };
        final ArrayList wmList = new ArrayList();
        org.drools.event.WorkingMemoryEventListener workingMemoryListener = new org.drools.event.WorkingMemoryEventListener(){

            public void objectInserted(org.drools.event.ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectRetracted(org.drools.event.ObjectRetractedEvent event) {
                wmList.add(event);
            }
        };
        wm.addEventListener(workingMemoryListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        org.drools.event.ObjectInsertedEvent oae = (org.drools.event.ObjectInsertedEvent)wmList.get(0);
        MiscTest.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        wm.update((org.drools.runtime.rule.FactHandle)stiltonHandle, (Object)stilton);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        MiscTest.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        wm.retract((org.drools.runtime.rule.FactHandle)stiltonHandle);
        org.drools.event.ObjectRetractedEvent ore = (org.drools.event.ObjectRetractedEvent)wmList.get(2);
        MiscTest.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        wm.insert((Object)cheddar);
    }

    @Test
    public void testImplicitDeclarations() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_implicitDeclarations.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.setGlobal("factor", (Object)new Double(1.2));
        Cheese cheese = new Cheese("stilton", 10);
        workingMemory.insert((Object)cheese);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testMVELImplicitWithFrom() {
        String str = "package org.test \nimport java.util.List \nglobal java.util.List list \nglobal java.util.List list2 \nrule \"show\" dialect \"mvel\" \nwhen  \n    $m : List( eval( size == 0 ) ) from [list] \nthen \n    list2.add('r1'); \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("list2", list);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testJavaImplicitWithFrom() {
        String str = "package org.test \nimport java.util.List \nglobal java.util.List list \nglobal java.util.List list2 \nrule \"show\" dialect \"java\" \nwhen  \n    $m : List( eval( size == 0 )  ) from [list] \nthen \n    list2.add('r1'); \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("list2", list);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testCastingInsideEvals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_castsInsideEval.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("value", (Object)new Integer(20));
        workingMemory.fireAllRules();
    }

    @Test
    public void testMemberOfAndNotMemberOf() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_memberOf.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        Cheese muzzarela = new Cheese("muzzarela", 10);
        Cheese brie = new Cheese("brie", 15);
        workingMemory.insert((Object)stilton);
        workingMemory.insert((Object)muzzarela);
        Cheesery cheesery = new Cheesery();
        cheesery.getCheeses().add(stilton.getType());
        cheesery.getCheeses().add(brie.getType());
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)muzzarela, list.get(1));
    }

    @Test
    public void testContainsInArray() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_contains_in_array.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Primitives p = new Primitives();
        p.setStringArray(new String[]{"test1", "test3"});
        workingMemory.insert((Object)p);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"ok1", list.get(0));
        MiscTest.assertEquals((Object)"ok2", list.get(1));
    }

    @Test
    public void testNodeSharingNotExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_nodeSharingNotExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"rule1", list.get(0));
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"rule2", list.get(1));
    }

    @Test
    public void testNullBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_nullBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob"));
        workingMemory.insert((Object)new Person(null));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"OK", list.get(0));
    }

    @Test
    public void testModifyRetractWithFunction() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RetractModifyWithFunction.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stilton", 7);
        Cheese muzzarella = new Cheese("muzzarella", 9);
        int sum = stilton.getPrice() + muzzarella.getPrice();
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        FactHandle muzzarellaHandle = workingMemory.insert((Object)muzzarella);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)sum, (int)stilton.getPrice());
        MiscTest.assertEquals((int)1, (int)workingMemory.getObjectStore().size());
        MiscTest.assertNotNull((Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)stiltonHandle));
        MiscTest.assertNotNull((Object)workingMemory.getFactHandle((Object)stilton));
        MiscTest.assertNull((Object)workingMemory.getObject((org.drools.runtime.rule.FactHandle)muzzarellaHandle));
        MiscTest.assertNull((Object)workingMemory.getFactHandle((Object)muzzarella));
    }

    @Test
    public void testConstraintConnectors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConstraintConnectors.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person youngChili1 = new Person("young chili1");
        youngChili1.setAge(12);
        youngChili1.setHair("blue");
        Person youngChili2 = new Person("young chili2");
        youngChili2.setAge(25);
        youngChili2.setHair("purple");
        Person chili1 = new Person("chili1");
        chili1.setAge(35);
        chili1.setHair("red");
        Person chili2 = new Person("chili2");
        chili2.setAge(38);
        chili2.setHair("indigigo");
        Person oldChili1 = new Person("old chili1");
        oldChili1.setAge(45);
        oldChili1.setHair("green");
        Person oldChili2 = new Person("old chili2");
        oldChili2.setAge(48);
        oldChili2.setHair("blue");
        Person veryold = new Person("very old");
        veryold.setAge(99);
        veryold.setHair("gray");
        workingMemory.insert((Object)youngChili1);
        workingMemory.insert((Object)youngChili2);
        workingMemory.insert((Object)chili1);
        workingMemory.insert((Object)chili2);
        workingMemory.insert((Object)oldChili1);
        workingMemory.insert((Object)oldChili2);
        workingMemory.insert((Object)veryold);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)results.size());
        MiscTest.assertEquals((Object)chili1, results.get(0));
        MiscTest.assertEquals((Object)oldChili1, results.get(1));
        MiscTest.assertEquals((Object)youngChili1, results.get(2));
        MiscTest.assertEquals((Object)veryold, results.get(3));
    }

    @Test
    public void testConnectorsAndOperators() throws Exception {
        KnowledgeBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_ConstraintConnectorsAndOperators.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
        ksession.insert((Object)new StockTick(2L, "IBM", 10.0, 1100L));
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)fired);
    }

    @Test
    public void testConstraintConnectorOr() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_ConstraintConnectorOr.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Person mark = new Person("Mark");
        mark.setAlive(true);
        mark.setHappy(true);
        Person bush = new Person("Bush");
        bush.setAlive(true);
        bush.setHappy(false);
        Person conan = new Person("Conan");
        conan.setAlive(false);
        conan.setHappy(true);
        Person nero = new Person("Nero");
        nero.setAlive(false);
        nero.setHappy(false);
        ksession.insert((Object)mark);
        ksession.insert((Object)bush);
        ksession.insert((Object)conan);
        ksession.insert((Object)nero);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains(mark));
        MiscTest.assertTrue((boolean)results.contains(bush));
        MiscTest.assertTrue((boolean)results.contains(conan));
    }

    @Test
    public void testMatchesNotMatchesCheese() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MatchesNotMatches.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        Cheese stilton2 = new Cheese("stilton2", 12);
        Cheese agedStilton = new Cheese("aged stilton", 12);
        Cheese brie = new Cheese("brie", 10);
        Cheese brie2 = new Cheese("brie2", 10);
        Cheese muzzarella = new Cheese("muzzarella", 10);
        Cheese muzzarella2 = new Cheese("muzzarella2", 10);
        Cheese provolone = new Cheese("provolone", 10);
        Cheese provolone2 = new Cheese("another cheese (provolone)", 10);
        workingMemory.insert((Object)stilton);
        workingMemory.insert((Object)stilton2);
        workingMemory.insert((Object)agedStilton);
        workingMemory.insert((Object)brie);
        workingMemory.insert((Object)brie2);
        workingMemory.insert((Object)muzzarella);
        workingMemory.insert((Object)muzzarella2);
        workingMemory.insert((Object)provolone);
        workingMemory.insert((Object)provolone2);
        workingMemory.fireAllRules();
        logger.info(((Object)list).toString());
        MiscTest.assertEquals((int)4, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)brie, list.get(1));
        MiscTest.assertEquals((Object)agedStilton, list.get(2));
        MiscTest.assertEquals((Object)provolone, list.get(3));
    }

    @Test
    public void testAutomaticBindings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AutoBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        Cheese stilton = new Cheese("stilton", 12);
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)bob, list.get(0));
    }

    @Test
    public void testMatchesMVEL() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MatchesMVEL.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", "hello ;=");
        session.insert(map);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testMatchesMVEL2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_MatchesMVEL2.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", "String with . and (routine)");
        ksession.insert(map);
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)fired);
    }

    @Test
    public void testMatchesMVEL3() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_MatchesMVEL2.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", "String with . and ()");
        ksession.insert(map);
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)fired);
    }

    @Test
    public void testQualifiedFieldReference() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_QualifiedFieldReference.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        Cheese stilton = new Cheese("stilton", 12);
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)bob, list.get(0));
    }

    @Test
    public void testEvalInline() throws Exception {
        String text = "package org.drools\nrule \"inline eval\"\nwhen\n    $str : String()\n    Person( eval( name.startsWith($str) && age == 18) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools\nrule \"inline eval\"\nwhen\n    $str : String()\n    Person( eval( name.startsWith($str) && age == 18) )\nthen\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)"b");
        ksession.insert((Object)new Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)rules);
        ksession.insert((Object)new Person("bob", 18));
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    @Ignore(value="Requires fixing of mvel regression reported at https://github.com/mvel/mvel/pull/4")
    public void testMethodCalls() throws Exception {
        String text = "package org.drools\nrule \"method calls\"\nwhen\n    Person( getName().substring(2) == 'b' )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools\nrule \"method calls\"\nwhen\n    Person( getName().substring(2) == 'b' )\nthen\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)rules);
        ksession.insert((Object)new Person("bob", 18));
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    @Ignore
    public void testAlphaExpression() throws Exception {
        String text = "package org.drools\nrule \"alpha\"\nwhen\n    Person( 5 < 6 )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools\nrule \"alpha\"\nwhen\n    Person( 5 < 6 )\nthen\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testEvalCE() throws Exception {
        String text = "package org.drools\nrule \"inline eval\"\nwhen\n    $str : String()\n    $p   : Person()\n    eval( $p.getName().startsWith($str) && $p.getName().endsWith($str) )then\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools\nrule \"inline eval\"\nwhen\n    $str : String()\n    $p   : Person()\n    eval( $p.getName().startsWith($str) && $p.getName().endsWith($str) )then\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)"b");
        ksession.insert((Object)new Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)rules);
        ksession.insert((Object)new Person("bob", 18));
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testEvalRewrite() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalRewrite.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(10, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        Order order2 = new Order(11, "Bob");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order2.addItem(item21);
        order2.addItem(item22);
        Order order3 = new Order(12, "Bob");
        OrderItem item31 = new OrderItem(order3, 1);
        OrderItem item32 = new OrderItem(order3, 2);
        order3.addItem(item31);
        order3.addItem(item32);
        Order order4 = new Order(13, "Bob");
        OrderItem item41 = new OrderItem(order4, 1);
        OrderItem item42 = new OrderItem(order4, 2);
        order4.addItem(item41);
        order4.addItem(item42);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.insert((Object)order3);
        workingMemory.insert((Object)item31);
        workingMemory.insert((Object)item32);
        workingMemory.insert((Object)order4);
        workingMemory.insert((Object)item41);
        workingMemory.insert((Object)item42);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(item11));
        MiscTest.assertTrue((boolean)list.contains(item12));
        MiscTest.assertTrue((boolean)list.contains(item22));
        MiscTest.assertTrue((boolean)list.contains(order3));
        MiscTest.assertTrue((boolean)list.contains(order4));
    }

    @Test
    public void testMapAccess() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MapAccess.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        workingMemory.insert(map);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(map));
    }

    @Test
    public void testMapNullConstraint() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_mapNullConstraints.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        new WorkingMemoryConsoleLogger((KnowledgeRuntimeEventManager)ksession);
        HashMap<Object, Address> addresses = new HashMap<Object, Address>();
        addresses.put("home", new Address("home street"));
        Person bob = new Person("Bob");
        bob.setNamedAddresses(addresses);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor arg = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)4))).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)arg.capture());
        org.drools.event.rule.AfterActivationFiredEvent aaf = (org.drools.event.rule.AfterActivationFiredEvent)arg.getAllValues().get(0);
        Assert.assertThat((Object)aaf.getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"1. home != null"));
        aaf = (org.drools.event.rule.AfterActivationFiredEvent)arg.getAllValues().get(1);
        Assert.assertThat((Object)aaf.getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"2. not home == null"));
        aaf = (org.drools.event.rule.AfterActivationFiredEvent)arg.getAllValues().get(2);
        Assert.assertThat((Object)aaf.getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"7. work == null"));
        aaf = (org.drools.event.rule.AfterActivationFiredEvent)arg.getAllValues().get(3);
        Assert.assertThat((Object)aaf.getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"8. not work != null"));
    }

    @Test
    public void testNoneTypeSafeDeclarations() {
        String str = "package org.drools\nglobal java.util.List list\ndeclare Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.test\nimport org.drools.Person\nglobal java.util.List list\ndeclare Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.test\nglobal java.util.List list\ndeclare org.drools.Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : org.drools.Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.test\nglobal java.util.List list\ndeclare org.drools.Person\n    @typesafe(true)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : org.drools.Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, false);
    }

    private void executeTypeSafeDeclarations(String str, boolean mustSucceed) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            if (mustSucceed) {
                MiscTest.fail((String)kbuilder.getErrors().toString());
            } else {
                return;
            }
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Address a = new Address("s1");
        Person p = new Person("yoda");
        p.setObject(a);
        ksession.insert((Object)p);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)p, list.get(0));
    }

    @Test
    public void testMapAccessWithVariable() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MapAccessWithVariable.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        workingMemory.insert(map);
        workingMemory.insert((Object)"name");
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(map));
    }

    @Test
    public void testMapAccessWithVariable2() {
        String str = "package org.drools;\nimport java.util.Map;\nrule \"map access with variable\"\n    when\n        $key : String( )\n        $p1 : Person( name == 'Bob', namedAddresses[$key] != null, $na : namedAddresses[$key] )\n        $p2 : Person( name == 'Mark', namedAddresses[$key] == $na )\n    then\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testHalt() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_halt.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)10, (int)results.size());
        for (int i = 0; i < 10; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
    }

    @Test
    public void testFireLimit() throws Exception {
        int i;
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_fireLimit.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)20, (int)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules(10);
        MiscTest.assertEquals((int)10, (int)results.size());
        for (i = 0; i < 10; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules(-1);
        MiscTest.assertEquals((int)20, (int)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
    }

    @Test
    public void testEqualitySupport() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_equalitySupport.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        PersonWithEquals person = new PersonWithEquals("bob", 30);
        workingMemory.insert((Object)person);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)"mark", results.get(0));
    }

    @Test
    public void testCharComparisons() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_charComparisons.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Primitives p1 = new Primitives();
        p1.setCharPrimitive('a');
        p1.setStringAttribute("b");
        Primitives p2 = new Primitives();
        p2.setCharPrimitive('b');
        p2.setStringAttribute("a");
        workingMemory.insert((Object)p1);
        workingMemory.insert((Object)p2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
        MiscTest.assertEquals((Object)"1", results.get(0));
        MiscTest.assertEquals((Object)"2", results.get(1));
        MiscTest.assertEquals((Object)"3", results.get(2));
    }

    @Test
    public void testAlphaNodeSharing() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_alphaNodeSharing.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setShareAlphaNodes(false);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person p1 = new Person("bob", 5);
        workingMemory.insert((Object)p1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"1", results.get(0));
        MiscTest.assertEquals((Object)"2", results.get(1));
    }

    @Test
    public void testSelfReference2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SelfReference2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese());
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testSelfJoinWithIndex() {
        String drl = "";
        drl = drl + "package org.test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1 : Person( $name : name, $age : age )\n";
        drl = drl + "   $p2 : Person( name == $name, age < $age)\n";
        drl = drl + "then\n";
        drl = drl + "    list.add( $p1 );\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", 30);
        org.drools.runtime.rule.FactHandle fh1 = ksession.insert((Object)p1);
        Person p2 = new Person("darth", 25);
        org.drools.runtime.rule.FactHandle fh2 = ksession.insert((Object)p2);
        p1.setName("yoda");
        ksession.update(fh1, (Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testMergingDifferentPackages() throws Exception {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes1.drl")));
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes2.drl")));
            MiscTest.assertEquals((int)2, (int)builder.getPackages().length);
            Package pkg1 = builder.getPackageRegistry("org.drools.package1").getPackage();
            MiscTest.assertEquals((String)"rule 1", (String)pkg1.getRules()[0].getName());
            Package pkg2 = builder.getPackageRegistry("org.drools.package2").getPackage();
            MiscTest.assertEquals((String)"rule 1", (String)pkg2.getRules()[0].getName());
        }
        catch (PackageBuilder.PackageMergeException e) {
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testSelfJoinAndNotWithIndex() {
        String drl = "";
        drl = drl + "package org.test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1 : Person( )\n";
        drl = drl + "     not Person( name == $p1.name, age < $p1.age )\n";
        drl = drl + "   $p2 : Person( name == $p1.name, likes != $p1.likes, age > $p1.age)\n";
        drl = drl + "     not Person( name == $p1.name, likes == $p2.likes, age < $p2.age )\n";
        drl = drl + "then\n";
        drl = drl + "    System.out.println( $p1 + \":\" + $p2 );\n";
        drl = drl + "    list.add( $p1 );\n";
        drl = drl + "    list.add( $p2 );\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p0 = new Person("yoda", 0);
        p0.setLikes("cheddar");
        org.drools.runtime.rule.FactHandle fh0 = ksession.insert((Object)p0);
        Person p1 = new Person("darth", 15);
        p1.setLikes("cheddar");
        org.drools.runtime.rule.FactHandle fh1 = ksession.insert((Object)p1);
        Person p2 = new Person("darth", 25);
        p2.setLikes("cheddar");
        org.drools.runtime.rule.FactHandle fh2 = ksession.insert((Object)p2);
        Person p3 = new Person("darth", 30);
        p3.setLikes("brie");
        org.drools.runtime.rule.FactHandle fh3 = ksession.insert((Object)p3);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertSame((Object)p1, list.get(0));
        MiscTest.assertSame((Object)p3, list.get(1));
        p1.setName("yoda");
        ksession.update(fh1, (Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)4, (int)list.size());
        MiscTest.assertSame((Object)p2, list.get(2));
        MiscTest.assertSame((Object)p3, list.get(3));
    }

    @Test
    public void testMergingDifferentPackages2() throws Exception {
        try {
            PackageBuilder builder1 = new PackageBuilder();
            builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes1.drl")));
            Package pkg1 = builder1.getPackage();
            MiscTest.assertEquals((int)1, (int)pkg1.getRules().length);
            PackageBuilder builder2 = new PackageBuilder();
            builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes2.drl")));
            Package pkg2 = builder2.getPackage();
            MiscTest.assertEquals((int)1, (int)pkg2.getRules().length);
            RuleBase ruleBase = this.getSinglethreadRuleBase();
            ruleBase.addPackage(pkg1);
            ruleBase.addPackage(pkg2);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            StatefulSession workingMemory = ruleBase.newStatefulSession();
            ArrayList results = new ArrayList();
            workingMemory.setGlobal("results", results);
            workingMemory.insert((Object)new Cheese("stilton", 10));
            workingMemory.insert((Object)new Cheese("brie", 5));
            workingMemory.fireAllRules();
            MiscTest.assertEquals((String)((Object)results).toString(), (int)2, (int)results.size());
            MiscTest.assertTrue((boolean)results.contains("p1.r1"));
            MiscTest.assertTrue((boolean)results.contains("p2.r1"));
        }
        catch (PackageBuilder.PackageMergeException e) {
            MiscTest.fail((String)("Should not raise exception when merging different packages into the same rulebase: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testMergePackageWithSameRuleNames() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MergePackageWithSameRuleNames1.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MergePackageWithSameRuleNames2.drl")));
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)"rule1 for the package2", results.get(0));
    }

    @Test
    public void testRuleRemovalWithJoinedRootPattern() {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "  String() \n";
        str = str + "  Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule rule2 \n";
        str = str + "when \n";
        str = str + "  String() \n";
        str = str + "  Cheese() \n";
        str = str + "then \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        DefaultFactHandle handle = (DefaultFactHandle)ksession.insert((Object)"hello");
        LeftTuple leftTuple = handle.getFirstLeftTuple();
        MiscTest.assertNotNull((Object)leftTuple);
        MiscTest.assertNotNull((Object)leftTuple.getLeftParentNext());
        kbase.removeRule("org.drools", "rule2");
        leftTuple = handle.getFirstLeftTuple();
        MiscTest.assertNotNull((Object)leftTuple);
        MiscTest.assertNull((Object)leftTuple.getLeftParentNext());
    }

    @Test
    public void testKnowledgeHelperFixerInStrings() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  no-loop true ";
        str = str + "when \n";
        str = str + "  $fact : String() \n";
        str = str + "then \n";
        str = str + "  list.add(\"This is an update()\"); \n";
        str = str + "  list.add(\"This is an update($fact)\"); \n";
        str = str + "  update($fact); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"hello");
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"This is an update()", list.get(0));
        MiscTest.assertEquals((Object)"This is an update($fact)", list.get(1));
    }

    @Test
    public void testEmptyAfterRetractInIndexedMemory() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx dialect 'mvel' \n";
        str = str + "when \n";
        str = str + "  Person( $name : name ) \n";
        str = str + "  $s : String( this == $name) \n";
        str = str + "then \n";
        str = str + "  list.add($s); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("ackbar");
        org.drools.runtime.rule.FactHandle ph = ksession.insert((Object)p);
        org.drools.runtime.rule.FactHandle sh = ksession.insert((Object)"ackbar");
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"ackbar", list.get(0));
    }

    @Test
    public void testRuleReplacement() throws Exception {
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes1.drl")));
        builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes3.drl")));
        Package pkg1 = builder1.getPackage();
        MiscTest.assertEquals((int)1, (int)pkg1.getRules().length);
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg1);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("brie", 5));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)((Object)results).toString(), (int)0, (int)results.size());
        workingMemory.insert((Object)new Cheese("muzzarella", 7));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)((Object)results).toString(), (int)1, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains("p1.r3"));
    }

    @Test
    public void testBindingsOnConnectiveExpressions() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_bindings.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 15));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"stilton", results.get(0));
        MiscTest.assertEquals((Object)new Integer(15), results.get(1));
    }

    @Test
    public void testMultipleFroms() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_multipleFroms.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 15));
        cheesery.addCheese(new Cheese("brie", 10));
        workingMemory.setGlobal("cheesery", (Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((int)2, (int)((List)results.get(0)).size());
        MiscTest.assertEquals((int)2, (int)((List)results.get(1)).size());
    }

    @Test
    public void testNullHashing() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NullHashing.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 15));
        workingMemory.insert((Object)new Cheese("", 10));
        workingMemory.insert((Object)new Cheese(null, 8));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
    }

    @Test
    public void testDefaultBetaConstrains() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DefaultBetaConstraint.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        FirstClass first = new FirstClass("1", "2", "3", "4", "5");
        FactHandle handle = workingMemory.insert((Object)first);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(0));
        workingMemory.insert((Object)new SecondClass());
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(1));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.insert((Object)new SecondClass(null, "2", "3", "4", "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(2));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", null, "3", "4", "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(3));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", "2", null, "4", "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(4));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", "2", "3", null, "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(5));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", "2", "3", "4", null));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)7, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(6));
        workingMemory.insert((Object)new SecondClass("1", "2", "3", "4", "5"));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)first);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)8, (int)results.size());
        MiscTest.assertEquals((Object)"EQUALS", results.get(7));
    }

    @Test
    public void testBooleanWrapper() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_BooleanWrapper.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Primitives p1 = new Primitives();
        workingMemory.insert((Object)p1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)results.size());
        Primitives p2 = new Primitives();
        p2.setBooleanWrapper(Boolean.FALSE);
        workingMemory.insert((Object)p2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)results.size());
        Primitives p3 = new Primitives();
        p3.setBooleanWrapper(Boolean.TRUE);
        workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testCrossProductRemovingIdentityEquals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(MiscTest.class.getResourceAsStream("test_CrossProductRemovingIdentityEquals.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        rb.addPackage(builder.getPackage());
        rb = SerializationHelper.serializeObject(rb);
        StatefulSession session = rb.newStatefulSession();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        session.setGlobal("list1", list1);
        session.setGlobal("list2", list2);
        SpecialString first42 = new SpecialString("42");
        SpecialString second43 = new SpecialString("43");
        SpecialString world = new SpecialString("World");
        session.insert((Object)world);
        session.insert((Object)first42);
        session.insert((Object)second43);
        session.fireAllRules();
        MiscTest.assertEquals((int)6, (int)list1.size());
        MiscTest.assertEquals((int)6, (int)list2.size());
        MiscTest.assertEquals((Object)first42, list1.get(0));
        MiscTest.assertEquals((Object)world, list1.get(1));
        MiscTest.assertEquals((Object)second43, list1.get(2));
        MiscTest.assertEquals((Object)second43, list1.get(3));
        MiscTest.assertEquals((Object)world, list1.get(4));
        MiscTest.assertEquals((Object)first42, list1.get(5));
        MiscTest.assertEquals((Object)second43, list2.get(0));
        MiscTest.assertEquals((Object)second43, list2.get(1));
        MiscTest.assertEquals((Object)first42, list2.get(2));
        MiscTest.assertEquals((Object)world, list2.get(3));
        MiscTest.assertEquals((Object)first42, list2.get(4));
        MiscTest.assertEquals((Object)world, list2.get(5));
    }

    @Test
    public void testIterateObjects() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_IterateObjects.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        Iterator events = workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(PersonInterface.class));
        MiscTest.assertTrue((boolean)events.hasNext());
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals(results.get(0), events.next());
    }

    @Test
    public void testNotInStatelessSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NotInStatelessSession.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatelessSession session = ruleBase.newStatelessSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)"not integer");
        MiscTest.assertEquals((Object)"not integer", list.get(0));
    }

    @Test
    public void testDynamicallyAddInitialFactRule() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        String rule = "package org.drools.test\nglobal java.util.List list\nrule xxx when\n   i:Integer()\nthen\n   list.add(i);\nend";
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)new Integer(5));
        session.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
        builder = new PackageBuilder();
        rule = "package org.drools.test\nglobal java.util.List list\nrule xxx when\nthen\n   list.add(\"x\");\nend";
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"x", list.get(1));
    }

    @Test
    public void testEvalRewriteWithSpecialOperators() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalRewriteWithSpecialOperators.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(10, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        Order order2 = new Order(11, "Bob");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order2.addItem(item21);
        order2.addItem(item22);
        Order order3 = new Order(12, "Bob");
        OrderItem item31 = new OrderItem(order3, 1);
        OrderItem item32 = new OrderItem(order3, 2);
        OrderItem item33 = new OrderItem(order3, 3);
        order3.addItem(item31);
        order3.addItem(item32);
        order3.addItem(item33);
        Order order4 = new Order(13, "Bob");
        OrderItem item41 = new OrderItem(order4, 1);
        OrderItem item42 = new OrderItem(order4, 2);
        order4.addItem(item41);
        order4.addItem(item42);
        Order order5 = new Order(14, "Mark");
        OrderItem item51 = new OrderItem(order5, 1);
        OrderItem item52 = new OrderItem(order5, 2);
        order5.addItem(item51);
        order5.addItem(item52);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.insert((Object)order3);
        workingMemory.insert((Object)item31);
        workingMemory.insert((Object)item32);
        workingMemory.insert((Object)item33);
        workingMemory.insert((Object)order4);
        workingMemory.insert((Object)item41);
        workingMemory.insert((Object)item42);
        workingMemory.insert((Object)order5);
        workingMemory.insert((Object)item51);
        workingMemory.insert((Object)item52);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)9, (int)list.size());
        int index = 0;
        MiscTest.assertEquals((Object)item11, list.get(index++));
        MiscTest.assertEquals((Object)item12, list.get(index++));
        MiscTest.assertEquals((Object)item21, list.get(index++));
        MiscTest.assertEquals((Object)item22, list.get(index++));
        MiscTest.assertEquals((Object)item31, list.get(index++));
        MiscTest.assertEquals((Object)item33, list.get(index++));
        MiscTest.assertEquals((Object)item41, list.get(index++));
        MiscTest.assertEquals((Object)order5, list.get(index++));
        MiscTest.assertEquals((Object)order5, list.get(index++));
    }

    @Test
    public void testImportColision() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageBuilder builder2 = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested1.drl")));
        builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested2.drl")));
        Package pkg = builder.getPackage();
        Package pkg2 = builder2.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase.addPackage(pkg2);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new FirstClass());
        workingMemory.insert((Object)new SecondClass());
        workingMemory.insert((Object)new FirstClass.AlternativeKey());
        workingMemory.insert((Object)new SecondClass.AlternativeKey());
        workingMemory.fireAllRules();
    }

    @Test
    public void testAutovivificationOfVariableRestrictions() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AutoVivificationVR.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 10, 8));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testShadowProxyOnCollections() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ShadowProxyOnCollections.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Cheesery cheesery = new Cheesery();
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((int)1, (int)cheesery.getCheeses().size());
        MiscTest.assertEquals(results.get(0), (Object)cheesery.getCheeses().get(0));
    }

    @Test
    public void testShadowProxyOnCollections2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ShadowProxyOnCollections2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        ArrayList<String> list = new ArrayList<String>();
        list.add("example1");
        list.add("example2");
        MockPersistentSet mockPersistentSet = new MockPersistentSet(false);
        mockPersistentSet.addAll(list);
        ObjectWithSet objectWithSet = new ObjectWithSet();
        objectWithSet.setSet(mockPersistentSet);
        workingMemory.insert((Object)objectWithSet);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((String)"show", (String)objectWithSet.getMessage());
    }

    @Test
    public void testNestedAccessors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NestedAccessors.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        Order order2 = new Order(12, "Mark");
        Order.OrderStatus status = new Order.OrderStatus();
        status.setActive(true);
        order2.setStatus(status);
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order1.addItem(item21);
        order1.addItem(item22);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertSame((Object)item21, list.get(0));
        MiscTest.assertSame((Object)item22, list.get(1));
    }

    @Test
    public void testWorkingMemoryLoggerWithUnbalancedBranches() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Logger.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wm = ruleBase.newStatefulSession();
        try {
            wm.fireAllRules();
            wm.insert((Object)new Cheese("a", 10));
            wm.insert((Object)new Cheese("b", 11));
            wm.fireAllRules();
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"No exception should be raised ");
        }
    }

    @Test
    public void testFromNestedAccessors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromNestedAccessors.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertSame((Object)order1.getStatus(), list.get(0));
    }

    @Test
    public void testFromArrayIteration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromArrayIteration.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)new DomainObjectHolder());
        session.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"Message3", list.get(0));
        MiscTest.assertEquals((Object)"Message2", list.get(1));
        MiscTest.assertEquals((Object)"Message1", list.get(2));
    }

    @Test
    public void testSubNetworks() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SubNetworks.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        try {
            ruleBase.addPackage(builder.getPackage());
            ruleBase = SerializationHelper.serializeObject(ruleBase);
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"Should not raise any exception!");
        }
    }

    @Test
    public void testFinalClass() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FinalClass.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        PersonFinal bob = new PersonFinal();
        bob.setName("bob");
        bob.setStatus(null);
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testEvalRewriteMatches() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalRewriteMatches.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(14, "Mark");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(item11));
        MiscTest.assertTrue((boolean)list.contains(item12));
    }

    @Test
    public void testConsequenceBuilderException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceBuilderException.drl")));
        MiscTest.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testRuntimeTypeCoercion() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuntimeTypeCoercion.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        PolymorphicFact fact = new PolymorphicFact(new Integer(10));
        FactHandle handle = workingMemory.insert((Object)fact);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)fact.getData(), list.get(0));
        fact.setData("10");
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)fact);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)fact.getData(), list.get(1));
        try {
            fact.setData(new Boolean(true));
            workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)fact);
            MiscTest.assertEquals((int)2, (int)list.size());
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
    }

    @Test
    public void testRuntimeTypeCoercion2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuntimeTypeCoercion2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Primitives fact = new Primitives();
        fact.setBooleanPrimitive(true);
        fact.setBooleanWrapper(new Boolean(true));
        fact.setObject(new Boolean(true));
        fact.setCharPrimitive('X');
        FactHandle handle = workingMemory.insert((Object)fact);
        workingMemory.fireAllRules();
        int index = 0;
        MiscTest.assertEquals((String)((Object)list).toString(), (int)4, (int)list.size());
        MiscTest.assertEquals((Object)"boolean", list.get(index++));
        MiscTest.assertEquals((Object)"boolean wrapper", list.get(index++));
        MiscTest.assertEquals((Object)"boolean object", list.get(index++));
        MiscTest.assertEquals((Object)"char", list.get(index++));
        fact.setBooleanPrimitive(false);
        fact.setBooleanWrapper(null);
        fact.setCharPrimitive('\u0000');
        fact.setObject(new Character('X'));
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)fact);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)list.size());
        MiscTest.assertEquals((Object)"char object", list.get(index++));
        fact.setObject(null);
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)fact);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)list.size());
        MiscTest.assertEquals((Object)"null object", list.get(index++));
    }

    @Test
    public void testAlphaEvalWithOrCE() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AlphaEvalWithOrCE.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        FactA a = new FactA();
        a.setField1("a value");
        workingMemory.insert((Object)a);
        workingMemory.insert((Object)new FactB());
        workingMemory.insert((Object)new FactC());
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"should not have fired", (int)0, (int)list.size());
    }

    @Test
    public void testModifyRetractAndModifyInsert() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ModifyRetractInsert.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("Bob");
        bob.setStatus("hungry");
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)new Cheese());
        workingMemory.insert((Object)new Cheese());
        workingMemory.fireAllRules(2);
        MiscTest.assertEquals((String)"should have fired only once", (int)1, (int)list.size());
    }

    @Test
    public void testAlphaCompositeConstraints() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AlphaCompositeConstraints.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", 30);
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testModifyBlock() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ModifyBlock.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("Bob");
        bob.setStatus("hungry");
        Cheese c = new Cheese();
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)10, (int)c.getPrice());
        MiscTest.assertEquals((String)"fine", (String)bob.getStatus());
    }

    @Test
    public void testModifyBlockWithFrom() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ModifyBlockWithFrom.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person bob = new Person("Bob");
        Address addr = new Address("abc");
        bob.addAddress(addr);
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)addr);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"12345", (String)addr.getZipCode());
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)addr, results.get(0));
    }

    @Test
    public void testJavaModifyBlock() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_JavaModifyBlock.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("Bob", 30);
        bob.setStatus("hungry");
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)new Cheese());
        workingMemory.insert((Object)new Cheese());
        workingMemory.insert((Object)new OuterClass.InnerClass(1));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((String)"full", (String)bob.getStatus());
        MiscTest.assertEquals((int)31, (int)bob.getAge());
        MiscTest.assertEquals((int)2, (int)((OuterClass.InnerClass)list.get(1)).getIntAttr());
    }

    @Test
    public void testOrCE() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OrCE.drl")));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        pkg = SerializationHelper.serializeObject(pkg);
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Person("bob"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"should have fired once", (int)1, (int)list.size());
    }

    @Test
    public void testOrWithAndUsingNestedBindings() {
        String str = "";
        str = str + "package org.drools\n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List mlist\n";
        str = str + "global java.util.List jlist\n";
        str = str + "rule rule1 dialect \"mvel\" \n";
        str = str + "when\n";
        str = str + "$a : Person( name == \"a\" )\n";
        str = str + "  (or $b : Person( name == \"b1\" )\n";
        str = str + "      (and $p : Person( name == \"p2\" )\n";
        str = str + "           $b : Person( name == \"b2\" ) )\n";
        str = str + "      (and $p : Person( name == \"p3\" )\n";
        str = str + "           $b : Person( name == \"b3\" ) )\n";
        str = str + "   )\n ";
        str = str + "then\n";
        str = str + "   mlist.add( $b );\n";
        str = str + "end\n";
        str = str + "rule rule2 dialect \"java\" \n";
        str = str + "when\n";
        str = str + "$a : Person( name == \"a\" )\n";
        str = str + "  (or $b : Person( name == \"b1\" )\n";
        str = str + "      (and $p : Person( name == \"p2\" )\n";
        str = str + "           $b : Person( name == \"b2\" ) )\n";
        str = str + "      (and $p : Person( name == \"p3\" )\n";
        str = str + "           $b : Person( name == \"b3\" ) )\n";
        str = str + "   )\n ";
        str = str + "then\n";
        str = str + "   jlist.add( $b );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        Person a = new Person("a");
        Person b1 = new Person("b1");
        Person p2 = new Person("p2");
        Person b2 = new Person("b2");
        Person p3 = new Person("p3");
        Person b3 = new Person("b3");
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList mlist = new ArrayList();
        ArrayList jlist = new ArrayList();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("mlist", mlist);
        ksession.setGlobal("jlist", jlist);
        ksession.insert((Object)a);
        ksession.insert((Object)b1);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)b1, mlist.get(0));
        MiscTest.assertEquals((Object)b1, jlist.get(0));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("mlist", mlist);
        ksession.setGlobal("jlist", jlist);
        ksession.insert((Object)a);
        ksession.insert((Object)b2);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)b2, mlist.get(1));
        MiscTest.assertEquals((Object)b2, jlist.get(1));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("mlist", mlist);
        ksession.setGlobal("jlist", jlist);
        ksession.insert((Object)a);
        ksession.insert((Object)b3);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)b3, mlist.get(2));
        MiscTest.assertEquals((Object)b3, jlist.get(2));
    }

    @Test
    public void testFieldBindingOnWrongFieldName() {
        KnowledgeBuilder kbuilder;
        String str = "";
        str = str + "package org.drools\n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List mlist\n";
        str = str + "rule rule1 \n";
        str = str + "when\n";
        str = str + "   Person( $f : invalidFieldName, eval( $f != null ) )\n";
        str = str + "then\n";
        str = str + "end\n";
        try {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
            if (!kbuilder.hasErrors()) {
                MiscTest.fail((String)"KnowledgeBuilder should have errors");
            }
        }
        catch (Exception e) {
            MiscTest.fail((String)"Exception should not be thrown ");
        }
        str = "";
        str = str + "package org.drools\n";
        str = str + "import org.drools.Person\n";
        str = str + "global java.util.List mlist\n";
        str = str + "rule rule1 \n";
        str = str + "when\n";
        str = str + "   Person( $f : invalidFieldName, name == ( $f ) )\n";
        str = str + "then\n";
        str = str + "end\n";
        try {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
            if (!kbuilder.hasErrors()) {
                MiscTest.fail((String)"KnowledgeBuilder should have errors");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"Exception should not be thrown ");
        }
    }

    @Test
    public void testDeepNestedConstraints() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DeepNestedConstraints.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob", "muzzarela"));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Cheese("muzzarela", 80));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"should have fired twice", (int)2, (int)list.size());
    }

    @Test
    public void testGetFactHandleEqualityBehavior() throws Exception {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        CheeseEqual cheese = new CheeseEqual("stilton", 10);
        session.insert((Object)cheese);
        FactHandle fh = session.getFactHandle((Object)new CheeseEqual("stilton", 10));
        MiscTest.assertNotNull((Object)fh);
    }

    @Test
    public void testGetFactHandleIdentityBehavior() throws Exception {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.IDENTITY);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        CheeseEqual cheese = new CheeseEqual("stilton", 10);
        session.insert((Object)cheese);
        FactHandle fh1 = session.getFactHandle((Object)new Cheese("stilton", 10));
        MiscTest.assertNull((Object)fh1);
        FactHandle fh2 = session.getFactHandle((Object)cheese);
        MiscTest.assertNotNull((Object)fh2);
    }

    @Test
    public void testOrCEFollowedByEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OrCEFollowedByEval.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new FactA("X"));
        InternalFactHandle b = (InternalFactHandle)workingMemory.insert((Object)new FactB("X"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((String)"should have fired", (int)2, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(b.getObject()));
    }

    @Test
    public void testNPEOnMVELAlphaPredicates() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NPEOnMVELPredicate.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Cheese cheese = new Cheese("stilton", 10);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(cheese);
        Person bob = new Person("bob", "stilton");
        Cheese cheese2 = new Cheese();
        bob.setCheese(cheese2);
        FactHandle p = session.insert((Object)bob);
        FactHandle c = session.insert((Object)cheesery);
        session.fireAllRules();
        MiscTest.assertEquals((String)"should not have fired", (int)0, (int)list.size());
        cheese2.setType("stilton");
        session.update((org.drools.runtime.rule.FactHandle)p, (Object)bob);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testModifyWithLockOnActive() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ModifyWithLockOnActive.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Person bob = new Person("Bob", 15);
        Person mark = new Person("Mark", 16);
        Person michael = new Person("Michael", 14);
        session.insert((Object)bob);
        session.insert((Object)mark);
        session.insert((Object)michael);
        session.setFocus("feeding");
        session.fireAllRules(5);
        MiscTest.assertEquals((int)2, (int)((List)session.getGlobal("results")).size());
    }

    @Test
    public void testNPEOnParenthesis() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_ParenthesisUsage.drl")), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.setGlobal("results", results);
        Person bob = new Person("Bob", 20);
        bob.setAlive(true);
        Person foo = new Person("Foo", 0);
        foo.setAlive(false);
        session.insert((Object)bob);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)bob, results.get(0));
        session.insert((Object)foo);
        session.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)foo, results.get(1));
    }

    @Test
    public void testEvalWithLineBreaks() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_EvalWithLineBreaks.drl")), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.setGlobal("results", results);
        session.insert((Object)10);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)10, results.get(0));
    }

    @Test
    public void testDRLWithoutPackageDeclaration() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_NoPackageDeclaration.drl")), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        FactType factType = kbase.getFactType("defaultpkg", "Person");
        MiscTest.assertNotNull((Object)factType);
        Object bob = factType.newInstance();
        factType.set(bob, "name", (Object)"Bob");
        factType.set(bob, "age", (Object)30);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        session.insert(bob);
        session.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)bob, results.get(0));
    }

    @Test
    public void testKnowledgeContextJava() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_KnowledgeContextJava.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((String)"Hello World", (String)((String)list.get(0)));
    }

    @Test
    public void testListOfMaps() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_TestMapVariableRef.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        HashMap<String, String> mapOne = new HashMap<String, String>();
        HashMap<String, String> mapTwo = new HashMap<String, String>();
        mapOne.put("MSG", "testMessage");
        mapTwo.put("MSGTWO", "testMessage");
        list.add(mapOne);
        list.add(mapTwo);
        ksession.insert(list);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testKnowledgeContextMVEL() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_KnowledgeContextMVEL.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((String)"Hello World", (String)((String)list.get(0)));
    }

    @Test
    public void testJBRules2055() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_JBRules2055.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)new Cheese("brie"));
        ksession.insert((Object)new Cheese("muzzarella"));
        ksession.insert((Object)new Person("bob", "stilton"));
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((String)"stilton", (String)((String)results.get(0)));
        MiscTest.assertEquals((String)"brie", (String)((String)results.get(1)));
    }

    @Test
    public void testJBRules2369() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_JBRules2369.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            MiscTest.fail((String)"Error loading test_JBRules2369");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        FactA a = new FactA();
        FactB b = new FactB(0);
        org.drools.runtime.rule.FactHandle aHandle = ksession.insert((Object)a);
        org.drools.runtime.rule.FactHandle bHandle = ksession.insert((Object)b);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        ksession.update(aHandle, (Object)a);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
    }

    @Test
    public void testInsertionOrder() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_InsertionOrder.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(1, 2));
        ksession.insert((Object)new Move(2, 3));
        Win win2 = new Win(2);
        Win win3 = new Win(3);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains(win2));
        MiscTest.assertTrue((boolean)results.contains(win3));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(2, 3));
        ksession.insert((Object)new Move(1, 2));
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains(win2));
        MiscTest.assertTrue((boolean)results.contains(win3));
    }

    @Test
    public void testFireAllWhenFiringUntilHalt() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        final StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Runnable fireUntilHalt = new Runnable(){

            public void run() {
                ksession.fireUntilHalt();
            }
        };
        Runnable fireAllRules = new Runnable(){

            public void run() {
                ksession.fireAllRules();
            }
        };
        Thread t1 = new Thread(fireUntilHalt);
        Thread t2 = new Thread(fireAllRules);
        t1.start();
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        t2.start();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        boolean aliveT2 = t2.isAlive();
        ksession.halt();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        boolean aliveT1 = t1.isAlive();
        if (t2.isAlive()) {
            t2.interrupt();
        }
        if (t1.isAlive()) {
            t1.interrupt();
        }
        MiscTest.assertFalse((String)"T2 should have finished", (boolean)aliveT2);
        MiscTest.assertFalse((String)"T1 should have finished", (boolean)aliveT1);
    }

    @Test
    @Ignore
    public void testFireUntilHaltFailingAcrossEntryPoints() throws Exception {
        String rule1 = "package org.drools\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule testFireUntilHalt\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "       Cheese()\n";
        rule1 = rule1 + "  $p : Person() from entry-point \"testep\"\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( $p ) ;\n";
        rule1 = rule1 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.info(kbuilder.getErrors().toString());
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        final StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint("testep");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar"));
        ksession.fireAllRules();
        Runnable fireUntilHalt = new Runnable(){

            public void run() {
                ksession.fireUntilHalt();
            }
        };
        Thread t1 = new Thread(fireUntilHalt);
        t1.start();
        Thread.currentThread();
        Thread.sleep(500L);
        ep.insert((Object)new Person("darth"));
        Thread.currentThread();
        Thread.sleep(500L);
        ksession.halt();
        t1.join(5000L);
        boolean alive = t1.isAlive();
        if (alive) {
            t1.interrupt();
        }
        MiscTest.assertFalse((String)"Thread should have died!", (boolean)alive);
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testNetworkBuildErrorAcrossEntryPointsAndFroms() throws Exception {
        String rule1 = "package org.drools\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "         Cheese() from entry-point \"testep\"\n";
        rule1 = rule1 + "    $p : Person() from list\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( \"rule1\" ) ;\n";
        rule1 = rule1 + "  insert( $p );\n";
        rule1 = rule1 + "end\n";
        rule1 = rule1 + "rule rule2\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "  $p : Person() \n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( \"rule2\" ) ;\n";
        rule1 = rule1 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.info(kbuilder.getErrors().toString());
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint("testep");
        ArrayList<Person> list = new ArrayList<Person>();
        ksession.setGlobal("list", list);
        list.add(new Person("darth"));
        ep.insert((Object)new Cheese("cheddar"));
        ksession.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testBindingToMissingField() throws Exception {
        String rule1 = "package org.drools\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Integer( $i : noSuchField ) \n";
        rule1 = rule1 + "    eval( $i > 0 )\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            MiscTest.fail((String)"this should have errors");
        }
    }

    @Test
    public void testJBRules2140() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_JBRules2140.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains("java"));
        MiscTest.assertTrue((boolean)results.contains("mvel"));
    }

    @Test
    public void testGeneratedBeansSerializable() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeansSerializable.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        MiscTest.assertTrue((String)"Generated beans must be serializable", (boolean)Serializable.class.isAssignableFrom(cheeseFact.getFactClass()));
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"brie");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert(cheese);
        ksession.insert(cheese2);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((int)2, (int)((Number)results.get(0)).intValue());
    }

    @Test
    public void testAddRemoveListeners() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_AddRemoveListeners.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryEventListener wmeListener = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        ksession.addEventListener(wmeListener);
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)wmeListener);
        ksession.fireAllRules();
        ksession.insert((Object)new Cheese("brie"));
        ((WorkingMemoryEventListener)Mockito.verify((Object)wmeListener, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
    }

    @Test
    public void testInsert() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "import org.drools.Pet\n";
        drl = drl + "import java.util.ArrayList\n";
        drl = drl + "rule test\n";
        drl = drl + "when\n";
        drl = drl + "$person:Person()\n";
        drl = drl + "$pets : ArrayList()\n";
        drl = drl + "   from collect( \n";
        drl = drl + "      Pet(\n";
        drl = drl + "         ownerName == $person.name\n";
        drl = drl + "      )\n";
        drl = drl + "   )\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            MiscTest.fail((String)errors.toString());
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Person("Toni"));
        ksession.insert((Object)new Pet("Toni"));
    }

    @Test
    public void testMemberOfNotWorkingWithOr() throws Exception {
        String rule = "";
        rule = rule + "package org.drools;\n";
        rule = rule + "import java.util.ArrayList;\n";
        rule = rule + "import org.drools.Person;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $list: ArrayList()                                   \n";
        rule = rule + "    ArrayList()                                          \n";
        rule = rule + "            from collect(                                \n";
        rule = rule + "                  Person(                                \n";
        rule = rule + "                      (                                  \n";
        rule = rule + "                          pet memberOf $list             \n";
        rule = rule + "                      ) || (                             \n";
        rule = rule + "                          pet == null                    \n";
        rule = rule + "                      )                                  \n";
        rule = rule + "                  )                                      \n";
        rule = rule + "            )\n";
        rule = rule + "then\n";
        rule = rule + "  System.out.println(\"hello person\");\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        Person toni = new Person("Toni", 12);
        toni.setPet(new Pet("Mittens"));
        session.insert(new ArrayList());
        session.insert((Object)toni);
        session.fireAllRules();
    }

    @Test
    public void testUnNamed() throws Exception {
        String rule = "";
        rule = rule + "package org.drools;\n";
        rule = rule + "import java.util.ArrayList;\n";
        rule = rule + "import org.drools.Person;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $list: ArrayList()                                   \n";
        rule = rule + "    ArrayList()                                          \n";
        rule = rule + "            from collect(                                \n";
        rule = rule + "                  Person(                                \n";
        rule = rule + "                      (                                  \n";
        rule = rule + "                          pet memberOf $list             \n";
        rule = rule + "                      ) || (                             \n";
        rule = rule + "                          pet == null                    \n";
        rule = rule + "                      )                                  \n";
        rule = rule + "                  )                                      \n";
        rule = rule + "            )\n";
        rule = rule + "then\n";
        rule = rule + "  System.out.println(\"hello person\");\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        Person toni = new Person("Toni", 12);
        toni.setPet(new Pet("Mittens"));
        session.insert(new ArrayList());
        session.insert((Object)toni);
        session.fireAllRules();
    }

    @Test
    @Ignore
    public void testAccessFieldsFromSubClass() throws Exception {
        String rule = "";
        rule = rule + "package org.drools;\n";
        rule = rule + "import org.drools.Person;\n";
        rule = rule + "import org.drools.Pet;\n";
        rule = rule + "import org.drools.Cat;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    Person(\n";
        rule = rule + "      pet.breed == \"Siamise\"\n";
        rule = rule + "    )\n";
        rule = rule + "then\n";
        rule = rule + "System.out.println(\"hello person\");\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        if (builder.hasErrors()) {
            MiscTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        Person person = new Person();
        person.setPet(new Cat("Mittens"));
        session.insert((Object)person);
        session.fireAllRules();
    }

    @Test
    public void testGenericsInRHS() throws Exception {
        String rule = "";
        rule = rule + "package org.drools;\n";
        rule = rule + "import java.util.Map;\n";
        rule = rule + "import java.util.HashMap;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  when\n";
        rule = rule + "  then\n";
        rule = rule + "    Map<String,String> map = new HashMap<String,String>();\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        MiscTest.assertNotNull((Object)session);
    }

    @Test
    public void testActivationListener() throws Exception {
        String rule = "";
        rule = rule + "package org.drools;\n";
        rule = rule + "import java.util.Map;\n";
        rule = rule + "import java.util.HashMap;\n";
        rule = rule + "rule \"Test Rule\" @activationListener('blah')\n";
        rule = rule + "  when\n";
        rule = rule + "     String( this == \"xxx\" )\n ";
        rule = rule + "  then\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        final ArrayList list = new ArrayList();
        conf.addActivationListener("blah", new ActivationListenerFactory(){

            public TerminalNode createActivationListener(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context, Object ... args) {
                return new RuleTerminalNode(id, source, rule, subrule, 0, context){

                    public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
                        list.add("inserted");
                    }

                    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
                        list.add("updated");
                    }

                    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
                        list.add("retracted");
                    }
                };
            }
        });
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        FactHandle fh = session.insert((Object)"xxx");
        session.update((org.drools.runtime.rule.FactHandle)fh, (Object)"xxx");
        session.retract((org.drools.runtime.rule.FactHandle)fh);
        MiscTest.assertEquals((Object)"inserted", list.get(0));
        MiscTest.assertEquals((Object)"updated", list.get(1));
        MiscTest.assertEquals((Object)"retracted", list.get(2));
        MiscTest.assertNotNull((Object)session);
    }

    @Test
    public void testAccessingMapValues() throws Exception {
        String rule = "";
        rule = rule + "package org.drools;\n";
        rule = rule + "import org.drools.Pet;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  when\n";
        rule = rule + "    $pet: Pet()\n";
        rule = rule + "    Pet( \n";
        rule = rule + "      ownerName == $pet.attributes[\"key\"] \n";
        rule = rule + "    )\n";
        rule = rule + "  then\n";
        rule = rule + "    System.out.println(\"hi pet\");\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        MiscTest.assertNotNull((Object)session);
        Pet pet1 = new Pet("Toni");
        pet1.getAttributes().put("key", "value");
        Pet pet2 = new Pet("Toni");
        session.insert((Object)pet1);
        session.insert((Object)pet2);
        session.fireAllRules();
    }

    @Test
    public void testClassLoaderHits() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeansMVEL.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeans.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_NullFieldOnCompositeSink.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }

    @Test
    public void testMVELConsequenceWithoutSemiColon1() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "import org.drools.Pet\n";
        drl = drl + "rule test dialect 'mvel'\n";
        drl = drl + "when\n";
        drl = drl + "$person:Person()\n";
        drl = drl + "$pet:Pet()\n";
        drl = drl + "then\n";
        drl = drl + "    retract($person) // some comment\n";
        drl = drl + "    retract($pet) // another comment\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryEventListener wml = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        ksession.addEventListener(wml);
        org.drools.runtime.rule.FactHandle personFH = ksession.insert((Object)new Person("Toni"));
        org.drools.runtime.rule.FactHandle petFH = ksession.insert((Object)new Pet("Toni"));
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)fired);
        ArgumentCaptor retracts = ArgumentCaptor.forClass(ObjectRetractedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectRetracted((ObjectRetractedEvent)retracts.capture());
        List values = retracts.getAllValues();
        Assert.assertThat((Object)((ObjectRetractedEvent)values.get(0)).getFactHandle(), (Matcher)CoreMatchers.is((Object)personFH));
        Assert.assertThat((Object)((ObjectRetractedEvent)values.get(1)).getFactHandle(), (Matcher)CoreMatchers.is((Object)petFH));
    }

    @Test
    public void testRuleMetaAttributes() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "rule \"test meta attributes\"\n";
        drl = drl + "    @id(1234 ) @author(  john_doe  ) @text(\"It's an escaped\\\" string\"  )\n";
        drl = drl + "when\n";
        drl = drl + "then\n";
        drl = drl + "    // some comment\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        org.drools.definition.rule.Rule rule = kbase.getRule("test", "test meta attributes");
        MiscTest.assertNotNull((Object)rule);
        Assert.assertThat((Object)rule.getMetaAttribute("id"), (Matcher)CoreMatchers.is((Object)"1234"));
        Assert.assertThat((Object)rule.getMetaAttribute("author"), (Matcher)CoreMatchers.is((Object)"john_doe"));
        Assert.assertThat((Object)rule.getMetaAttribute("text"), (Matcher)CoreMatchers.is((Object)"It's an escaped\" string"));
    }

    @Test
    public void testMVELConsequenceUsingFactConstructors() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "global org.drools.runtime.StatefulKnowledgeSession ksession\n";
        drl = drl + "rule test dialect 'mvel'\n";
        drl = drl + "when\n";
        drl = drl + "    $person:Person( name == 'mark' )\n";
        drl = drl + "then\n";
        drl = drl + "    // below constructor for Person does not exist\n";
        drl = drl + "    Person p = new Person( 'bob', 30, 555 )\n";
        drl = drl + "    ksession.update(ksession.getFactHandle($person), new Person('bob', 30, 999, 453, 534, 534, 32))\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testRuleChainingWithLogicalInserts() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_RuleChaining.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                logger.warn(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryEventListener wml = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(wml);
        ksession.addEventListener(ael);
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((int)3, (int)fired);
        ArgumentCaptor actvs = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)actvs.capture());
        List values = actvs.getAllValues();
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)values.get(0)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"init"));
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)values.get(1)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"r1"));
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)values.get(2)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"r2"));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).activationCancelled((ActivationCancelledEvent)Matchers.any(ActivationCancelledEvent.class));
        ((WorkingMemoryEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
        ((WorkingMemoryEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.never())).objectRetracted((ObjectRetractedEvent)Matchers.any(ObjectRetractedEvent.class));
    }

    @Test
    public void testOrWithReturnValueRestriction() throws Exception {
        String fileName = "test_OrWithReturnValue.drl";
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Cheese("brie", 18));
        ksession.insert((Object)new Cheese("stilton", 8));
        ksession.insert((Object)new Cheese("brie", 28));
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)fired);
    }

    @Test
    public void testFromExprFollowedByNot() {
        String rule = "";
        rule = rule + "package org.drools\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "    when\n";
        rule = rule + "        Person ($var: pet )\n";
        rule = rule + "        Pet () from $var\n";
        rule = rule + "        not Pet ()\n";
        rule = rule + "    then\n";
        rule = rule + "       System.out.println(\"Fire in the hole\");\n";
        rule = rule + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                logger.info("kbuilder error: " + ((KnowledgeBuilderError)errors.next()).getMessage());
            }
        }
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
    }

    @Test
    public void testLastMemoryEntryNotBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x1' ) \n";
        str = str + "    not A( this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x1\"); \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x2' ) \n";
        str = str + "    not A( field1 == $s, this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x2\"); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"x1");
        ksession.insert((Object)"x2");
        A a1 = new A("x1", null);
        A a2 = new A("x2", null);
        FactHandle fa1 = (FactHandle)ksession.insert((Object)a1);
        FactHandle fa2 = (FactHandle)ksession.insert((Object)a2);
        ksession.update((org.drools.runtime.rule.FactHandle)fa1, (Object)a1);
        ksession.update((org.drools.runtime.rule.FactHandle)fa2, (Object)a2);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        ksession.dispose();
    }

    @Test
    public void testLastMemoryEntryExistsBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x1' ) \n";
        str = str + "    exists A( this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x1\"); \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x2' ) \n";
        str = str + "    exists A( field1 == $s, this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x2\"); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"x1");
        ksession.insert((Object)"x2");
        A a1 = new A("x1", null);
        A a2 = new A("x2", null);
        FactHandle fa1 = (FactHandle)ksession.insert((Object)a1);
        FactHandle fa2 = (FactHandle)ksession.insert((Object)a2);
        ksession.update((org.drools.runtime.rule.FactHandle)fa1, (Object)a1);
        ksession.update((org.drools.runtime.rule.FactHandle)fa2, (Object)a2);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        ksession.dispose();
    }

    @Test
    public void testNotIterativeModifyBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "when \n";
        str = str + "  $f1 : A() \n";
        str = str + "    not A(this != $f1,  eval(field2 == $f1.getField2())) \n";
        str = str + "    eval( !$f1.getField1().equals(\"1\") ) \n";
        str = str + "then \n";
        str = str + "  list.add($f1); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        A a1 = new A("2", "2");
        A a2 = new A("1", "2");
        A a3 = new A("1", "2");
        FactHandle fa1 = (FactHandle)ksession.insert((Object)a1);
        FactHandle fa2 = (FactHandle)ksession.insert((Object)a2);
        FactHandle fa3 = (FactHandle)ksession.insert((Object)a3);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        a2.setField2("1");
        ksession.update((org.drools.runtime.rule.FactHandle)fa2, (Object)a2);
        a2.setField2("2");
        ksession.update((org.drools.runtime.rule.FactHandle)fa2, (Object)a2);
        ksession.update((org.drools.runtime.rule.FactHandle)fa3, (Object)a3);
        a3.setField2("1");
        ksession.update((org.drools.runtime.rule.FactHandle)fa3, (Object)a3);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        ksession.dispose();
    }

    @Test
    public void testExistsIterativeModifyBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "when \n";
        str = str + "  $f1 : A() \n";
        str = str + "    exists A(this != $f1, eval(field2 == $f1.getField2())) \n";
        str = str + "    eval( !$f1.getField1().equals(\"1\") ) \n";
        str = str + "then \n";
        str = str + "  list.add($f1); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        A a1 = new A("2", "2");
        A a2 = new A("1", "2");
        A a3 = new A("1", "2");
        FactHandle fa1 = (FactHandle)ksession.insert((Object)a1);
        FactHandle fa2 = (FactHandle)ksession.insert((Object)a2);
        FactHandle fa3 = (FactHandle)ksession.insert((Object)a3);
        a1.setField2("1");
        ksession.update((org.drools.runtime.rule.FactHandle)fa1, (Object)a1);
        a1.setField2("2");
        ksession.update((org.drools.runtime.rule.FactHandle)fa1, (Object)a1);
        a2.setField2("1");
        ksession.update((org.drools.runtime.rule.FactHandle)fa2, (Object)a2);
        a2.setField2("2");
        ksession.update((org.drools.runtime.rule.FactHandle)fa2, (Object)a2);
        ksession.update((org.drools.runtime.rule.FactHandle)fa3, (Object)a3);
        a3.setField2("1");
        ksession.update((org.drools.runtime.rule.FactHandle)fa3, (Object)a3);
        ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        ksession.dispose();
    }

    @Test
    public void testBindingsWithOr() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools\ndeclare Assignment\n    source : int\n    target : int\nend\nrule ValueIsTheSame1\nwhen\n    Assignment( $t: target == 10 || target == source )\nthen\nend\nrule ValueIsTheSame2\nwhen\n    Assignment( $t: target == source || target == 10 )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        FactType asgType = kbase.getFactType("org.drools", "Assignment");
        Object asg = asgType.newInstance();
        asgType.set(asg, "source", (Object)10);
        asgType.set(asg, "target", (Object)10);
        ksession.insert(asg);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)2, (int)rules);
    }

    @Test
    @Ignore(value="This test requires MVEL to support .class literals, what it doesn't today")
    public void testMVELClassReferences() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools\ndeclare Assignment\n    source : Class\n    target : Class\nend\nrule ObjectIsAssignable1\nwhen\n    Assignment( $t: target == java.lang.Object.class || target == source )\nthen\nend\nrule ObjectIsAssignable2\nwhen\n    Assignment( $t: target == source || target == java.lang.Object.class )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        FactType asgType = kbase.getFactType("org.drools", "Assignment");
        Object asg = asgType.newInstance();
        asgType.set(asg, "source", Object.class);
        asgType.set(asg, "target", Object.class);
        ksession.insert(asg);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)2, (int)rules);
    }

    @Test
    public void testNotMatchesSucceeds() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools\nrule NotMatches\nwhen\n    Person( name == null || (name != null && name not matches \"-.{2}x.*\" ) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person p = new Person("-..x..xrwx");
        ksession.insert((Object)p);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)0, (int)rules);
    }

    @Test
    public void testNotMatchesFails() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools\nrule NotMatches\nwhen\n    Person( name == null || (name != null && name not matches \"-.{2}x.*\" ) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person p = new Person("d..x..xrwx");
        ksession.insert((Object)p);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testNotEqualsOperator() {
        String str = "package org.drools\nrule NotEquals\nwhen\n    Primitives( booleanPrimitive != booleanWrapper )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Primitives p = new Primitives();
        p.setBooleanPrimitive(true);
        p.setBooleanWrapper(Boolean.FALSE);
        ksession.insert((Object)p);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testNotContainsOperator() {
        String str = "package org.drools\nrule NotContains\nwhen\n    $oi : OrderItem( )\n    $o  : Order( items.values() not contains $oi )then\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Order order1 = new Order(1, "XYZ");
        Order order2 = new Order(2, "ABC");
        OrderItem item11 = new OrderItem(order1, 1);
        order1.addItem(item11);
        OrderItem item21 = new OrderItem(order2, 1);
        order2.addItem(item21);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)rules);
        ksession.insert((Object)item21);
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testOrWithFrom() {
        String str = "package org.drools\nrule NotContains\nwhen\n    $oi1 : OrderItem( )\n    $o1  : Order(number == 1) from $oi1.order; \n    ( eval(true) or eval(true) )\n    $oi2 : OrderItem( )\n    $o2  : Order(number == 2) from $oi2.order; \nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Order order1 = new Order(1, "XYZ");
        Order order2 = new Order(2, "ABC");
        OrderItem item11 = new OrderItem(order1, 1);
        order1.addItem(item11);
        OrderItem item21 = new OrderItem(order2, 1);
        order2.addItem(item21);
        ksession.insert((Object)order1);
        ksession.insert((Object)order2);
        ksession.insert((Object)item11);
        ksession.insert((Object)item21);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)rules);
    }

    @Test
    public void testSoundsLike() {
        String str = "package org.drools\nrule SoundsLike\nwhen\n    Person( name soundslike \"Bob\" )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Person("Bob"));
        ksession.insert((Object)new Person("Mark"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testAgendaFilter1() {
        String str = "package org.drools\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameStartsWithAgendaFilter af = new RuleNameStartsWithAgendaFilter("B");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((int)1, (int)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)arg.capture());
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)arg.getValue()).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Bbb"));
    }

    @Test
    public void testAgendaFilter2() {
        String str = "package org.drools\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameEndsWithAgendaFilter af = new RuleNameEndsWithAgendaFilter("a");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((int)1, (int)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)arg.capture());
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)arg.getValue()).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Aaa"));
    }

    @Test
    public void testAgendaFilter3() {
        String str = "package org.drools\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameMatchesAgendaFilter af = new RuleNameMatchesAgendaFilter(".*b.");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((int)1, (int)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)arg.capture());
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)arg.getValue()).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Bbb"));
    }

    @Test
    public void testAgendaFilter4() {
        String str = "package org.drools\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameEqualsAgendaFilter af = new RuleNameEqualsAgendaFilter("Aaa");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((int)1, (int)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)arg.capture());
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)arg.getValue()).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Aaa"));
    }

    @Test
    public void testRestrictionsWithOr() {
        String str = "package org.drools\nrule \"test\"\nwhen\n    Cheese( price == (1 + 1) );\n    (or eval(true);\n        eval(true);\n    )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Cheese("Stilton", 2));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)rules);
    }

    @Test
    public void testMapModel() {
        String str = "package org.drools\nimport java.util.Map\nrule \"test\"\nwhen\n    Map( type == \"Person\", name == \"Bob\" );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> mark = new HashMap<String, String>();
        mark.put("type", "Person");
        mark.put("name", "Mark");
        ksession.insert(mark);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)0, (int)rules);
        HashMap<String, String> bob = new HashMap<String, String>();
        bob.put("type", "Person");
        bob.put("name", "Bob");
        ksession.insert(bob);
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testConstraintExpression() {
        String str = "package org.drools\nrule \"test\"\nwhen\n    Person( 5*2 > 3 );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Person("Bob"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testMethodConstraint() {
        String str = "package org.drools\nrule \"test\"\nwhen\n    Person( isAlive() );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person person = new Person("Bob");
        person.setAlive(true);
        ksession.insert((Object)person);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testComplexOperator() {
        String str = "package org.drools\nrule \"test in\"\nwhen\n    Person( $name : name in (\"bob\", \"mark\") )\nthen\n    boolean test = $name != null;end\nrule \"test not in\"\nwhen\n    Person( $name : name not in (\"joe\", \"doe\") )\nthen\n    boolean test = $name != null;end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person person = new Person("bob");
        ksession.insert((Object)person);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)rules);
    }

    @Test
    public void testEventsInDifferentPackages() {
        String str = "package org.drools.test\nimport org.drools.*\ndeclare StockTick\n    @role( event )\nend\nrule r1\nwhen\nthen\n    StockTick st = new StockTick();\n    st.setCompany(\"RHT\");\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testClassTypeAttributes() {
        String str = "package org.drools\nrule r1\nwhen\n    Primitives( classAttr == null )then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Primitives());
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    public void testFreeFormExpressions() {
        String str = "package org.drools\nrule r1\nwhen\n    $p1 : Person( age > 2*10, 10 < age )\n    $p2 : Person( age > 2*$p1.age )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person bob = new Person("bob", 30);
        Person mark = new Person("mark", 61);
        ksession.insert((Object)bob);
        ksession.insert((Object)mark);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testFreeFormExpressions2() {
        String str = "package org.drools\nrule r1\nwhen\n    $p1 : Cell( row == 2 )\n    $p2 : Cell( row == $p1.row + 1, row == ($p1.row + 1), row == 1 + $p1.row, row == (1 + $p1.row) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Cell c1 = new Cell(1, 2, 0);
        Cell c2 = new Cell(1, 3, 0);
        ksession.insert((Object)c1);
        ksession.insert((Object)c2);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testAddMissingResourceToPackageBuilder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kbuilder.add(ResourceFactory.newClassPathResource((String)"some.rf"), ResourceType.DRL);
            MiscTest.fail((String)"adding a missing resource should fail");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            kbuilder.add(ResourceFactory.newClassPathResource((String)"some.rf"), ResourceType.DRF);
            MiscTest.fail((String)"adding a missing resource should fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testJBRULES_2995() {
        String str = "package org.drools\nrule r1\nwhen\n    Primitives( classAttr == (java.lang.String.class), \n                eval(classAttr.equals( java.lang.String.class ) ),\n                classAttr == String.class )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Primitives primitives = new Primitives();
        primitives.setClassAttr(String.class);
        ksession.insert((Object)primitives);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testJBRULES2872() {
        String str = "package org.drools.test\nimport org.drools.FactA\nrule X\nwhen\n    FactA( enumVal == TestEnum.ONE || == TestEnum.TWO )\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        logger.info(errors.toString());
        MiscTest.assertEquals((int)1, (int)errors.size());
        KnowledgeBuilderError error = (KnowledgeBuilderError)errors.iterator().next();
        MiscTest.assertEquals((int)5, (int)error.getLines()[0]);
    }

    @Test
    public void testJBRULES3030() {
        String str = "package org.drools\nrule X\nwhen\n    $gp : GrandParent()    $ch : ChildHolder( child == $gp )\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testJBRULES3111() {
        String str = "package org.drools\ndeclare Bool123\n    bool1 : boolean\n    bool2 : boolean\n    bool3 : boolean\nend\ndeclare Thing\n    name : String\n    bool123 : Bool123\nend\nrule kickOff\nwhen\nthen\n    insert( new Thing( \"one\", new Bool123( true, false, false ) ) );\n    insert( new Thing( \"two\", new Bool123( false, false, false ) ) );\n    insert( new Thing( \"three\", new Bool123( false, false, false ) ) );\nend\nrule r1\nwhen\n    $t: Thing( bool123.bool1 == true )\nthen\nend\nrule r2\nwhen\n    $t: Thing( bool123.bool2 == true )\nthen\nend\nrule r3\nwhen\n    $t: Thing( bool123.bool3 == true )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        int rulesFired = ksession.fireAllRules();
        MiscTest.assertEquals((int)2, (int)rulesFired);
        ArgumentCaptor captor = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)captor.capture());
        List aafe = captor.getAllValues();
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)aafe.get(0)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"kickOff"));
        Assert.assertThat((Object)((org.drools.event.rule.AfterActivationFiredEvent)aafe.get(1)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"r1"));
        Object value = ((org.drools.event.rule.AfterActivationFiredEvent)aafe.get(1)).getActivation().getDeclarationValue("$t");
        String name = (String)MVEL.eval((String)"$t.name", Collections.singletonMap("$t", value));
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.is((Object)"one"));
    }

    @Test
    public void testBigLiterals() {
        String str = "package org.drools\nrule X\nwhen\n    Primitives( bigInteger == 10I, bigInteger < (50I), bigDecimal == 10B, bigDecimal < (50B) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Primitives p = new Primitives();
        p.setBigDecimal(BigDecimal.valueOf(10L));
        p.setBigInteger(BigInteger.valueOf(10L));
        ksession.insert((Object)p);
        int rulesFired = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rulesFired);
    }

    @Test
    public void testNonBooleanConstraint() {
        String str = "package org.drools\nimport java.util.List\nrule \"test\"\nwhen\n    $p1: Person( name + name )\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        logger.info(kbuilder.getErrors().toString());
    }

    @Test
    public void testModifyJava() {
        String str = "package org.drools\nimport java.util.List\nrule \"test\"\nwhen\n    $l : List() from collect ( Person( alive == false ) );\nthen\n    for(Object p : $l ) {\n        Person p2 = (Person) p;\n        modify(p2) { setAlive(true) }\n    }\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }

    @Test
    public void testModifyMVEL() {
        String str = "package org.drools\nimport java.util.List\nrule \"test\"\n    dialect \"mvel\"\nwhen\n    $l : List() from collect ( Person( alive == false ) );\nthen\n    for(Object p : $l ) {\n        Person p2 = (Person) p;\n        modify(p2) { setAlive(true) }\n    }\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }

    @Test
    @Ignore(value="TODO unignore when fixing JBRULES-2749")
    public void testPackageNameOfTheBeast() throws Exception {
        String ruleFileContent1 = "package org.drools.integrationtests;\nfunction void myFunction() {\n}\ndeclare MyDeclaredType\n  someProperty: boolean\nend";
        String ruleFileContent2 = "package de.something;\nimport org.drools.integrationtests.*;\nrule \"CheckMyDeclaredType\"\n  when\n    MyDeclaredType()\n  then\n    insertLogical(\"THIS-IS-MY-MARKER-STRING\");\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(ruleFileContent1, ruleFileContent2);
        StatefulKnowledgeSession knowledgeSession = this.createKnowledgeSession(kbase);
        FactType myDeclaredFactType = kbase.getFactType("org.drools.integrationtests", "MyDeclaredType");
        Object myDeclaredFactInstance = myDeclaredFactType.newInstance();
        knowledgeSession.insert(myDeclaredFactInstance);
        int rulesFired = knowledgeSession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rulesFired);
        knowledgeSession.dispose();
    }

    @Test
    public void testGUVNOR578_2() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/primespoc.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        jarInputStreams.add(jis);
        Properties properties = new Properties();
        properties.setProperty("drools.defaultPackageName", "foo.bar");
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration(properties, new ClassLoader[]{loader}));
        PackageDescr pc = new PackageDescr("foo.bar");
        builder.addPackage(pc);
        String header = "import fr.gouv.agriculture.dag.agorha.business.primes.SousPeriodePrimeAgent\n";
        builder.addPackageFromDrl((Reader)new StringReader(header));
        MiscTest.assertFalse((boolean)builder.hasErrors());
        String passingRule = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( echelle == \"abc\" )then\nend\n";
        String failingRule = "rule \"rule2\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( quotiteRemuneration == 123 , echelle == \"abc\" )then\nend\n";
        builder.addPackageFromDrl((Reader)new StringReader(passingRule));
        if (builder.hasErrors()) {
            logger.warn(builder.getErrors().getErrors()[0].getMessage());
        }
        MiscTest.assertFalse((boolean)builder.hasErrors());
        builder.addPackageFromDrl((Reader)new StringReader(failingRule));
        if (builder.hasErrors()) {
            logger.warn(builder.getErrors().getErrors()[0].getMessage());
        }
        MiscTest.assertFalse((boolean)builder.hasErrors());
    }

    @Test
    public void testJBRULES3323() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package de.orbitx.accumulatetesettest;\n");
        rule.append("import java.util.Set;\n");
        rule.append("import java.util.HashSet;\n");
        rule.append("import org.drools.Foo;\n");
        rule.append("import org.drools.Bar;\n");
        rule.append("rule \"Sub optimal foo parallelism - this rule is causing NPE upon reverse\"\n");
        rule.append("when\n");
        rule.append("$foo : Foo($leftId : id, $leftBar : Bar != null)\n");
        rule.append("$fooSet : Set()\n");
        rule.append("from accumulate ( Foo(id > $leftId, bar != null && != $leftBar, $bar : bar),\n");
        rule.append("collectSet( $bar ) )\n");
        rule.append("then\n");
        rule.append("//System.out.println(\"ok\");\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Bar[] barList = new Bar[3];
        for (int i = 0; i < barList.length; ++i) {
            barList[i] = new Bar(String.valueOf(i));
        }
        org.drools.Foo[] fooList = new org.drools.Foo[4];
        for (int i = 0; i < fooList.length; ++i) {
            fooList[i] = new org.drools.Foo(String.valueOf(i), i == 3 ? barList[2] : barList[i]);
        }
        for (org.drools.Foo foo : fooList) {
            ksession.insert((Object)foo);
        }
        int[] magicFoos = new int[]{3, 3, 1, 1, 0, 0, 2, 2, 1, 1, 0, 0, 3, 3, 2, 2, 3, 1, 1};
        int[] magicBars = new int[]{1, 2, 0, 1, 1, 0, 1, 2, 2, 1, 2, 0, 0, 2, 0, 2, 0, 0, 1};
        for (int i = 0; i < magicFoos.length; ++i) {
            org.drools.Foo tehFoo = fooList[magicFoos[i]];
            org.drools.runtime.rule.FactHandle fooFactHandle = ksession.getFactHandle((Object)tehFoo);
            tehFoo.setBar(barList[magicBars[i]]);
            ksession.update(fooFactHandle, (Object)tehFoo);
            ksession.fireAllRules();
        }
        ksession.dispose();
    }

    @Test
    @Ignore
    public void testJBRULES3326() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Message(!!!false)\n");
        rule.append("then\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
        ksession.dispose();
    }

    @Test
    public void testDispose() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Message()\n");
        rule.append("then\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
        ksession.dispose();
        try {
            ksession.fireAllRules();
            MiscTest.fail((String)"An IllegallStateException should have been raised as the session was disposed before the method call.");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
    }

    @Test
    public void testInnerEnum() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Triangle( type == Triangle.Type.UNCLASSIFIED )\n");
        rule.append("then\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Triangle());
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
        ksession.dispose();
    }

    @Test
    public void testNestedAccessors2() throws Exception {
        String rule = "package org.drools\nrule 'rule1'    salience 10\nwhen\n    Cheesery( typedCheeses[0].type == 'stilton' );\nthen\nend\nrule 'rule2'\nwhen\n    Cheesery( typedCheeses[0].price == 10 );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Cheesery c1 = new Cheesery();
        c1.addCheese(new Cheese("stilton", 20));
        Cheesery c2 = new Cheesery();
        c2.addCheese(new Cheese("brie", 10));
        Cheesery c3 = new Cheesery();
        c3.addCheese(new Cheese("muzzarella", 30));
        ksession.insert((Object)c1);
        ksession.insert((Object)c2);
        ksession.insert((Object)c3);
        ksession.fireAllRules();
        ArgumentCaptor captor = ArgumentCaptor.forClass(org.drools.event.rule.AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterActivationFired((org.drools.event.rule.AfterActivationFiredEvent)captor.capture());
        List values = captor.getAllValues();
        Assert.assertThat((Object)((Cheesery)((org.drools.event.rule.AfterActivationFiredEvent)values.get(0)).getActivation().getObjects().get(0)), (Matcher)CoreMatchers.is((Object)c1));
        Assert.assertThat((Object)((Cheesery)((org.drools.event.rule.AfterActivationFiredEvent)values.get(1)).getActivation().getObjects().get(0)), (Matcher)CoreMatchers.is((Object)c2));
        ksession.dispose();
    }

    @Test
    @Ignore
    public void testMVELConstraintsWithFloatingPointNumbersInScientificNotation() {
        String rule = "package test; \n\nglobal java.util.List list;\ndeclare Bean \n field : double \nend \n\nrule \"Init\" \nwhen \nthen \n\t insert( new Bean( 1.0E-2 ) ); \nend \n\nrule \"Check\" \nwhen \n\t Bean( field > 1.0E-1 ) \nthen \n\t list.add( \"OK\" ); \nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession kSession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testMvelDoubleInvocation() throws Exception {
        String rule = "package org.drools\nimport org.drools.integrationtests.MiscTest.TestUtility;\nimport org.drools.integrationtests.MiscTest.TestFact;\nrule \"First Rule\"\n    when\n    $tf : TestFact(TestUtility.utilMethod(s, \"Value1\") == true\n             && i > 0\n    )\n    then\n        System.out.println(\"First Rule Fires\");\nend\n\nrule \"Second Rule\"\n    when\n    $tf : TestFact(TestUtility.utilMethod(s, \"Value2\") == true\n             && i > 0\n    )\n    then\n        System.out.println(\"Second Rule Fires\");\nend\n\nrule \"Third Rule\"\n    when\n    $tf : TestFact(TestUtility.utilMethod(s, \"Value3\") == true\n             && i > 0\n    )\n    then\n        System.out.println(\"Third Rule Fires\");\nend ";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestFact fact = new TestFact();
        fact.setS("asdf");
        fact.setI(10);
        ksession.insert((Object)fact);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testUnwantedCoersion() throws Exception {
        String rule = "package org.drools\nimport org.drools.integrationtests.MiscTest.InnerBean;\nimport org.drools.integrationtests.MiscTest.OuterBean;\nrule \"Test.Code One\"\nwhen\n   OuterBean($code : inner.code in (\"1.50\", \"2.50\"))\nthen\n   System.out.println(\"Code compared values: 1.50, 2.50 - actual code value: \" + $code);\nend\nrule \"Test.Code Two\"\nwhen\n   OuterBean($code : inner.code in (\"1.5\", \"2.5\"))\nthen\n   System.out.println(\"Code compared values: 1.5, 2.5 - actual code value: \" + $code);\nend\nrule \"Big Test ID One\"\nwhen\n   OuterBean($id : id in (\"3.5\", \"4.5\"))\nthen\n   System.out.println(\"ID compared values: 3.5, 4.5 - actual ID value: \" + $id);\nend\nrule \"Big Test ID Two\"\nwhen\n   OuterBean($id : id in ( \"3.0\", \"4.0\"))\nthen\n   System.out.println(\"ID compared values: 3.0, 4.0 - actual ID value: \" + $id);\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        InnerBean innerTest = new InnerBean();
        innerTest.setCode("1.500");
        ksession.insert((Object)innerTest);
        OuterBean outerTest = new OuterBean();
        outerTest.setId("3");
        outerTest.setInner(innerTest);
        ksession.insert((Object)outerTest);
        OuterBean outerTest2 = new OuterBean();
        outerTest2.setId("3.0");
        outerTest2.setInner(innerTest);
        ksession.insert((Object)outerTest2);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testShiftOperator() throws Exception {
        String rule = "dialect \"mvel\"\nrule kickOff\nwhen\nthen\n   insert( Integer.valueOf( 1 ) );\n   insert( Long.valueOf( 1 ) );\n   insert( Integer.valueOf( 65552 ) ); // 0x10010\n   insert( Long.valueOf( 65552 ) );\n   insert( Integer.valueOf( 65568 ) ); // 0x10020\n   insert( Long.valueOf( 65568 ) );\n   insert( Integer.valueOf( 65536 ) ); // 0x10000\n   insert( Long.valueOf( 65536L ) );\n   insert( Long.valueOf( 4294967296L ) ); // 0x100000000L\nend\nrule test1\n   salience -1\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test1 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test2\n   salience -2\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test2 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test3\n   salience -3\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test3 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test4\n   salience -4\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test4 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)13, (int)rules);
    }

    @Test
    public void testRecursiveDeclaration() throws Exception {
        String rule = "package org.drools\ndeclare Node\n    value: String\n    parent: Node\nend\nrule R1 when\n   $parent: Node( value == \"parent\" )\n   $child: Node( $value : value, parent == $parent )\nthen\n   System.out.println( $value );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType nodeType = kbase.getFactType("org.drools", "Node");
        Object parent = nodeType.newInstance();
        nodeType.set(parent, "value", (Object)"parent");
        ksession.insert(parent);
        Object child = nodeType.newInstance();
        nodeType.set(child, "value", (Object)"child");
        nodeType.set(child, "parent", parent);
        ksession.insert(child);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testCircularDeclaration() throws Exception {
        String rule = "declare FactA\n    fieldB: FactB\nend\ndeclare FactB\n    fieldA: FactA\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
    }

    @Test
    public void testPatternMatchingOnThis() throws Exception {
        String rule = "package org.drools\nrule R1 when\n    $i1: Integer()\n    $i2: Integer( this > $i1 )\nthen\n   System.out.println( $i2 + \" > \" + $i1 );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Integer(1));
        ksession.insert((Object)new Integer(2));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((int)1, (int)rules);
    }

    public static class OuterBean {
        private InnerBean inner;
        private String id;

        public InnerBean getInner() {
            return this.inner;
        }

        public void setInner(InnerBean inner) {
            this.inner = inner;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class InnerBean {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static class TestFact {
        private int i;
        private String s;

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }

    public static class TestUtility {
        public static Boolean utilMethod(String s1, String s2) {
            Boolean result = null;
            if (s1 != null) {
                result = s1.equals(s2);
            }
            logger.info("in utilMethod >" + s1 + "<  >" + s2 + "< returns " + result);
            return result;
        }
    }

    public static class A {
        private String field1;
        private String field2;

        public A(String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public String toString() {
            return "A) " + this.field1 + ":" + this.field2;
        }
    }

    public static class Foo {
        public String aValue = "";
    }

    public static class CustomConsequenceExceptionHandler
    implements ConsequenceExceptionHandler {
        private boolean called;

        public void handleException(Activation activation, WorkingMemory workingMemory, Exception exception) {
            this.called = true;
        }

        public boolean isCalled() {
            return this.called;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.called = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.called);
        }
    }
}

