/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.debug.SessionInspector;
import org.drools.core.util.debug.SessionReporter;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutOfMemoryTest
extends CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(OutOfMemoryTest.class);

    @Test
    @Ignore
    public void testStatefulSessionsCreation() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OutOfMemoryError.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        int i = 0;
        SessionConfiguration conf = new SessionConfiguration();
        conf.setKeepReference(true);
        try {
            for (i = 0; i < 300000; ++i) {
                StatefulSession session = ruleBase.newStatefulSession(conf, null);
                session.dispose();
            }
        }
        catch (Throwable e) {
            logger.info("Error at: " + i);
            e.printStackTrace();
            OutOfMemoryTest.fail((String)"Should not raise any error or exception.");
        }
    }

    @Test
    @Ignore
    public void testAgendaLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OutOfMemory.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new Cheese("stilton", 1));
        workingMemory.fireAllRules(3000000);
    }

    @Test
    @Ignore
    public void testMemoryLeak() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_MemoryLeak.drl", OutOfMemoryTest.class), ResourceType.DRL);
        OutOfMemoryTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int pcount = 5;
        Person[] persons = new Person[5];
        FactHandle[] pHandles = new FactHandle[5];
        for (int i = 0; i < persons.length; ++i) {
            persons[i] = new Person("person-0-" + i);
            pHandles[i] = ksession.insert((Object)persons[i]);
        }
        Cheese[] cheeses = new Cheese[5];
        FactHandle[] cHandles = new FactHandle[5];
        for (int i = 0; i < cheeses.length; ++i) {
            cheeses[i] = new Cheese("cheese-0-" + i);
            cHandles[i] = ksession.insert((Object)cheeses[i]);
        }
        ksession.fireAllRules();
        for (int j = 1; j <= 5; ++j) {
            for (int i = 0; i < 5; ++i) {
                cheeses[i].setType("cheese-" + j + "-" + i);
                ksession.update(cHandles[i], (Object)cheeses[i]);
                persons[i].setName("person-" + j + "-" + i);
                ksession.update(pHandles[i], (Object)persons[i]);
            }
            ksession.fireAllRules();
            logger.info("DONE");
        }
        SessionInspector inspector = new SessionInspector(ksession);
        SessionReporter.addNamedTemplate((String)"dump_tuples", (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/drools/core/util/debug/dump_tuples.mvel"));
        String report = SessionReporter.generateReport((String)"dump_tuples", (StatefulKnowledgeSessionInfo)inspector.getSessionInfo(), new HashMap());
        try {
            FileWriter out = new FileWriter("tupleDump.txt");
            out.write(report);
            out.close();
            logger.info(report);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

