/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelCompilationTest {
    private static final int PARALLEL_THREADS = 5;
    private static final ExecutorService executor = Executors.newFixedThreadPool(5);
    private static final String DRL_FILE = "parallel_compilation.drl";
    private List<User> users;

    @Test(timeout=10000L)
    public void testConcurrentRuleAdditions() throws Exception {
        this.parallelExecute(BuildExecutor.getSolvers());
    }

    private void parallelExecute(Collection<Callable<KnowledgeBase>> solvers) throws Exception {
        ExecutorCompletionService<KnowledgeBase> ecs = new ExecutorCompletionService<KnowledgeBase>(executor);
        for (Callable<KnowledgeBase> s : solvers) {
            ecs.submit(s);
        }
        for (int i = 0; i < 5; ++i) {
            KnowledgeBase kbase = (KnowledgeBase)ecs.take().get();
        }
    }

    public static class User {
        private int age;
        private boolean risky;
        private Gender gender;
        private String name;

        public User(int age, Gender gender, String name) {
            this.age = age;
            this.gender = gender;
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isRisky() {
            return this.risky;
        }

        public void setRisky(boolean risky) {
            this.risky = risky;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Gender {
            MALE,
            FEMALE,
            OTHER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildExecutor
    implements Callable<KnowledgeBase> {
        @Override
        public KnowledgeBase call() throws Exception {
            InputStreamReader source = new InputStreamReader(ParallelCompilationTest.class.getResourceAsStream(ParallelCompilationTest.DRL_FILE));
            Properties props = new Properties();
            props.setProperty("drools.dialect.java.compiler", "JANINO");
            props.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
            KnowledgeBuilderConfiguration configuration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)props, (ClassLoader[])new ClassLoader[]{ParallelCompilationTest.class.getClass().getClassLoader()});
            KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)configuration);
            Thread.sleep(Math.round(Math.random() * 250.0));
            Resource newReaderResource = ResourceFactory.newReaderResource((Reader)source);
            builder.add(newReaderResource, ResourceType.DRL);
            KnowledgeBase result = builder.newKnowledgeBase();
            return result;
        }

        public static Collection<Callable<KnowledgeBase>> getSolvers() {
            ArrayList<Callable<KnowledgeBase>> solvers = new ArrayList<Callable<KnowledgeBase>>();
            for (int i = 0; i < 5; ++i) {
                solvers.add(new BuildExecutor());
            }
            return solvers;
        }
    }
}

