/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.type.FactType;
import org.drools.definition.type.Modifies;
import org.drools.definition.type.PropertySpecific;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class PropertySpecificTest
extends CommonTestMethodBase {
    @Test(timeout=5000L)
    public void testPropertySpecific() throws Exception {
        String rule = "package org.drools\nglobal java.util.List list;\ndeclare A\n    a : int\n    b : int\n    s : String\n    i : int\nend\ndeclare B\n    @propertySpecific\n    s : String\n    i : int\nend\nrule R1\nwhen\n    $a : A(s == \"start\");\n    $b : B(s == $a.s);\nthen\n    modify($a) { setS(\"running\") };\n    list.add(\"R1\");\nend\nrule R2\nwhen\n    A($s : s);\n    $b : B(s != $s);\nthen\n    modify($b) { setS($s) };\n    list.add(\"R2\");\nend\nrule R3\nwhen\n    $a : A(s != \"end\");\n    $b : B(i > $a.i);\nthen\n    modify($a) { setS(\"end\") };\n    list.add(\"R3\");\nend\nrule R4\nwhen\n    $a : A(s == \"running\");\n    $b : B(s != $a.s);\nthen\n    modify($b) { setI(2) };\n    list.add(\"R4\");\nend\nrule R5\nwhen\n    $b : B(i == 2, s == \"running\");\nthen\n    modify($b) { setI(4) };\n    list.add(\"R5\");\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType factTypeA = kbase.getFactType("org.drools", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"start");
        factTypeA.set(factA, "i", (Object)3);
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "s", (Object)"start");
        factTypeB.set(factB, "i", (Object)1);
        ksession.insert(factB);
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        int rules = ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        System.out.println(list);
        PropertySpecificTest.assertEquals((int)6, (int)rules);
        PropertySpecificTest.assertEquals((Object)"end", (Object)factTypeB.get(factB, "s"));
        PropertySpecificTest.assertEquals((Object)4, (Object)factTypeB.get(factB, "i"));
        ksession.dispose();
    }

    @Test
    public void testPropertySpecificSimplified() throws Exception {
        String rule = "package org.drools\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertySpecific\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( ! s, on )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType factTypeA = kbase.getFactType("org.drools", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"y");
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "on", (Object)false);
        factTypeB.set(factB, "s", (Object)"x");
        ksession.insert(factB);
        int rules = ksession.fireAllRules();
        PropertySpecificTest.assertEquals((int)2, (int)rules);
        PropertySpecificTest.assertEquals((Object)true, (Object)factTypeB.get(factB, "on"));
        PropertySpecificTest.assertEquals((Object)"y", (Object)factTypeB.get(factB, "s"));
        ksession.dispose();
    }

    @Test
    public void testWatchNothing() throws Exception {
        String rule = "package org.drools\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertySpecific\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( !* )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType factTypeA = kbase.getFactType("org.drools", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"y");
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "on", (Object)false);
        factTypeB.set(factB, "s", (Object)"x");
        ksession.insert(factB);
        int rules = ksession.fireAllRules();
        PropertySpecificTest.assertEquals((int)2, (int)rules);
        PropertySpecificTest.assertEquals((Object)true, (Object)factTypeB.get(factB, "on"));
        PropertySpecificTest.assertEquals((Object)"y", (Object)factTypeB.get(factB, "s"));
        ksession.dispose();
    }

    @Test
    public void testWrongPropertyNameInWatchAnnotation() throws Exception {
        String rule = "package org.drools\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertySpecific\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( !s1, on )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        PropertySpecificTest.assertEquals((int)1, (int)kbuilder.getErrors().size());
    }

    @Test
    public void testDuplicatePropertyNamesInWatchAnnotation() throws Exception {
        String rule = "package org.drools\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertySpecific\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( s, !s )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        PropertySpecificTest.assertEquals((int)1, (int)kbuilder.getErrors().size());
    }

    @Test
    public void testWrongUasgeOfWatchAnnotationOnNonPropertySpecificClass() throws Exception {
        String rule = "package org.drools\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( !s, on )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        PropertySpecificTest.assertEquals((int)1, (int)kbuilder.getErrors().size());
    }

    @Test
    public void testPropertySpecificJavaBean() throws Exception {
        String rule = "package org.drools\nimport org.drools.integrationtests.PropertySpecificTest.C\ndeclare A\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $c : C(s != $s)\nthen\n    modify($c) { setS($s) }\nend\nrule R2\nwhen\n    $c : C(on == false)\nthen\n    modify($c) { turnOn() }\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType factTypeA = kbase.getFactType("org.drools", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"y");
        ksession.insert(factA);
        C c = new C();
        c.setOn(false);
        c.setS("x");
        ksession.insert((Object)c);
        int rules = ksession.fireAllRules();
        PropertySpecificTest.assertEquals((int)2, (int)rules);
        PropertySpecificTest.assertEquals((boolean)true, (boolean)c.isOn());
        PropertySpecificTest.assertEquals((String)"y", (String)c.getS());
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testPropertySpecificOnAlphaNode() throws Exception {
        String rule = "package org.drools\nimport org.drools.integrationtests.PropertySpecificTest.C\nrule R1\nwhen\n    $c : C(s == \"test\")\nthen\n    modify($c) { turnOn() }\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        C c = new C();
        c.setOn(false);
        c.setS("test");
        ksession.insert((Object)c);
        int rules = ksession.fireAllRules();
        PropertySpecificTest.assertEquals((int)1, (int)rules);
        PropertySpecificTest.assertEquals((boolean)true, (boolean)c.isOn());
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RuntimeException.class)
    public void testInfiniteLoop() throws Exception {
        String rule = "package org.drools\nimport org.drools.integrationtests.PropertySpecificTest.C\nglobal java.util.concurrent.atomic.AtomicInteger counter\nrule R1\nwhen\n    $c : C(s == \"test\") @watch( on )\nthen\n    modify($c) { turnOn() }\n    if (counter.incrementAndGet() > 10) throw new RuntimeException();\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        C c = new C();
        c.setOn(false);
        c.setS("test");
        ksession.insert((Object)c);
        try {
            ksession.fireAllRules();
            PropertySpecificTest.assertTrue((counter.get() >= 10 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            PropertySpecificTest.assertTrue((counter.get() >= 10 ? 1 : 0) != 0);
            ksession.dispose();
            throw throwable;
        }
        ksession.dispose();
    }

    @Test
    public void testBetaNodePropagation() throws Exception {
        String rule = "package org.drools\nimport org.drools.integrationtests.PropertySpecificTest.Hero\nimport org.drools.integrationtests.PropertySpecificTest.MoveCommand\nrule \"Move\" when\n   $mc : MoveCommand( move == 1 )   $h  : Hero( canMove == true )then\n   modify( $h ) { setPosition($h.getPosition() + 1) };\n   retract ( $mc );\n   System.out.println( \"Move: \" + $h + \" : \" + $mc );end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Hero hero = new Hero();
        hero.setPosition(0);
        hero.setCanMove(true);
        ksession.insert((Object)hero);
        ksession.fireAllRules();
        MoveCommand moveCommand = new MoveCommand();
        moveCommand.setMove(1);
        ksession.insert((Object)moveCommand);
        ksession.fireAllRules();
        moveCommand = new MoveCommand();
        moveCommand.setMove(1);
        ksession.insert((Object)moveCommand);
        ksession.fireAllRules();
        PropertySpecificTest.assertEquals((int)2, (int)hero.getPosition());
    }

    @PropertySpecific
    public static class MoveCommand {
        private int move;

        public int getMove() {
            return this.move;
        }

        public void setMove(int move) {
            this.move = move;
        }

        public String toString() {
            return "MoveCommand{move=" + this.move + '}';
        }
    }

    @PropertySpecific
    public static class Hero {
        private boolean canMove;
        private int position;

        public boolean isCanMove() {
            return this.canMove;
        }

        public void setCanMove(boolean canMove) {
            this.canMove = canMove;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String toString() {
            return "Hero{position=" + this.position + '}';
        }
    }

    @PropertySpecific
    public static class C {
        private boolean on;
        private String s;

        public boolean isOn() {
            return this.on;
        }

        public void setOn(boolean on) {
            this.on = on;
        }

        @Modifies(value={"on"})
        public void turnOn() {
            this.setOn(true);
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }
}

