/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.Address;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.DomainObject;
import org.drools.FactHandle;
import org.drools.InsertedObject;
import org.drools.Interval;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.QueryResult;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.Worker;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.NodeMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.Entry;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ObjectHashSet;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooWorkingMemoryInterface;
import org.drools.rule.Package;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.conf.QueryListenerOption;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.runtime.rule.Row;
import org.drools.runtime.rule.Variable;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.drools.runtime.rule.impl.FlatQueryResults;
import org.junit.Test;

public class QueryTest
extends CommonTestMethodBase {
    @Test
    public void testQuery() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("simple_query_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testQueryRemoval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("simple_query_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertNotNull((Object)ruleBase.getPackage("org.drools.test").getRule("simple query"));
        ruleBase.removeQuery("org.drools.test", "simple query");
        QueryTest.assertNull((Object)ruleBase.getPackage("org.drools.test").getRule("simple query"));
        results = session.getQueryResults("simple query", new Object[0]);
        QueryTest.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testQuery2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Query.drl")));
        if (builder.hasErrors()) {
            QueryTest.fail((String)builder.getErrors().toString());
        }
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("assertedobjquery", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value1"), (Object)results.get(0).get(0));
    }

    @Test
    public void testQuery2KnowledgeBuilder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Query.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        kbase.addKnowledgePackages(kbase.getKnowledgePackages());
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("assertedobjquery", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value1"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
    }

    @Test
    public void testQueryWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_QueryWithParams.drl")));
        if (builder.hasErrors()) {
            QueryTest.fail((String)builder.getErrors().toString());
        }
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("assertedobjquery", (Object[])new String[]{"value1"});
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value1"), (Object)results.get(0).get(0));
        results = workingMemory.getQueryResults("assertedobjquery", (Object[])new String[]{"value3"});
        QueryTest.assertEquals((int)0, (int)results.size());
        results = workingMemory.getQueryResults("assertedobjquery2", (Object[])new String[]{null, "value2"});
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value2"), (Object)results.get(0).get(0));
        results = workingMemory.getQueryResults("assertedobjquery2", (Object[])new String[]{"value3", "value2"});
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value2"), (Object)results.get(0).get(0));
    }

    @Test
    public void testQueryWithParamsOnKnowledgeApi() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_QueryWithParams.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("assertedobjquery", (Object[])new String[]{"value1"});
        QueryTest.assertEquals((int)1, (int)results.size());
        results = ksession.getQueryResults("assertedobjquery", (Object[])new String[]{"value3"});
        QueryTest.assertEquals((int)0, (int)results.size());
        results = ksession.getQueryResults("assertedobjquery2", (Object[])new String[]{null, "value2"});
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value2"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
        results = ksession.getQueryResults("assertedobjquery2", (Object[])new String[]{"value3", "value2"});
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)new InsertedObject("value2"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
    }

    @Test
    public void testQueryWithMultipleResultsOnKnowledgeApi() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        list = new ArrayList();
        list.add(stilton3);
        list.add(cheddar3);
        set.add(list);
        ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        ksession.insert((Object)cheddar3);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("cheeses", new Object[0]);
        QueryTest.assertEquals((int)3, (int)results.size());
        QueryTest.assertEquals((int)2, (int)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        QueryTest.assertEquals(set, newSet);
        FlatQueryResults flatResults = new FlatQueryResults(((StatefulKnowledgeSessionImpl)ksession).session.getQueryResults("cheeses", new Object[0]));
        QueryTest.assertEquals((int)3, (int)flatResults.size());
        QueryTest.assertEquals((int)2, (int)flatResults.getIdentifiers().length);
        newSet = new HashSet();
        for (QueryResultsRow result : flatResults) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        QueryTest.assertEquals(set, newSet);
    }

    @Test
    public void testTwoQuerries() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_TwoQuerries.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        workingMemory.insert((Object)stilton);
        Person per1 = new Person("stinker", "smelly feet", 70);
        Person per2 = new Person("skunky", "smelly armpits", 40);
        workingMemory.insert((Object)per1);
        workingMemory.insert((Object)per2);
        QueryResults results = workingMemory.getQueryResults("find stinky cheeses", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
        results = workingMemory.getQueryResults("find pensioners", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testDoubleQueryWithExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DoubleQueryWithExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = workingMemory.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = workingMemory.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        QueryResults queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)2, (int)queryResults.size());
        p3.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)1, (int)queryResults.size());
        p2.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)1, (int)queryResults.size());
        p1.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)2, (int)queryResults.size());
        p2.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)1, (int)queryResults.size());
        p1.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)1, (int)queryResults.size());
        p3.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        QueryTest.assertEquals((int)2, (int)queryResults.size());
    }

    @Test
    public void testQueryWithCollect() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Query.drl")));
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("collect objects", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryResult result = results.get(0);
        List list = (List)result.get("$list");
        QueryTest.assertEquals((int)2, (int)list.size());
    }

    @Test
    public void testDroolsQueryCleanup() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_QueryMemoryLeak.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        String workerId = "B1234";
        Worker worker = new Worker();
        worker.setId(workerId);
        org.drools.runtime.rule.FactHandle handle = ksession.insert((Object)worker);
        ksession.fireAllRules();
        QueryTest.assertNotNull((Object)handle);
        org.drools.runtime.rule.QueryResults retractedWorker = null;
        for (int i = 0; i < 100; ++i) {
            retractedWorker = ksession.getQueryResults("getWorker", new Object[]{workerId});
        }
        QueryTest.assertNotNull(retractedWorker);
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        ReteooWorkingMemoryInterface reteWorkingMemory = sessionImpl.session;
        AbstractWorkingMemory abstractWorkingMemory = (AbstractWorkingMemory)reteWorkingMemory;
        InternalRuleBase ruleBase = (InternalRuleBase)abstractWorkingMemory.getRuleBase();
        Collection entryPointNodes = ruleBase.getRete().getEntryPointNodes().values();
        EntryPointNode defaultEntryPointNode = null;
        for (EntryPointNode epNode : entryPointNodes) {
            if (epNode.getEntryPoint().getEntryPointId() != "DEFAULT") continue;
            defaultEntryPointNode = epNode;
            break;
        }
        QueryTest.assertNotNull(defaultEntryPointNode);
        Map obnodes = defaultEntryPointNode.getObjectTypeNodes();
        ClassObjectType key = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode droolsQueryNode = (ObjectTypeNode)obnodes.get(key);
        ObjectHashSet droolsQueryMemory = (ObjectHashSet)abstractWorkingMemory.getNodeMemory((NodeMemory)droolsQueryNode);
        QueryTest.assertEquals((int)0, (int)droolsQueryMemory.size());
        Entry[] entries = droolsQueryMemory.getTable();
        int entryCounter = 0;
        for (Entry entry : entries) {
            if (entry == null) continue;
            ++entryCounter;
            ObjectHashMap.ObjectEntry oEntry = (ObjectHashMap.ObjectEntry)entry;
            DefaultFactHandle factHandle = (DefaultFactHandle)oEntry.getValue();
            QueryTest.assertNull((Object)factHandle.getObject());
        }
    }

    @Test
    public void testQueriesWithVariableUnification() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( String $name, String $likes, int $age ) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((int)4, (int)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)4, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("luke"));
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("bobba"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, 300});
        QueryTest.assertEquals((int)3, (int)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)3, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("luke"));
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("bobba"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", 300});
        QueryTest.assertEquals((int)1, (int)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)1, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, "stilton", Variable.v});
        QueryTest.assertEquals((int)2, (int)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)2, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{"darth", Variable.v, Variable.v});
        QueryTest.assertEquals((int)1, (int)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)1, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnPatterns() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( Person $p, String $name, String $likes, int $age ) \n";
        str = str + "    $p := Person( $name := name, $likes := likes, $age := age ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((int)4, (int)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)4, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("luke"));
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("bobba"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{p1, Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((int)1, (int)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertEquals((int)1, (int)names.size());
        QueryTest.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnNestedFields() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( String $name, String $likes, String $street) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $street := address.street ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, Variable.v});
        QueryTest.assertEquals((int)2, (int)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertTrue((boolean)names.contains("yoda"));
        QueryTest.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.v, Variable.v, "s1"});
        QueryTest.assertEquals((int)1, (int)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        QueryTest.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testOpenQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses(String $type1, String $type2) \n";
        str = str + "    stilton : Cheese(type == $type1, $sprice : price) \n";
        str = str + "    cheddar : Cheese(type == $type2, $cprice : price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        org.drools.runtime.rule.FactHandle s1Fh = ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        org.drools.runtime.rule.FactHandle c3Fh = ksession.insert((Object)cheddar3);
        final ArrayList updated = new ArrayList();
        final ArrayList removed = new ArrayList();
        final ArrayList added = new ArrayList();
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                updated.add(array);
            }

            public void rowRemoved(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                removed.add(array);
            }

            public void rowAdded(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                added.add(array);
            }
        };
        LiveQuery query = ksession.openLiveQuery("cheeses", new Object[]{"stilton", "cheddar"}, listener);
        QueryTest.assertEquals((int)3, (int)added.size());
        QueryTest.assertEquals((int)0, (int)removed.size());
        QueryTest.assertEquals((int)0, (int)updated.size());
        QueryTest.assertSame((Object)stilton1, (Object)((Object[])added.get(0))[0]);
        QueryTest.assertSame((Object)cheddar1, (Object)((Object[])added.get(0))[1]);
        QueryTest.assertEquals((Object)1, (Object)((Object[])added.get(0))[2]);
        QueryTest.assertEquals((Object)1, (Object)((Object[])added.get(0))[3]);
        QueryTest.assertEquals((Object)"stilton", (Object)((Object[])added.get(0))[4]);
        QueryTest.assertEquals((Object)"cheddar", (Object)((Object[])added.get(0))[5]);
        QueryTest.assertEquals((Object)1, (Object)((Object[])added.get(0))[3]);
        QueryTest.assertEquals((Object)2, (Object)((Object[])added.get(1))[3]);
        QueryTest.assertEquals((Object)3, (Object)((Object[])added.get(2))[3]);
        cheddar3.setPrice(4);
        ksession.update(c3Fh, (Object)cheddar3);
        QueryTest.assertEquals((int)3, (int)added.size());
        QueryTest.assertEquals((int)1, (int)removed.size());
        QueryTest.assertEquals((int)0, (int)updated.size());
        QueryTest.assertEquals((Object)4, (Object)((Object[])removed.get(0))[3]);
        cheddar3.setPrice(3);
        ksession.update(c3Fh, (Object)cheddar3);
        QueryTest.assertEquals((int)4, (int)added.size());
        QueryTest.assertEquals((int)1, (int)removed.size());
        QueryTest.assertEquals((int)0, (int)updated.size());
        QueryTest.assertEquals((Object)3, (Object)((Object[])added.get(3))[3]);
        cheddar3.setOldPrice(0);
        ksession.update(c3Fh, (Object)cheddar3);
        QueryTest.assertEquals((int)4, (int)added.size());
        QueryTest.assertEquals((int)1, (int)removed.size());
        QueryTest.assertEquals((int)1, (int)updated.size());
        QueryTest.assertEquals((Object)3, (Object)((Object[])updated.get(0))[3]);
        ksession.retract(s1Fh);
        QueryTest.assertEquals((int)4, (int)added.size());
        QueryTest.assertEquals((int)2, (int)removed.size());
        QueryTest.assertEquals((int)1, (int)updated.size());
        QueryTest.assertEquals((Object)1, (Object)((Object[])removed.get(1))[3]);
        query.close();
        QueryTest.assertEquals((int)4, (int)added.size());
        QueryTest.assertEquals((int)4, (int)removed.size());
        QueryTest.assertEquals((int)1, (int)updated.size());
        QueryTest.assertEquals((Object)2, (Object)((Object[])removed.get(2))[3]);
        QueryTest.assertEquals((Object)3, (Object)((Object[])removed.get(3))[3]);
        ksession.update(c3Fh, (Object)cheddar3);
        QueryTest.assertEquals((int)4, (int)added.size());
        QueryTest.assertEquals((int)4, (int)removed.size());
        QueryTest.assertEquals((int)1, (int)updated.size());
    }

    @Test
    public void testStandardQueryListener() {
        this.runQueryListenerTest(QueryListenerOption.STANDARD);
    }

    @Test
    public void testNonCloningQueryListener() {
        this.runQueryListenerTest(QueryListenerOption.LIGHTWEIGHT);
    }

    public void runQueryListenerTest(QueryListenerOption option) {
        String str = "";
        str = str + "package org.drools\n";
        str = str + "query cheeses(String $type) \n";
        str = str + "    $cheese : Cheese(type == $type) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)option);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        for (int i = 0; i < 10000; ++i) {
            ksession.insert((Object)new Cheese(i % 2 == 0 ? "stilton" : "brie"));
        }
        for (int i = 0; i < 100; ++i) {
            org.drools.runtime.rule.QueryResults queryResults = ksession.getQueryResults("cheeses", new Object[]{"stilton"});
            ArrayList<Cheese> cheeses = new ArrayList<Cheese>();
            for (QueryResultsRow row : queryResults) {
                cheeses.add((Cheese)row.get("$cheese"));
            }
            QueryTest.assertEquals((int)5000, (int)cheeses.size());
        }
    }

    @Test
    public void testQueryWithEval() {
        String str = "package org.drools\nquery queryWithEval \n    $do: DomainObject()\n    not DomainObject( id == $do.id, eval(interval.isAfter($do.getInterval())))\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        DomainObject do1 = new DomainObject();
        do1.setId(1L);
        do1.setInterval(new Interval(10L, 5L));
        DomainObject do2 = new DomainObject();
        do2.setId(1L);
        do2.setInterval(new Interval(20L, 5L));
        ksession.insert((Object)do1);
        ksession.insert((Object)do2);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("queryWithEval", new Object[0]);
        QueryTest.assertEquals((int)1, (int)results.size());
        QueryTest.assertEquals((Object)do2, (Object)((QueryResultsRow)results.iterator().next()).get("$do"));
        ksession.dispose();
    }

    private KnowledgeBase loadKnowledgeBaseFromString(String str) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            QueryTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

