/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.KnowledgeBase;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.agent.impl.PrintStreamSystemEventListener;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.junit.Assert;
import org.junit.Test;

public class ScannerChangeSetTest {
    public static final String TMP_DIR = "target/classes/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPKGByResourceChangeScanner() throws Exception {
        SystemEventListenerFactory.setSystemEventListener((SystemEventListener)new PrintStreamSystemEventListener(System.out));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("Sample.drl")));
        Package pkg = builder.getPackage();
        byte[] blob1 = DroolsStreamUtils.streamOut((Object)pkg);
        File file = new File("target/classes/rules.pkg");
        this.writeBinaryFile(file, blob1);
        Thread.sleep(1100L);
        String XLS_CHANGESET = "<change-set xmlns=\"http://drools.org/drools-5.0/change-set\"\n            xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n            xs:schemaLocation=\"http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd\">\n  <add>\n    <resource source=\"file:" + file.getAbsolutePath() + "\" type=\"PKG\" />\n" + "  </add>\n" + "</change-set>\n";
        File xlsChangeset = new File("target/classes/pkgChangeset.xml");
        xlsChangeset.deleteOnExit();
        ScannerChangeSetTest.writeToFile(xlsChangeset, XLS_CHANGESET);
        ResourceChangeScannerConfiguration config = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        config.setProperty("drools.resource.scanner.interval", "1");
        ResourceFactory.getResourceChangeScannerService().configure(config);
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"xls agent");
        kagent.applyChangeSet(ResourceFactory.newFileResource((File)xlsChangeset));
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)2L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        Rule hw = pkg.getRule("Hello World");
        pkg.removeRule(hw);
        byte[] blob2 = DroolsStreamUtils.streamOut((Object)pkg);
        Thread.sleep(1500L);
        this.writeBinaryFile(file, blob2);
        Thread.sleep(1500L);
        try {
            kbase = kagent.getKnowledgeBase();
            Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
            Assert.assertEquals((long)1L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        }
        finally {
            ResourceFactory.getResourceChangeNotifierService().stop();
            ResourceFactory.getResourceChangeScannerService().stop();
            file.delete();
            kagent.dispose();
        }
    }

    private void writeBinaryFile(File file, byte[] blob1) throws FileNotFoundException, IOException {
        file.delete();
        FileOutputStream out = new FileOutputStream(file);
        out.write(blob1);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, String content) throws Exception {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(content);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

