/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.BatchExecutionCommand;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.concurrent.Future;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class StatefulSessionTest
extends CommonTestMethodBase {
    final List list = new ArrayList();

    @Test
    public void testSingleObjectAssert() throws Exception {
        StatefulSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        Future futureAssert = session.asyncInsert((Object)stilton);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof FactHandle));
        StatefulSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    @Test
    public void testInsertObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "end\n";
        Cheese stilton = new Cheese("stilton", 5);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Command insertCmd = CommandFactory.newInsert((Object)stilton, (String)"outStilton");
        Command fireCmd = CommandFactory.newFireAllRules();
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(Arrays.asList(insertCmd, fireCmd));
        ExecutionResults result = (ExecutionResults)ksession.execute((Command)cmds);
        stilton = (Cheese)result.getValue("outStilton");
        StatefulSessionTest.assertEquals((int)30, (int)stilton.getPrice());
        Object o = ksession.getObject((org.drools.runtime.rule.FactHandle)((FactHandle)result.getFactHandle("outStilton")));
        StatefulSessionTest.assertSame((Object)o, (Object)stilton);
    }

    @Test
    public void testArrayObjectAssert() throws Exception {
        StatefulSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        Future futureAssert = session.asyncInsert(new Object[]{stilton});
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    @Test
    public void testCollectionObjectAssert() throws Exception {
        StatefulSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        Future futureAssert = session.asyncInsert(collection);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    @Test
    public void testHasExceptionSingleAssert() throws Exception {
        StatefulSession session = this.getExceptionSession();
        Cheese brie = new Cheese("brie", 12);
        Future futureAssert = session.asyncInsert((Object)brie);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof FactHandle));
        StatefulSessionTest.assertTrue((boolean)futureFireAllRules.exceptionThrown());
        StatefulSessionTest.assertTrue((boolean)(futureFireAllRules.getException() instanceof Exception));
    }

    @Test
    public void testHasExceptionArrayAssert() throws Exception {
        StatefulSession session = this.getExceptionSession();
        Cheese brie = new Cheese("brie", 12);
        Future futureAssert = session.asyncInsert(new Object[]{brie});
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(300L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertTrue((boolean)(futureFireAllRules.getException() instanceof Exception));
    }

    @Test
    public void testHasExceptionCollectionAssert() throws Exception {
        StatefulSession session = this.getExceptionSession();
        Cheese brie = new Cheese("brie", 12);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(brie);
        Future futureAssert = session.asyncInsert(collection);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertTrue((boolean)(futureFireAllRules.getException() instanceof Exception));
    }

    @Test
    public void testSequentialException() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setSequential(true);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)config);
        try {
            ruleBase.newStatefulSession();
            StatefulSessionTest.fail((String)"cannot have a stateful session with sequential set to true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private StatefulSession getExceptionSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceException.drl")));
        if (builder.hasErrors()) {
            throw new RuntimeException(builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase.newStatefulSession();
    }

    private StatefulSession getSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("list", (Object)this.list);
        return session;
    }
}

