/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.Cheese;
import org.drools.CheeseEqual;
import org.drools.ClassObjectFilter;
import org.drools.CommonTestMethodBase;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.Sensor;
import org.drools.StatefulSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.ObjectHashMap;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.integrationtests.IteratorToList;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TruthMaintenanceTest
extends CommonTestMethodBase {
    protected KnowledgeBase getKnowledgeBase() throws Exception {
        return KnowledgeBaseFactory.newKnowledgeBase();
    }

    protected KnowledgeBase getKnowledgeBase(KnowledgeBaseConfiguration config) throws Exception {
        return KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
    }

    @Test
    public void testLogicalInsertionsDynamicRule() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TruthMaintenanceTest.fail((String)kbuilder.getErrors().toString());
        }
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Cheese c1 = new Cheese("a", 1);
        Cheese c2 = new Cheese("b", 2);
        Cheese c3 = new Cheese("c", 3);
        ksession.insert((Object)c1);
        org.drools.runtime.rule.FactHandle h = ksession.insert((Object)c2);
        ksession.insert((Object)c3);
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ArrayList list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        TruthMaintenanceTest.assertEquals((int)2, (int)list.size());
        TruthMaintenanceTest.assertFalse((boolean)list.contains(new Person(c1.getType())));
        TruthMaintenanceTest.assertTrue((boolean)list.contains(new Person(c2.getType())));
        TruthMaintenanceTest.assertTrue((boolean)list.contains(new Person(c3.getType())));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule2.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TruthMaintenanceTest.fail((String)kbuilder.getErrors().toString());
        }
        Collection kpkgs2 = kbuilder.getKnowledgePackages();
        kbase.addKnowledgePackages(kpkgs2);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        kbase = ksession.getKnowledgeBase();
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        TruthMaintenanceTest.assertEquals((int)3, (int)list.size());
        TruthMaintenanceTest.assertTrue((boolean)list.contains(new Person(c1.getType())));
        TruthMaintenanceTest.assertTrue((boolean)list.contains(new Person(c2.getType())));
        TruthMaintenanceTest.assertTrue((boolean)list.contains(new Person(c3.getType())));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        KnowledgePackage[] pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        TruthMaintenanceTest.assertEquals((String)"org.drools.test", (String)pkgs[0].getName());
        TruthMaintenanceTest.assertEquals((String)"org.drools.test2", (String)pkgs[1].getName());
        TruthMaintenanceTest.assertEquals((String)"rule1", (String)((Rule)pkgs[0].getRules().iterator().next()).getName());
        TruthMaintenanceTest.assertEquals((String)"rule2", (String)((Rule)pkgs[1].getRules().iterator().next()).getName());
        kbase.removeRule(pkgs[0].getName(), ((Rule)pkgs[0].getRules().iterator().next()).getName());
        pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        TruthMaintenanceTest.assertEquals((int)0, (int)pkgs[0].getRules().size());
        TruthMaintenanceTest.assertEquals((int)1, (int)pkgs[1].getRules().size());
        TruthMaintenanceTest.assertEquals((String)"org.drools.test2", (String)pkgs[1].getName());
        TruthMaintenanceTest.assertEquals((String)"rule2", (String)((Rule)pkgs[1].getRules().iterator().next()).getName());
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        TruthMaintenanceTest.assertEquals((String)"removal of the rule should result in retraction of c3's logical assertion", (int)2, (int)list.size());
        TruthMaintenanceTest.assertTrue((String)"c1's logical assertion should not be retracted", (boolean)list.contains(new Person(c1.getType())));
        TruthMaintenanceTest.assertTrue((String)"c2's logical assertion should  not be retracted", (boolean)list.contains(new Person(c2.getType())));
        TruthMaintenanceTest.assertFalse((String)"c3's logical assertion should be  retracted", (boolean)list.contains(new Person(c3.getType())));
        c2.setPrice(3);
        h = this.getFactHandle(h, ksession);
        ksession.update(h, (Object)c2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        TruthMaintenanceTest.assertEquals((String)"c2 now has a higher price, its logical assertion should  be cancelled", (int)1, (int)list.size());
        TruthMaintenanceTest.assertFalse((String)"The logical assertion cor c2 should have been retracted", (boolean)list.contains(new Person(c2.getType())));
        TruthMaintenanceTest.assertTrue((String)"The logical assertion  for c1 should exist", (boolean)list.contains(new Person(c1.getType())));
        pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        kbase.removeRule(pkgs[1].getName(), ((Rule)pkgs[1].getRules().iterator().next()).getName());
        kbase = SerializationHelper.serializeObject(kbase);
        pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        TruthMaintenanceTest.assertEquals((int)0, (int)pkgs[0].getRules().size());
        TruthMaintenanceTest.assertEquals((int)0, (int)pkgs[1].getRules().size());
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        TruthMaintenanceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testLogicalInsertions() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertions.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        org.drools.runtime.rule.FactHandle brieHandle = session.insert((Object)brie);
        Cheese provolone = new Cheese("provolone", 12);
        org.drools.runtime.rule.FactHandle provoloneHandle = session.insert((Object)provolone);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        TruthMaintenanceTest.assertEquals((int)3, (int)list.size());
        TruthMaintenanceTest.assertEquals((int)3, (int)session.getObjects().size());
        brieHandle = this.getFactHandle(brieHandle, session);
        session.retract(brieHandle);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        TruthMaintenanceTest.assertEquals((int)2, (int)session.getObjects().size());
        provoloneHandle = this.getFactHandle(provoloneHandle, session);
        session.retract(provoloneHandle);
        TruthMaintenanceTest.assertEquals((int)0, (int)session.getObjects().size());
    }

    @Test
    public void testLogicalInsertionsBacking() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsBacking.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese cheese1 = new Cheese("c", 1);
        Cheese cheese2 = new Cheese(cheese1.getType(), 1);
        org.drools.runtime.rule.FactHandle h1 = session.insert((Object)cheese1);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        TruthMaintenanceTest.assertEquals((int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((Object)cheese1.getType(), list.iterator().next());
        org.drools.runtime.rule.FactHandle h2 = session.insert((Object)cheese2);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        TruthMaintenanceTest.assertEquals((int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((Object)cheese1.getType(), list.iterator().next());
        TruthMaintenanceTest.assertEquals((int)3, (int)session.getObjects().size());
        h1 = this.getFactHandle(h1, session);
        session.retract(h1);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        TruthMaintenanceTest.assertEquals((String)("cheese-type " + cheese1.getType() + " was retracted, but should not. Backed by cheese2 => type."), (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)("cheese-type " + cheese1.getType() + " was retracted, but should not. Backed by cheese2 => type."), (Object)cheese1.getType(), list.iterator().next());
        h2 = this.getFactHandle(h2, session);
        session.retract(h2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        TruthMaintenanceTest.assertEquals((String)("cheese-type " + cheese1.getType() + " was not retracted, but should have. Neither  cheese1 => type nor cheese2 => type is true."), (int)0, (int)list.size());
    }

    @Test
    public void testLogicalInsertionsSelfreferencing() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsSelfreferencing.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Person b = new Person("b");
        Person a = new Person("a");
        session.setGlobal("b", (Object)b);
        org.drools.runtime.rule.FactHandle h1 = session.insert((Object)a);
        session.fireAllRules();
        Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        TruthMaintenanceTest.assertEquals((int)2, (int)list.size());
        TruthMaintenanceTest.assertTrue((boolean)list.contains(a));
        TruthMaintenanceTest.assertTrue((boolean)list.contains(b));
        session.retract(h1);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        TruthMaintenanceTest.assertEquals((String)"b was retracted, but it should not have. Is backed by b => b being true.", (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"b was retracted, but it should not have. Is backed by b => b being true.", (Object)b, list.iterator().next());
        h1 = session.getFactHandle((Object)b);
        session.retract(h1);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        TruthMaintenanceTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testLogicalInsertionsLoop() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsLoop.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList l = new ArrayList();
        Person a = new Person("a");
        session.setGlobal("a", (Object)a);
        session.setGlobal("l", l);
        session.fireAllRules();
        Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        TruthMaintenanceTest.assertEquals((String)"a still asserted.", (int)0, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"Rule has not fired (looped) expected number of times", (int)10, (int)l.size());
    }

    @Test
    public void testLogicalInsertionsNoLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionsNoLoop.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList l = new ArrayList();
        Person a = new Person("a");
        workingMemory.setGlobal("a", (Object)a);
        workingMemory.setGlobal("l", l);
        workingMemory.fireAllRules();
        List list = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(a.getClass())));
        TruthMaintenanceTest.assertEquals((String)"a still in WM", (int)0, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"Rule should not loop", (int)1, (int)l.size());
    }

    @Test
    public void testLogicalInsertionsWithModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionsWithUpdate.drl")));
        if (builder.hasErrors()) {
            TruthMaintenanceTest.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p = new Person("person");
        p.setAge(2);
        FactHandle h = workingMemory.insert((Object)p);
        TruthMaintenanceTest.assertEquals((int)1, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        TruthMaintenanceTest.assertEquals((int)2, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        List l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)l.size());
        TruthMaintenanceTest.assertEquals((int)2, (int)((CheeseEqual)l.get(0)).getPrice());
        h = this.getFactHandle((org.drools.runtime.rule.FactHandle)h, workingMemory);
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        TruthMaintenanceTest.assertEquals((int)0, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        TruthMaintenanceSystem tms = ((InternalWorkingMemory)workingMemory).getTruthMaintenanceSystem();
        Field field = tms.getClass().getDeclaredField("assertMap");
        field.setAccessible(true);
        ObjectHashMap m = (ObjectHashMap)field.get(tms);
        field.setAccessible(false);
        TruthMaintenanceTest.assertEquals((String)"assertMap should be empty", (int)0, (int)m.size());
    }

    @Test
    public void testLogicalInsertions2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertions2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList events = new ArrayList();
        workingMemory.setGlobal("events", events);
        Sensor sensor = new Sensor(80, 80);
        FactHandle handle = workingMemory.insert((Object)sensor);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        List list = IteratorToList.convert(workingMemory.iterateObjects());
        TruthMaintenanceTest.assertEquals((String)"Only sensor is there", (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"Only one event", (int)1, (int)events.size());
        sensor.setPressure(200);
        sensor.setTemperature(200);
        handle = this.getFactHandle((org.drools.runtime.rule.FactHandle)handle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)sensor);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        TruthMaintenanceTest.assertEquals((String)"Only sensor is there", (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"Exactly seven events", (int)7, (int)events.size());
    }

    @Test
    public void testLogicalInsertionsNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionsNot.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person a = new Person("a");
        Cheese cheese = new Cheese("brie", 1);
        workingMemory.setGlobal("cheese", (Object)cheese);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        List list = IteratorToList.convert(workingMemory.iterateObjects());
        TruthMaintenanceTest.assertEquals((String)"i was not asserted by not a => i.", (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"i was not asserted by not a => i.", (Object)cheese, list.get(0));
        FactHandle h = workingMemory.insert((Object)a);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        list = IteratorToList.convert(workingMemory.iterateObjects());
        TruthMaintenanceTest.assertEquals((String)"a was not asserted or i not retracted.", (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"a was asserted.", (Object)a, list.get(0));
        TruthMaintenanceTest.assertFalse((String)"i was not rectracted.", (boolean)list.contains(cheese));
        TruthMaintenanceTest.assertEquals((String)"agenda should be empty.", (int)0, (int)workingMemory.getAgenda().agendaSize());
        h = this.getFactHandle((org.drools.runtime.rule.FactHandle)h, workingMemory);
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        list = IteratorToList.convert(workingMemory.iterateObjects());
        TruthMaintenanceTest.assertEquals((String)"i was not asserted by not a => i.", (int)1, (int)list.size());
        TruthMaintenanceTest.assertEquals((String)"i was not asserted by not a => i.", (Object)cheese, list.get(0));
    }

    @Test
    public void testLogicalInsertionsNotPingPong() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionsNotPingPong.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        workingMemory.setGlobal("cheese", (Object)cheese);
        workingMemory.setGlobal("person", (Object)person);
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        TruthMaintenanceTest.assertEquals((String)"Rules have not fired (looped) expected number of times", (int)10, (int)list.size());
    }

    @Test
    public void testLogicalInsertionsUpdateEqual() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionsUpdateEqual.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p = new Person("person");
        p.setAge(2);
        FactHandle h = workingMemory.insert((Object)p);
        TruthMaintenanceTest.assertEquals((int)1, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        TruthMaintenanceTest.assertEquals((int)2, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        List l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)l.size());
        TruthMaintenanceTest.assertEquals((int)3, (int)((CheeseEqual)l.get(0)).getPrice());
        h = this.getFactHandle((org.drools.runtime.rule.FactHandle)h, workingMemory);
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        TruthMaintenanceTest.assertEquals((int)0, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        TruthMaintenanceSystem tms = ((InternalWorkingMemory)workingMemory).getTruthMaintenanceSystem();
        Field field = tms.getClass().getDeclaredField("assertMap");
        field.setAccessible(true);
        ObjectHashMap m = (ObjectHashMap)field.get(tms);
        field.setAccessible(false);
        TruthMaintenanceTest.assertEquals((String)"assertMap should be empty", (int)0, (int)m.size());
    }

    @Test
    public void testLogicalInsertionsWithExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionWithExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = workingMemory.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = workingMemory.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        List cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)2, (int)cheeseList.size());
        p3.setStatus("america");
        c3FactHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)c3FactHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)cheeseList.size());
        p2.setStatus("america");
        c2FactHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)c2FactHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)cheeseList.size());
        p1.setStatus("america");
        c1FactHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)c1FactHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)2, (int)cheeseList.size());
        p2.setStatus("europe");
        c2FactHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)c2FactHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)cheeseList.size());
        p1.setStatus("europe");
        c1FactHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)c1FactHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)cheeseList.size());
        p3.setStatus("europe");
        c3FactHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)c3FactHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        TruthMaintenanceTest.assertEquals((int)2, (int)cheeseList.size());
    }

    @Test
    public void testLogicalInsertions3() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_logicalInsertions3.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("events", list);
        Sensor sensor = new Sensor(150, 100);
        FactHandle sensorHandle = workingMemory.insert((Object)sensor);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        TruthMaintenanceTest.assertEquals((int)2, (int)list.size());
        TruthMaintenanceTest.assertEquals((int)2, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        sensor.setTemperature(125);
        sensorHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)sensorHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)sensorHandle, (Object)sensor);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        TruthMaintenanceTest.assertEquals((int)3, (int)list.size());
        TruthMaintenanceTest.assertEquals((int)2, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        sensor.setTemperature(80);
        sensorHandle = this.getFactHandle((org.drools.runtime.rule.FactHandle)sensorHandle, workingMemory);
        workingMemory.update((org.drools.runtime.rule.FactHandle)sensorHandle, (Object)sensor);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        workingMemory.fireAllRules();
        TruthMaintenanceTest.assertEquals((int)3, (int)list.size());
        TruthMaintenanceTest.assertEquals((int)1, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
    }

    @Test
    public void testLogicalInsertionsAccumulatorPattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LogicalInsertionsAccumulatorPattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("ga", (Object)"a");
        workingMemory.setGlobal("gb", (Object)"b");
        workingMemory.setGlobal("gs", (Object)new Short(3));
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        FactHandle h = workingMemory.insert((Object)new Integer(6));
        TruthMaintenanceTest.assertEquals((int)1, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        List l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        TruthMaintenanceTest.assertEquals((String)"There should be 2 CheeseEqual in Working Memory, 1 justified, 1 stated", (int)2, (int)l.size());
        TruthMaintenanceTest.assertEquals((int)6, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        h = this.getFactHandle((org.drools.runtime.rule.FactHandle)h, workingMemory);
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        TruthMaintenanceTest.assertEquals((String)"There should be only 1 CheeseEqual in Working Memory, 1 stated (the justified should have been retracted). Check TruthMaintenanceSystem justifiedMap", (int)1, (int)l.size());
        l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Short.class)));
        TruthMaintenanceTest.assertEquals((int)1, (int)l.size());
        TruthMaintenanceTest.assertEquals((int)2, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        TruthMaintenanceTest.assertEquals((int)0, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
    }

    @Test
    public void testLogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Sensor sensor1 = new Sensor(100, 0);
        org.drools.runtime.rule.FactHandle sensor1Handle = session.insert((Object)sensor1);
        Sensor sensor2 = new Sensor(200, 0);
        org.drools.runtime.rule.FactHandle sensor2Handle = session.insert((Object)sensor2);
        Sensor sensor3 = new Sensor(200, 0);
        org.drools.runtime.rule.FactHandle sensor3Handle = session.insert((Object)sensor3);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        ArrayList temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
        TruthMaintenanceTest.assertTrue((boolean)temperatureList.contains(100));
        TruthMaintenanceTest.assertTrue((boolean)temperatureList.contains(200));
        TruthMaintenanceTest.assertEquals((int)2, (int)temperatureList.size());
        sensor1.setTemperature(150);
        sensor1Handle = this.getFactHandle((org.drools.runtime.rule.FactHandle)((FactHandle)sensor1Handle), session);
        session.update(sensor1Handle, (Object)sensor1);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
        TruthMaintenanceTest.assertFalse((boolean)temperatureList.contains(100));
        TruthMaintenanceTest.assertTrue((boolean)temperatureList.contains(150));
        TruthMaintenanceTest.assertTrue((boolean)temperatureList.contains(200));
        TruthMaintenanceTest.assertEquals((int)2, (int)temperatureList.size());
    }

    @Test
    @Ignore
    public void testLogicalInsertOrder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertOrder.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        WorkingMemoryEventListener wmel = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        session.addEventListener(wmel);
        Person bob = new Person("bob");
        bob.setStatus("hungry");
        Person mark = new Person("mark");
        mark.setStatus("thirsty");
        session.insert((Object)bob);
        session.insert((Object)mark);
        int count = session.fireAllRules();
        TruthMaintenanceTest.assertEquals((int)2, (int)count);
        ArgumentCaptor insertsCaptor = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wmel, (VerificationMode)Mockito.times((int)4))).objectInserted((ObjectInsertedEvent)insertsCaptor.capture());
        List inserts = insertsCaptor.getAllValues();
        Assert.assertThat((Object)((ObjectInsertedEvent)inserts.get(2)).getObject(), (Matcher)CoreMatchers.is((Object)"rule 1"));
        Assert.assertThat((Object)((ObjectInsertedEvent)inserts.get(3)).getObject(), (Matcher)CoreMatchers.is((Object)"rule 2"));
        ArgumentCaptor retractsCaptor = ArgumentCaptor.forClass(ObjectRetractedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wmel, (VerificationMode)Mockito.times((int)2))).objectRetracted((ObjectRetractedEvent)retractsCaptor.capture());
        List retracts = retractsCaptor.getAllValues();
        Assert.assertThat((Object)((ObjectRetractedEvent)retracts.get(0)).getOldObject(), (Matcher)CoreMatchers.is((Object)"rule 1"));
        Assert.assertThat((Object)((ObjectRetractedEvent)retracts.get(1)).getOldObject(), (Matcher)CoreMatchers.is((Object)"rule 2"));
    }

    @Test
    public void testTMSwithQueries() {
        String str = "package org.drools.test;\n\nglobal java.util.List list; \n\ndeclare Bean\n    str : String\nend\n\nquery bean ( String $s )\n    Bean(  $s ; )\nend\n\n\nrule \"init\"\nwhen\nthen\n    insert( new Bean(\"AAA\") );\n    insert( \"x\" );\nend\n\nrule \"LogicIn\"\nwhen\n    String( this == \"x\" )\n    ?bean(  \"AAA\" ; )\nthen\n    insertLogical(\"y\");\n    retract(\"x\");\nend \nrule \"Never\"\nsalience -999\nwhen\n    $s : String( this == \"y\" )\nthen\n    list.add($s);\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession kSession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        TruthMaintenanceTest.assertEquals((int)0, (int)list.size());
    }

    public InternalFactHandle getFactHandle(org.drools.runtime.rule.FactHandle factHandle, StatefulSession session) {
        HashMap<Integer, org.drools.runtime.rule.FactHandle> handles = new HashMap<Integer, org.drools.runtime.rule.FactHandle>();
        for (org.drools.runtime.rule.FactHandle fh : session.getFactHandles()) {
            handles.put(((InternalFactHandle)fh).getId(), fh);
        }
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }

    public InternalFactHandle getFactHandle(org.drools.runtime.rule.FactHandle factHandle, StatefulKnowledgeSession ksession) {
        HashMap<Integer, org.drools.runtime.rule.FactHandle> handles = new HashMap<Integer, org.drools.runtime.rule.FactHandle>();
        for (org.drools.runtime.rule.FactHandle fh : ksession.getFactHandles()) {
            handles.put(((InternalFactHandle)fh).getId(), fh);
        }
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }
}

