/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.io.ResourceFactory;
import org.drools.marshalling.MarshallerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class UnmarshallingTest {
    @Test
    public void testMarshallWithNot() throws Exception {
        String whenBenNotVilgaxRule = "import " + this.getClass().getCanonicalName() + ".*\n" + "rule one\n" + "when\n" + "   Ben()\n" + "   not(Vilgax())\n" + "then\n" + "   //System.out.println(\"Ben!\");\n" + "end\n" + "\n" + "rule two\n" + "when\n" + "   Ben()\n" + "then\n" + "   //System.out.println(\"Vilgax..\");\n" + "end\n";
        KnowledgeBase knowledgeBase = this.initializeKnowledgeBase(whenBenNotVilgaxRule);
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Ben());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).marshall((OutputStream)baos, ksession);
        ksession.dispose();
        knowledgeBase = this.initializeKnowledgeBase(whenBenNotVilgaxRule);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            ksession = MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).unmarshall((InputStream)bais);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)(t.getClass().getSimpleName() + " thrown when trying to unmarshall (see stack trace in output)."));
        }
        int rules = ksession.fireAllRules();
        junit.framework.Assert.assertEquals((int)2, (int)rules);
    }

    private KnowledgeBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        knowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return knowledgeBase;
    }

    public static class Vilgax
    implements Serializable {
        private static final long serialVersionUID = 5337858943537739516L;

        public String toString() {
            return "Vilgax[]";
        }
    }

    public static class Ben
    implements Serializable {
        private static final long serialVersionUID = 9127145048523653863L;

        public String toString() {
            return "Ben[]";
        }
    }
}

