/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.eventgenerator;

import java.io.IOException;
import java.io.InputStreamReader;
import org.drools.CommonTestMethodBase;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsParserException;
import org.drools.integrationtests.eventgenerator.Event;
import org.drools.integrationtests.eventgenerator.PseudoSessionClock;
import org.drools.integrationtests.eventgenerator.SimpleEventGenerator;
import org.drools.integrationtests.eventgenerator.SimpleEventListener;
import org.junit.Test;

public class SimpleEventGeneratorTest
extends CommonTestMethodBase {
    private static final String TEST_RULE_FILE = "test_eventGenerator.drl";

    @Test
    public void testEventGenerationMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), 0L, 10);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)10);
    }

    @Test
    public void testEventGenerationMaxTime() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(1L), 0);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationMaxTimeAndMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(1L), 10);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
        SimpleEventGeneratorTest.assertTrue((wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size() <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testEventGenerationDelayedMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), 0L, 10);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)10);
    }

    @Test
    public void testEventGenerationDelayedMaxTime() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), PseudoSessionClock.timeInMinutes(1L), 0);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)wm.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationDelayedMaxTimeAndMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), PseudoSessionClock.timeInMinutes(1L), 10);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)wm.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size());
        SimpleEventGeneratorTest.assertTrue((wm.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size() <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testEventGenerationGlobalMaxTime() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm), PseudoSessionClock.timeInMinutes(1L));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(3L), 0);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events", new Object[0]).size(), (int)wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationMultipleSources() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, "resA"), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), 0L, 15);
        myGenerator.addEventSource("Conveyor2", new Event(Event.EventType.CUSTOM, "resB"), PseudoSessionClock.timeInSeconds(3L), PseudoSessionClock.timeInSeconds(5L), 0L, 20);
        myGenerator.generate();
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events with parent resource A", new Object[0]).size(), (int)15);
        SimpleEventGeneratorTest.assertEquals((int)wm.getQueryResults("all inserted events with parent resource B", new Object[0]).size(), (int)20);
    }
}

