/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class MarshallingIssuesTest {
    @Test
    public void testJBRULES_1946() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("../Sample.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            Assert.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_2() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("../Sample.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            DroolsObjectInputStream ois = new DroolsObjectInputStream((InputStream)bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            Assert.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_3() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("../Sample.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
            Assert.fail((String)"Should have raised an IllegalArgumentException since the kbase was serialized with a Drools Stream but deserialized with a regular stream");
        }
        catch (IllegalArgumentException ode) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_2331() throws Exception {
        String source = "package test.drl\n";
        source = source + "rule dummy_rule\n";
        source = source + "when\n";
        source = source + "eval( false )\n";
        source = source + "then\n";
        source = source + "end\n";
        StringReader reader = new StringReader(source);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)reader), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assert.assertNotNull((Object)ksession);
        ksession.dispose();
    }
}

