/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.api;

import java.util.Collection;
import java.util.Collections;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.StockTick;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgeDescr;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.type.FactType;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.io.ResourceFactory;
import org.drools.lang.api.AccumulateDescrBuilder;
import org.drools.lang.api.CEDescrBuilder;
import org.drools.lang.api.DescrFactory;
import org.drools.lang.api.FunctionDescrBuilder;
import org.drools.lang.api.PackageDescrBuilder;
import org.drools.lang.api.RuleDescrBuilder;
import org.drools.lang.api.TypeDeclarationDescrBuilder;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class DescrBuilderTest
extends CommonTestMethodBase {
    @Test
    public void testPackage() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").attribute("dialect").value("mvel").end()).getDescr();
        DescrBuilderTest.assertEquals((String)"org.drools", (String)pkg.getName());
        DescrBuilderTest.assertEquals((String)"mvel", (String)pkg.getAttribute("dialect").getValue());
        DescrBuilderTest.assertNull((Object)pkg.getAttribute("salience"));
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
    }

    @Test
    public void testPackageAttributes() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").attribute("dialect").value("mvel").end()).attribute("salience", "10")).attribute("lock-on-active", "true", AttributeDescr.Type.BOOLEAN)).getDescr();
        DescrBuilderTest.assertEquals((String)"org.drools", (String)pkg.getName());
        DescrBuilderTest.assertEquals((int)3, (int)pkg.getAttributes().size());
        DescrBuilderTest.assertEquals((String)"mvel", (String)pkg.getAttribute("dialect").getValue());
        DescrBuilderTest.assertEquals((String)"10", (String)pkg.getAttribute("salience").getValue());
        DescrBuilderTest.assertEquals((String)"true", (String)pkg.getAttribute("lock-on-active").getValue());
        DescrBuilderTest.assertEquals((Object)AttributeDescr.Type.BOOLEAN, (Object)pkg.getAttribute("lock-on-active").getType());
        DescrBuilderTest.assertNull((Object)pkg.getAttribute("no-loop"));
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
    }

    @Test
    public void testPackageImports() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newImport().target("java.util.List").end()).newImport().target("org.drools.examples.*").end()).getDescr();
        DescrBuilderTest.assertEquals((int)2, (int)pkg.getImports().size());
        DescrBuilderTest.assertEquals((String)"java.util.List", (String)((ImportDescr)pkg.getImports().get(0)).getTarget());
        DescrBuilderTest.assertEquals((String)"org.drools.examples.*", (String)((ImportDescr)pkg.getImports().get(1)).getTarget());
    }

    @Test
    public void testGlobals() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newGlobal().type("java.util.List").identifier("list").end()).newGlobal().type("Person").identifier("bob").end()).getDescr();
        DescrBuilderTest.assertEquals((int)2, (int)pkg.getGlobals().size());
        DescrBuilderTest.assertEquals((String)"java.util.List", (String)((GlobalDescr)pkg.getGlobals().get(0)).getType());
        DescrBuilderTest.assertEquals((String)"list", (String)((GlobalDescr)pkg.getGlobals().get(0)).getIdentifier());
        DescrBuilderTest.assertEquals((String)"Person", (String)((GlobalDescr)pkg.getGlobals().get(1)).getType());
        DescrBuilderTest.assertEquals((String)"bob", (String)((GlobalDescr)pkg.getGlobals().get(1)).getIdentifier());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
    }

    @Test
    public void testFunctions() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((PackageDescrBuilder)((FunctionDescrBuilder)((FunctionDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newFunctionImport().target("java.lang.Math.max").end()).newFunction().returnType("long").name("myMax").parameter("long", "v1")).parameter("long", "v2")).body("return max(v1, v2);").end()).newRule().name("test").lhs().eval().constraint("myMax(5, 10) == 10").end()).end()).rhs("// do something").end()).getDescr();
        DescrBuilderTest.assertEquals((int)1, (int)pkg.getFunctionImports().size());
        DescrBuilderTest.assertEquals((int)1, (int)pkg.getFunctions().size());
        DescrBuilderTest.assertEquals((int)1, (int)pkg.getRules().size());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testDeclare() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((TypeDeclarationDescrBuilder)((TypeDeclarationDescrBuilder)((TypeDeclarationDescrBuilder)((TypeDeclarationDescrBuilder)DescrFactory.newPackage().name("org.beans").newDeclare().type().name("StockTick").newAnnotation("role").value("event").end()).newAnnotation("author").value("bob").end()).newField("symbol").type("String").end()).newField("price").type("double").end()).end()).getDescr();
        DescrBuilderTest.assertEquals((int)1, (int)pkg.getTypeDeclarations().size());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.beans", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        FactType stType = kbase.getFactType("org.beans", "StockTick");
        DescrBuilderTest.assertNotNull((Object)stType);
        Object st = stType.newInstance();
        stType.set(st, "symbol", (Object)"RHT");
        stType.set(st, "price", (Object)10);
        DescrBuilderTest.assertEquals((Object)"RHT", (Object)stType.get(st, "symbol"));
    }

    @Test
    public void testDeclareEntryPoint() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newDeclare().entryPoint().entryPointId("ep1").end()).newDeclare().entryPoint().entryPointId("ep3").end()).getDescr();
        DescrBuilderTest.assertEquals((int)2, (int)pkg.getEntryPointDeclarations().size());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        DescrBuilderTest.assertEquals((int)2, (int)kbase.getEntryPointIds().size());
    }

    @Test
    public void testRuleRHSOptional() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("r1").lhs().pattern("StockTick").constraint("company == \"RHT\"").end()).end()).end()).getDescr();
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        int rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testRuleRHSComment() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("r1").lhs().pattern("StockTick").constraint("company == \"RHT\"").end()).end()).rhs("// some comment").end()).getDescr();
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        int rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testTopLevelAccumulate() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((AccumulateDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("r1").lhs().accumulate().source().pattern("StockTick").constraint("company == \"RHT\"").bind("$p", "price", false).end()).end()).function("sum", "$sum", new String[]{"$p"}).function("count", "$cnt", new String[]{"$p"}).end()).end()).rhs("// some comment").end()).getDescr();
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        ksession.insert((Object)new StockTick(2L, "RHT", 100.0, 10L));
        int rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)1, (int)rules);
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)cap.capture());
        Assert.assertThat((Object)((Number)((AfterActivationFiredEvent)cap.getValue()).getActivation().getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)180));
        Assert.assertThat((Object)((Number)((AfterActivationFiredEvent)cap.getValue()).getActivation().getDeclarationValue("$cnt")).intValue(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testRule() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("r1").lhs().and().or().pattern("StockTick").constraint("price > 100").end()).pattern("StockTick").constraint("price < 10").end()).end()).pattern("StockTick").constraint("company == \"RHT\"").end()).end()).end()).rhs("    System.out.println(\"foo\");\n").end()).getDescr();
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        int rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)0, (int)rules);
        ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new StockTick(2L, "RHT", 150.0, 1L));
        rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)1, (int)rules);
    }

    @Test
    public void testFromEntryPoint() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("from rule").lhs().pattern("String").id("s", false).from().entryPoint("EventStream").end()).end()).rhs("//System.out.println(s);").end()).getDescr();
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        DescrBuilderTest.assertEquals((String)"org.drools", (String)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint("EventStream");
        ep.insert((Object)"Hello World!");
        int rules = ksession.fireAllRules();
        DescrBuilderTest.assertEquals((int)1, (int)rules);
    }

    private KnowledgePackage compilePkgDescr(PackageDescr pkg) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newDescrResource((KnowledgeDescr)pkg), ResourceType.DESCR);
        DescrBuilderTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        Collection kpkgs = kbuilder.getKnowledgePackages();
        DescrBuilderTest.assertEquals((int)1, (int)kpkgs.size());
        return (KnowledgePackage)kpkgs.iterator().next();
    }
}

