/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class AsmGeneratorTest
extends CommonTestMethodBase {
    @Test
    public void testPatterDeclarations() {
        String s = "package org.drools.test\nglobal java.util.List list\nrule r1 when\n    s1 : String( this == 's1' )\n    s2 : String( this == 's2' )\n    s3 : String( this == 's3' )\n    s4 : String( this == 's4' )\n    s5 : String( this == 's5' )\nthen\n    // s5 is missed out on purpose to make sure we only resolved required declarations\n   list.add( s1 + s2 + s3 + s5 ); \nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])s.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            AsmGeneratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"s1");
        ksession.insert((Object)"s2");
        ksession.insert((Object)"s3");
        ksession.insert((Object)"s4");
        ksession.insert((Object)"s5");
        ksession.fireAllRules();
        AsmGeneratorTest.assertEquals((int)1, (int)list.size());
        AsmGeneratorTest.assertEquals((Object)"s1s2s3s5", list.get(0));
    }

    @Test
    public void testAllGeneratedConstructs() {
        String s = "package org.drools.test\nimport org.drools.Person\nglobal java.util.List list\nrule r1 when\n    s1 : String( this == 's1' )\n    p1 : Person( $name1 : name, name == s1 )\n    eval( p1.getName().equals( s1 ) ) \n    s2 : String( this == 's2' )\n    p2 : Person( $name2 : name, name == s2, eval( p2.getName().equals( s2 ) &&                                                   ! $name2.equals( $name1 )  ) )\n    s3 : String( this == 's3' )\n    not String( this == 's5')\n     p3 : Person( $name3 : name, name == s3, name == ( new String( $name1.charAt(0) + \"3\" ) ) )\nthen\n    // *2 are missed out on purpose to make sure we only resolved required declarations\n    list.add( s1 + p1 + $name1 + s3 + p3 + $name3 ); \nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])s.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            AsmGeneratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"s1");
        ksession.insert((Object)new Person("s1"));
        ksession.insert((Object)"s2");
        ksession.insert((Object)new Person("s2"));
        ksession.insert((Object)"s3");
        ksession.insert((Object)new Person("s3"));
        ksession.fireAllRules();
        AsmGeneratorTest.assertEquals((int)1, (int)list.size());
        AsmGeneratorTest.assertEquals((Object)"s1[Person name='s1 age='0' likes='']s1s3[Person name='s3 age='0' likes='']s3", list.get(0));
    }

    @Test
    public void testOr() {
        String s = "package org.drools.test\nimport org.drools.Person\nimport org.drools.Cheese\nglobal java.util.List list\nrule r1 when\n    s1 : String( this == 's1' )\n    Cheese( $type : type == \"stilton\", $price : price ) or\n    ( Cheese( $type : type == \"brie\", $price : price ) and Person( name == \"bob\", likes == $type ) )\nthen\n    // *2 are missed out on purpose to make sure we only resolved required declarations\n    list.add( \"test3\"+$type +\":\"+ new Integer( $price ) ); \nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])s.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            AsmGeneratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"s1");
        ksession.insert((Object)new Person("bob", "brie"));
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)new Cheese("brie"));
        ksession.insert((Object)new Person("s2"));
        ksession.fireAllRules();
        AsmGeneratorTest.assertEquals((int)2, (int)list.size());
        AsmGeneratorTest.assertTrue((boolean)list.contains("test3brie:0"));
        AsmGeneratorTest.assertTrue((boolean)list.contains("test3stilton:0"));
    }
}

