/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.debug;

import java.awt.Dimension;
import java.io.InputStream;
import java.util.ArrayList;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.Worker;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.core.util.debug.SessionInspector;
import org.drools.core.util.debug.SessionReporter;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.Test;

public class SessionInspectorTest
extends CommonTestMethodBase {
    @Test
    public void testGetSessionInfo() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_SubNetworks.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_AccumulateWithFromChaining.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_CollectResultsBetaConstraint.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_QueryMemoryLeak.drl"), ResourceType.DRL);
        SessionInspectorTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("results", new ArrayList());
        ksession.insert((Object)new Dimension(100, 50));
        ksession.insert((Object)new Dimension(130, 80));
        ksession.insert((Object)new Dimension(50, 40));
        ksession.insert((Object)new Dimension(50, 40));
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        ksession.insert((Object)cheesery);
        ksession.insert((Object)new Person("Bob", "muzzarella"));
        ksession.insert((Object)new Person("Mark", "brie"));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Double(10.0));
        ksession.insert((Object)new Double(11.0));
        ksession.insert((Object)new Double(12.0));
        ksession.insert((Object)new Double(13.0));
        ksession.insert((Object)new Double(14.0));
        ksession.insert((Object)new Integer(15));
        ksession.insert((Object)new Integer(16));
        ksession.insert((Object)new Integer(17));
        ksession.insert((Object)new Integer(18));
        FactHandle handle = ksession.insert((Object)new Worker());
        ksession.retract(handle);
        SessionInspector inspector = new SessionInspector(ksession);
        StatefulKnowledgeSessionInfo info = inspector.getSessionInfo();
        String report = SessionReporter.generateReport((String)"simple", (StatefulKnowledgeSessionInfo)info, null);
        SessionInspectorTest.assertNotNull((Object)report);
    }

    @Test
    public void testGetSessionInfoWithCustomTemplate() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_SubNetworks.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_AccumulateWithFromChaining.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_CollectResultsBetaConstraint.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_QueryMemoryLeak.drl"), ResourceType.DRL);
        SessionInspectorTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("results", new ArrayList());
        ksession.insert((Object)new Dimension(100, 50));
        ksession.insert((Object)new Dimension(130, 80));
        ksession.insert((Object)new Dimension(50, 40));
        ksession.insert((Object)new Dimension(50, 40));
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        ksession.insert((Object)cheesery);
        ksession.insert((Object)new Person("Bob", "muzzarella"));
        ksession.insert((Object)new Person("Mark", "brie"));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Double(10.0));
        ksession.insert((Object)new Double(11.0));
        ksession.insert((Object)new Double(12.0));
        ksession.insert((Object)new Double(13.0));
        ksession.insert((Object)new Double(14.0));
        ksession.insert((Object)new Integer(15));
        ksession.insert((Object)new Integer(16));
        ksession.insert((Object)new Integer(17));
        ksession.insert((Object)new Integer(18));
        FactHandle handle = ksession.insert((Object)new Worker());
        ksession.retract(handle);
        SessionInspector inspector = new SessionInspector(ksession);
        StatefulKnowledgeSessionInfo info = inspector.getSessionInfo();
        SessionReporter.addNamedTemplate((String)"topten", (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("customreports.mvel"));
        String report = SessionReporter.generateReport((String)"topten", (StatefulKnowledgeSessionInfo)info, null);
        SessionInspectorTest.assertNotNull((Object)report);
    }
}

