/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commons.jci.readers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.core.util.StringUtils;

public class DiskResourceReader
implements ResourceReader {
    private final File root;

    public DiskResourceReader(File pRoot) {
        this.root = pRoot;
    }

    @Override
    public boolean isAvailable(String pResourceName) {
        return new File(this.root, pResourceName).exists();
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        try {
            return StringUtils.readFileAsString((Reader)new InputStreamReader((InputStream)new FileInputStream(new File(this.root, pResourceName)), "UTF-8")).getBytes();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Collection<String> getFileNames() {
        ArrayList<String> list = new ArrayList<String>();
        this.list(this.root, list);
        return list;
    }

    public String[] list() {
        ArrayList files = new ArrayList();
        this.list(this.root, files);
        return files.toArray(new String[files.size()]);
    }

    private void list(File pFile, List pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(pFile.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1));
        }
    }
}

