/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.util.ClassUtils;
import org.drools.kproject.models.KieBaseModelImpl;
import org.kie.builder.GAV;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieRepository;
import org.kie.builder.KieSessionModel;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieProject;
import org.kie.builder.impl.Messages;
import org.kie.util.ClassLoaderUtil;
import org.kie.util.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleKieProject
implements KieProject {
    private static final Logger log = LoggerFactory.getLogger(KieModuleKieProject.class);
    private Map<GAV, InternalKieModule> kieModules;
    private final Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private final Map<String, KieBaseModel> kBaseModels = new HashMap<String, KieBaseModel>();
    private final Map<String, KieSessionModel> kSessionModels = new HashMap<String, KieSessionModel>();
    private InternalKieModule kieModule;
    private KieRepository kr;
    private CompositeClassLoader cl;

    public KieModuleKieProject(InternalKieModule kieModule, KieRepository kr) {
        this.kieModule = kieModule;
        this.kr = kr;
        this.cl = ClassLoaderUtil.getClassLoader(null, null, (boolean)true);
    }

    @Override
    public void init() {
        if (this.kieModules == null) {
            this.kieModules = new HashMap<GAV, InternalKieModule>();
            this.kieModules.putAll(this.kieModule.getDependencies());
            this.kieModules.put(this.kieModule.getGAV(), this.kieModule);
            AbstractKieModule.indexParts(this.kieModules, this.kBaseModels, this.kSessionModels, this.kJarFromKBaseName);
            this.initClassLaoder();
        }
    }

    public void verify(Messages messages) {
        for (KieBaseModel model : this.kBaseModels.values()) {
            AbstractKieModule.createKieBase((KieBaseModelImpl)model, this, messages);
        }
    }

    public void initClassLaoder() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (InternalKieModule kModule : this.kieModules.values()) {
            for (String fileName : kModule.getFileNames()) {
                if (!fileName.endsWith(".class")) continue;
                classes.put(fileName, kModule.getBytes(fileName));
            }
        }
        if (!classes.isEmpty()) {
            this.cl.addClassLoaderToEnd((ClassLoader)new ClassUtils.MapClassLoader(classes, (ClassLoader)this.cl));
        }
    }

    @Override
    public GAV getGAV() {
        return this.kieModule.getGAV();
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    public boolean kieBaseExists(String kBaseName) {
        return this.kBaseModels.containsKey(kBaseName);
    }

    public boolean kieSessionExists(String kSessionName) {
        return this.kSessionModels.containsKey(kSessionName);
    }

    @Override
    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kBaseModels.get(kBaseName);
    }

    @Override
    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kSessionModels.get(kSessionName);
    }

    @Override
    public CompositeClassLoader getClassLoader() {
        return this.cl;
    }
}

