/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import org.drools.kproject.models.KieSessionModelImpl;
import org.kie.KieBase;
import org.kie.KieServices;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieSessionModel;
import org.kie.builder.ReleaseId;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieContainerImpl;
import org.kie.builder.impl.KieProject;
import org.kie.cdi.KBase;
import org.kie.cdi.KReleaseId;
import org.kie.cdi.KSession;
import org.kie.runtime.KieContainer;
import org.kie.runtime.KieSession;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.StatelessKieSession;
import org.kie.runtime.StatelessKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieCDIExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(KieCDIExtension.class);
    private Map<KieCDIEntry, KieCDIEntry> kBaseNames;
    private Map<KieCDIEntry, KieCDIEntry> kSessionNames;
    private Map<ReleaseId, KieContainer> gavs;
    private Map<String, KieCDIEntry> named;
    private KieContainerImpl classpathKContainer;
    private static final AnnotationLiteral<Default> defaultAnnLit = new AnnotationLiteral<Default>(){};
    private static final AnnotationLiteral<Any> anyAnnLit = new AnnotationLiteral<Any>(){};

    public void init() {
        KieServices ks = KieServices.Factory.get();
        this.gavs = new HashMap<ReleaseId, KieContainer>();
        this.classpathKContainer = (KieContainerImpl)ks.getKieClasspathContainer();
        this.named = new HashMap<String, KieCDIEntry>();
    }

    public <Object> void processInjectionTarget(@Observes ProcessInjectionTarget<Object> pit, BeanManager beanManager) {
        if (this.classpathKContainer == null) {
            this.init();
        }
        KieServices ks = KieServices.Factory.get();
        if (!pit.getInjectionTarget().getInjectionPoints().isEmpty()) {
            for (InjectionPoint ip : pit.getInjectionTarget().getInjectionPoints()) {
                KBase kBase = (KBase)ip.getAnnotated().getAnnotation(KBase.class);
                KSession kSession = (KSession)ip.getAnnotated().getAnnotation(KSession.class);
                if (kBase == null && kSession == null) continue;
                KReleaseId KReleaseId2 = (KReleaseId)ip.getAnnotated().getAnnotation(KReleaseId.class);
                ReleaseId releaseId = null;
                if (KReleaseId2 != null) {
                    releaseId = ks.newReleaseId(KReleaseId2.groupId(), KReleaseId2.artifactId(), KReleaseId2.version());
                    this.gavs.put(releaseId, null);
                }
                Named namedAnn = (Named)ip.getAnnotated().getAnnotation(Named.class);
                String namedStr = null;
                if (namedAnn != null) {
                    namedStr = namedAnn.value();
                }
                Class<ApplicationScoped> scope = ApplicationScoped.class;
                if (kBase != null) {
                    this.addKBaseInjectionPoint(ip, kBase, namedStr, scope, releaseId);
                    continue;
                }
                if (kSession == null) continue;
                this.addKSessionInjectionPoint(ip, kSession, namedStr, scope, releaseId);
            }
        }
    }

    public void addKBaseInjectionPoint(InjectionPoint ip, KBase kBase, String namedStr, Class<? extends Annotation> scope, ReleaseId releaseId) {
        KieCDIEntry newEntry;
        KieCDIEntry existingEntry;
        if (this.kBaseNames == null) {
            this.kBaseNames = new HashMap<KieCDIEntry, KieCDIEntry>();
        }
        if ((existingEntry = this.kBaseNames.remove(newEntry = new KieCDIEntry(kBase.value(), scope, releaseId, namedStr))) != null) {
            existingEntry.addInjectionPoint(ip);
            this.kBaseNames.put(existingEntry, existingEntry);
        }
        if (namedStr != null) {
            existingEntry = this.named.get(namedStr);
            if (existingEntry == null) {
                this.named.put(namedStr, newEntry);
                this.kBaseNames.put(newEntry, newEntry);
            } else {
                log.error("@Named({}) declaration used ambiguiously existing: {} new: {}", (Object[])new String[]{namedStr, existingEntry.toString(), newEntry.toString()});
            }
        } else {
            this.kBaseNames.put(newEntry, newEntry);
        }
    }

    public void addKSessionInjectionPoint(InjectionPoint ip, KSession kSession, String namedStr, Class<? extends Annotation> scope, ReleaseId releaseId) {
        KieCDIEntry newEntry;
        KieCDIEntry existingEntry;
        if (this.kSessionNames == null) {
            this.kSessionNames = new HashMap<KieCDIEntry, KieCDIEntry>();
        }
        if ((existingEntry = this.kSessionNames.remove(newEntry = new KieCDIEntry(kSession.value(), scope, releaseId, namedStr))) != null) {
            existingEntry.addInjectionPoint(ip);
            this.kSessionNames.put(existingEntry, existingEntry);
        }
        if (namedStr != null) {
            existingEntry = this.named.get(namedStr);
            if (existingEntry == null) {
                this.named.put(namedStr, newEntry);
                this.kSessionNames.put(newEntry, newEntry);
            } else {
                log.error("@Named({}) declaration used ambiguiously existing: {} new: {}", (Object[])new String[]{namedStr, existingEntry.toString(), newEntry.toString()});
            }
        } else {
            this.kSessionNames.put(newEntry, newEntry);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.classpathKContainer != null) {
            KieServices ks = KieServices.Factory.get();
            if (!this.gavs.isEmpty()) {
                for (ReleaseId releaseId : this.gavs.keySet().toArray(new ReleaseId[this.gavs.size()])) {
                    KieContainer kContainer = ks.newKieContainer(releaseId);
                    if (kContainer == null) {
                        log.error("Unable to retrieve KieContainer for ReleaseId {}", (Object)releaseId.toString());
                    } else {
                        log.debug("KieContainer retrieved for ReleaseId {}", (Object)releaseId.toString());
                    }
                    this.gavs.put(releaseId, kContainer);
                }
            }
            if (this.kBaseNames != null) {
                for (KieCDIEntry entry : this.kBaseNames.keySet()) {
                    this.addKBaseBean(abd, entry);
                }
            }
            this.kBaseNames = null;
            if (this.kSessionNames != null) {
                for (KieCDIEntry entry : this.kSessionNames.keySet()) {
                    this.addKSessionBean(abd, entry);
                }
            }
            this.kSessionNames = null;
        }
    }

    public void addKBaseBean(AfterBeanDiscovery abd, KieCDIEntry entry) {
        String kBaseQName;
        ReleaseId releaseId = entry.getkGAV();
        KieContainerImpl kieContainer = this.classpathKContainer;
        if (releaseId != null && (kieContainer = (KieContainerImpl)this.gavs.get(releaseId)) == null) {
            log.error("Unable to create KBase({}), could not retrieve KieContainer for ReleaseId {}", (Object)entry.getKieTypeName(), (Object)releaseId.toString());
            return;
        }
        KieProject kProject = kieContainer.getKieProject();
        KieBaseModel kBaseModel = kProject.getKieBaseModel(kBaseQName = entry.getKieTypeName());
        if (kBaseModel == null) {
            log.error("Annotation @KBase({}) found, but no KieBaseModel exist.\nEither the required kproject.xml does not exist, was corrupted, or mising the KieBase entry", (Object)kBaseQName);
            return;
        }
        if (!kBaseModel.getScope().trim().equals(entry.getScope().getClass().getName())) {
            try {
                if (kBaseModel.getScope().indexOf(46) >= 0) {
                    entry.setScope(Class.forName(kBaseModel.getScope()));
                } else {
                    entry.setScope(Class.forName("javax.enterprise.context." + kBaseModel.getScope()));
                }
            }
            catch (ClassNotFoundException e) {
                log.error("KieBaseModule {} overrides default annotation, but it was not able to find it {}\n{}", (Object[])new String[]{kBaseQName, kBaseModel.getScope(), e.getMessage()});
            }
        }
        KBaseBean bean = new KBaseBean(kBaseModel, kieContainer, entry.getScope(), entry.getNamed(), entry.getInjectionPoints());
        if (log.isDebugEnabled()) {
            InternalKieModule kModule = kProject.getKieModuleForKBase(kBaseQName);
            log.debug("Added Bean for @KBase({})", (Object)kBaseQName, (Object)kModule);
        }
        abd.addBean((Bean)bean);
    }

    public void addKSessionBean(AfterBeanDiscovery abd, KieCDIEntry entry) {
        String kSessionName;
        ReleaseId releaseId = entry.getkGAV();
        KieContainerImpl kieContainer = this.classpathKContainer;
        if (releaseId != null && (kieContainer = (KieContainerImpl)this.gavs.get(releaseId)) == null) {
            log.error("Unable to create KSession({}), could not retrieve KieContainer for ReleaseId {}", (Object)entry.getKieTypeName(), (Object)releaseId.toString());
            return;
        }
        KieProject kProject = kieContainer.getKieProject();
        KieSessionModel kSessionModel = kProject.getKieSessionModel(kSessionName = entry.getKieTypeName());
        if (kSessionModel == null) {
            log.error("Annotation @KSession({}) found, but no KieSessioneModel exist.\nEither the required kproject.xml does not exist, was corrupted, or mising the KieBase entry", (Object)kSessionName);
            return;
        }
        if (!kSessionModel.getScope().trim().equals(entry.getScope().getClass().getName())) {
            try {
                if (kSessionModel.getScope().indexOf(46) >= 0) {
                    entry.setScope(Class.forName(kSessionModel.getScope()));
                } else {
                    entry.setScope(Class.forName("javax.enterprise.context." + kSessionModel.getScope()));
                }
            }
            catch (ClassNotFoundException e) {
                log.error("KieBaseModule {} overrides default annotation, but it was not able to find it {}\n{}", (Object[])new String[]{kSessionName, kSessionModel.getScope(), e.getMessage()});
            }
        }
        if (KieSessionModel.KieSessionType.STATELESS.equals((Object)kSessionModel.getType())) {
            if (log.isDebugEnabled()) {
                InternalKieModule kModule = kProject.getKieModuleForKBase(((KieSessionModelImpl)kSessionModel).getKieBaseModel().getName());
                log.debug("Added Bean for Stateless @KSession({}) from: {}", (Object)kSessionName, (Object)kModule);
            }
            abd.addBean((Bean)new StatelessKSessionBean(kSessionModel, kieContainer, entry.getScope(), entry.getNamed(), entry.getInjectionPoints()));
        } else {
            InternalKieModule kModule = kProject.getKieModuleForKBase(((KieSessionModelImpl)kSessionModel).getKieBaseModel().getName());
            log.debug("Added Bean for Stateful @KSession({})  from: {}", (Object)kSessionName, (Object)kModule);
            abd.addBean((Bean)new StatefulKSessionBean(kSessionModel, kieContainer, entry.getScope(), entry.getNamed(), entry.getInjectionPoints()));
        }
    }

    public static class KieCDIEntry {
        private String kieTypeName;
        private Class<? extends Annotation> scope;
        private ReleaseId kReleaseId;
        private String named;
        private Set<InjectionPoint> injectionPoints;

        public KieCDIEntry(String kieTypeName, Class<? extends Annotation> scope, ReleaseId releaseId, String named) {
            this.kieTypeName = kieTypeName;
            this.scope = scope;
            this.kReleaseId = releaseId;
            this.named = named;
            this.injectionPoints = new HashSet<InjectionPoint>();
        }

        public KieCDIEntry(String kieTypeName) {
            this.kieTypeName = kieTypeName;
        }

        public String getKieTypeName() {
            return this.kieTypeName;
        }

        public void setKieTypeName(String kieTypeName) {
            this.kieTypeName = kieTypeName;
        }

        public String getNamed() {
            return this.named;
        }

        public void setNamed(String named) {
            this.named = named;
        }

        public void setScope(Class<? extends Annotation> scope) {
            this.scope = scope;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public ReleaseId getkGAV() {
            return this.kReleaseId;
        }

        public void setkGAV(ReleaseId kReleaseId) {
            this.kReleaseId = kReleaseId;
        }

        public void addInjectionPoint(InjectionPoint ip) {
            this.injectionPoints.add(ip);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public void setInjectionPoints(Set<InjectionPoint> injectionPoints) {
            this.injectionPoints = injectionPoints;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kReleaseId == null ? 0 : this.kReleaseId.hashCode());
            result = 31 * result + (this.kieTypeName == null ? 0 : this.kieTypeName.hashCode());
            result = 31 * result + (this.named == null ? 0 : this.named.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KieCDIEntry other = (KieCDIEntry)obj;
            if (this.kReleaseId == null ? other.kReleaseId != null : !this.kReleaseId.equals(other.kReleaseId)) {
                return false;
            }
            if (this.kieTypeName == null ? other.kieTypeName != null : !this.kieTypeName.equals(other.kieTypeName)) {
                return false;
            }
            if (this.named == null ? other.named != null : !this.named.equals(other.named)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }

        public String toString() {
            return "KieCDIEntry [kieTypeName=" + this.kieTypeName + ", scope=" + this.scope + ", kReleaseId=" + this.kReleaseId + ", named=" + this.named + "]";
        }
    }

    public static class StatefulKSessionBean
    implements Bean<KieSession> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieSession.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private final KieSessionModel kSessionModel;
        private final KieContainer kContainer;
        private final Class<? extends Annotation> scope;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public StatefulKSessionBean(KieSessionModel kieSessionModelModel, KieContainer kContainer, Class<? extends Annotation> scope, final String named, Set<InjectionPoint> injectionPoints) {
            this.kSessionModel = kieSessionModelModel;
            this.kContainer = kContainer;
            this.scope = scope;
            this.named = named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            set.add(defaultAnnLit);
            set.add(anyAnnLit);
            set.add(new KSession(){

                public Class<? extends Annotation> annotationType() {
                    return KSession.class;
                }

                public String value() {
                    return StatefulKSessionBean.this.kSessionModel.getName();
                }
            });
            if (named != null) {
                set.add(new Named(){

                    public Class<? extends Annotation> annotationType() {
                        return Named.class;
                    }

                    public String value() {
                        return named;
                    }

                    public String toString() {
                        return "Named[" + named + "]";
                    }
                });
            }
            if (kContainer.getReleaseId() != null) {
                final String groupId = kContainer.getReleaseId().getGroupId();
                final String artifactId = kContainer.getReleaseId().getArtifactId();
                final String version = kContainer.getReleaseId().getVersion();
                set.add(new KReleaseId(){

                    public Class<? extends Annotation> annotationType() {
                        return KReleaseId.class;
                    }

                    public String groupId() {
                        return groupId;
                    }

                    public String artifactId() {
                        return artifactId;
                    }

                    public String version() {
                        return version;
                    }

                    public String toString() {
                        return "KReleaseId[groupId=" + groupId + " artifactId" + artifactId + " version=" + version + "]";
                    }
                });
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public KieSession create(CreationalContext ctx) {
            return this.kContainer.newKieSession(this.kSessionModel.getName());
        }

        public void destroy(KieSession kBase, CreationalContext ctx) {
            ctx.release();
        }

        public Class getBeanClass() {
            return StatefulKnowledgeSession.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }

    public static class StatelessKSessionBean
    implements Bean<StatelessKieSession> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(StatelessKieSession.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private final KieSessionModel kSessionModel;
        private final KieContainer kContainer;
        private final Class<? extends Annotation> scope;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public StatelessKSessionBean(KieSessionModel kieSessionModelModel, KieContainer kContainer, Class<? extends Annotation> scope, final String named, Set<InjectionPoint> injectionPoints) {
            this.kSessionModel = kieSessionModelModel;
            this.kContainer = kContainer;
            this.scope = scope;
            this.named = named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            set.add(defaultAnnLit);
            set.add(anyAnnLit);
            set.add(new KSession(){

                public Class<? extends Annotation> annotationType() {
                    return KSession.class;
                }

                public String value() {
                    return StatelessKSessionBean.this.kSessionModel.getName();
                }
            });
            if (named != null) {
                set.add(new Named(){

                    public Class<? extends Annotation> annotationType() {
                        return Named.class;
                    }

                    public String value() {
                        return named;
                    }

                    public String toString() {
                        return "Named[" + named + "]";
                    }
                });
            }
            if (kContainer.getReleaseId() != null) {
                final String groupId = kContainer.getReleaseId().getGroupId();
                final String artifactId = kContainer.getReleaseId().getArtifactId();
                final String version = kContainer.getReleaseId().getVersion();
                set.add(new KReleaseId(){

                    public Class<? extends Annotation> annotationType() {
                        return KReleaseId.class;
                    }

                    public String groupId() {
                        return groupId;
                    }

                    public String artifactId() {
                        return artifactId;
                    }

                    public String version() {
                        return version;
                    }

                    public String toString() {
                        return "KReleaseId[groupId=" + groupId + " artifactId" + artifactId + " version=" + version + "]";
                    }
                });
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public StatelessKieSession create(CreationalContext ctx) {
            return this.kContainer.newStatelessKieSession(this.kSessionModel.getName());
        }

        public void destroy(StatelessKieSession kSession, CreationalContext ctx) {
            ctx.release();
        }

        public Class getBeanClass() {
            return StatelessKnowledgeSession.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }
    }

    public static class KBaseBean
    implements Bean<KieBase> {
        static final Set<Type> types = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(KieBase.class, Object.class)));
        private final Set<Annotation> qualifiers;
        private KieContainer kContainer;
        private final KieBaseModel kBaseModel;
        private final Class<? extends Annotation> scope;
        private final String named;
        private final Set<InjectionPoint> injectionPoints;

        public KBaseBean(final KieBaseModel kBaseModel, KieContainer kContainer, Class<? extends Annotation> scope, final String named, Set<InjectionPoint> injectionPoints) {
            this.kBaseModel = kBaseModel;
            this.kContainer = kContainer;
            this.scope = scope;
            this.named = named;
            this.injectionPoints = injectionPoints;
            HashSet<Object> set = new HashSet<Object>();
            set.add(defaultAnnLit);
            set.add(anyAnnLit);
            set.add(new KBase(){

                public Class<? extends Annotation> annotationType() {
                    return KBase.class;
                }

                public String value() {
                    return kBaseModel.getName();
                }
            });
            if (named != null) {
                set.add(new Named(){

                    public Class<? extends Annotation> annotationType() {
                        return Named.class;
                    }

                    public String value() {
                        return named;
                    }

                    public String toString() {
                        return "Named[" + named + "]";
                    }
                });
            }
            if (kContainer.getReleaseId() != null) {
                final String groupId = kContainer.getReleaseId().getGroupId();
                final String artifactId = kContainer.getReleaseId().getArtifactId();
                final String version = kContainer.getReleaseId().getVersion();
                set.add(new KReleaseId(){

                    public Class<? extends Annotation> annotationType() {
                        return KReleaseId.class;
                    }

                    public String groupId() {
                        return groupId;
                    }

                    public String artifactId() {
                        return artifactId;
                    }

                    public String version() {
                        return version;
                    }

                    public String toString() {
                        return "KReleaseId[groupId=" + groupId + " artifactId" + artifactId + " version=" + version + "]";
                    }
                });
            }
            this.qualifiers = Collections.unmodifiableSet(set);
        }

        public KieBase create(CreationalContext ctx) {
            return this.kContainer.getKieBase(this.kBaseModel.getName());
        }

        public void destroy(KieBase kBase, CreationalContext ctx) {
            this.kContainer = null;
            ctx.release();
        }

        public Class getBeanClass() {
            return KieBase.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String getName() {
            return this.named;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }

        public String toString() {
            return "KBaseBean [kBase=" + this.kBaseModel.getName() + ", qualifiers=" + this.qualifiers + "]";
        }
    }
}

