/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject.models;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.kproject.models.KieBaseModelImpl;
import org.drools.kproject.models.ListenerModelImpl;
import org.drools.kproject.models.WorkItemHandlerModelImpl;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieSessionModel;
import org.kie.builder.ListenerModel;
import org.kie.builder.WorkItemHandlerModel;
import org.kie.runtime.conf.ClockTypeOption;

public class KieSessionModelImpl
implements KieSessionModel {
    private String name;
    private KieSessionModel.KieSessionType type = KieSessionModel.KieSessionType.STATEFUL;
    private ClockTypeOption clockType = ClockTypeOption.get((String)"realtime");
    private String scope = "javax.enterprise.context.ApplicationScoped";
    private KieBaseModelImpl kBase;
    private final List<ListenerModel> listeners = new ArrayList<ListenerModel>();
    private final List<WorkItemHandlerModel> wihs = new ArrayList<WorkItemHandlerModel>();
    private boolean isDefault = false;

    private KieSessionModelImpl() {
    }

    public KieSessionModelImpl(KieBaseModelImpl kBase, String name) {
        this.kBase = kBase;
        this.name = name;
    }

    public KieBaseModelImpl getKieBaseModel() {
        return this.kBase;
    }

    public void setKBase(KieBaseModel kieBaseModel) {
        this.kBase = (KieBaseModelImpl)kieBaseModel;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public KieSessionModel setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KieSessionModel setName(String name) {
        this.name = name;
        return this;
    }

    public KieSessionModel.KieSessionType getType() {
        return this.type;
    }

    public KieSessionModel setType(KieSessionModel.KieSessionType type) {
        this.type = type;
        return this;
    }

    public ClockTypeOption getClockType() {
        return this.clockType;
    }

    public KieSessionModel setClockType(ClockTypeOption clockType) {
        this.clockType = clockType;
        return this;
    }

    public KieSessionModel setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public ListenerModel newListenerModel(String type, ListenerModel.Kind kind) {
        ListenerModelImpl listenerModel = new ListenerModelImpl(this, type, kind);
        this.listeners.add(listenerModel);
        return listenerModel;
    }

    public List<ListenerModel> getListenerModels() {
        return this.listeners;
    }

    private List<ListenerModel> getListenerModels(ListenerModel.Kind kind) {
        ArrayList<ListenerModel> listeners = new ArrayList<ListenerModel>();
        for (ListenerModel listener : this.getListenerModels()) {
            if (listener.getKind() != kind) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    private void addListenerModel(ListenerModel listener) {
        this.listeners.add(listener);
    }

    public WorkItemHandlerModel newWorkItemHandelerModel(String type) {
        WorkItemHandlerModelImpl wihModel = new WorkItemHandlerModelImpl(this, type);
        this.wihs.add(wihModel);
        return wihModel;
    }

    public List<WorkItemHandlerModel> getWorkItemHandelerModels() {
        return this.wihs;
    }

    private void addWorkItemHandelerModel(WorkItemHandlerModel wih) {
        this.wihs.add(wih);
    }

    public String toString() {
        return "KieSessionModel [name=" + this.name + ", clockType=" + this.clockType + "]";
    }

    public static class KSessionConverter
    extends AbstractXStreamConverter {
        public KSessionConverter() {
            super(KieSessionModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieSessionModelImpl kSession = (KieSessionModelImpl)value;
            writer.addAttribute("name", kSession.getName());
            writer.addAttribute("type", kSession.getType().toString().toLowerCase());
            writer.addAttribute("default", Boolean.toString(kSession.isDefault()));
            if (kSession.getClockType() != null) {
                writer.addAttribute("clockType", kSession.getClockType().getClockType());
            }
            if (kSession.getScope() != null) {
                writer.addAttribute("scope", kSession.getScope());
            }
            this.writeObjectList(writer, context, "workItemHandlers", "workItemHandler", kSession.getWorkItemHandelerModels());
            if (!kSession.getListenerModels().isEmpty()) {
                writer.startNode("listeners");
                for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.WORKING_MEMORY_EVENT_LISTENER)) {
                    this.writeObject(writer, context, listener.getKind().toString(), listener);
                }
                for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.AGENDA_EVENT_LISTENER)) {
                    this.writeObject(writer, context, listener.getKind().toString(), listener);
                }
                for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.PROCESS_EVENT_LISTENER)) {
                    this.writeObject(writer, context, listener.getKind().toString(), listener);
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            String scope;
            final KieSessionModelImpl kSession = new KieSessionModelImpl();
            kSession.setName(reader.getAttribute("name"));
            kSession.setDefault("true".equals(reader.getAttribute("default")));
            String kSessionType = reader.getAttribute("type");
            kSession.setType(kSessionType != null ? KieSessionModel.KieSessionType.valueOf((String)kSessionType.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
            String clockType = reader.getAttribute("clockType");
            if (clockType != null) {
                kSession.setClockType(ClockTypeOption.get((String)clockType));
            }
            if ((scope = reader.getAttribute("scope")) != null) {
                kSession.setScope(scope);
            }
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    block3: {
                        block2: {
                            if (!"listeners".equals(name)) break block2;
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                String nodeName = reader.getNodeName();
                                ListenerModelImpl listener = (ListenerModelImpl)KSessionConverter.this.readObject(reader, context, ListenerModelImpl.class);
                                listener.setKSession(kSession);
                                listener.setKind(ListenerModel.Kind.fromString((String)nodeName));
                                kSession.addListenerModel(listener);
                                reader.moveUp();
                            }
                            break block3;
                        }
                        if (!"workItemHandlers".equals(name)) break block3;
                        List wihs = KSessionConverter.this.readObjectList(reader, context, WorkItemHandlerModelImpl.class);
                        for (WorkItemHandlerModelImpl wih : wihs) {
                            wih.setKSession(kSession);
                            kSession.addWorkItemHandelerModel(wih);
                        }
                    }
                }
            });
            return kSession;
        }
    }
}

