/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.base.mvel.MVELConsequence;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Consequence;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Wireable;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELConsequenceBuilder
implements ConsequenceBuilder {
    public static final Map<String, Macro> macros = new HashMap<String, Macro>(10);

    @Override
    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect(context.getDialect().getId());
            RuleDescr ruleDescr = context.getRuleDescr();
            String text = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
            text = MVELConsequenceBuilder.processMacros(text);
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            AnalysisResult analysis = dialect.analyzeBlock(context, context.getRuleDescr(), dialect.getInterceptors(), text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getPackageBuilder().getGlobals(), null, KnowledgeHelper.class), null, "drools", KnowledgeHelper.class);
            if (analysis == null) {
                return;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            String[] declrStr = new String[declarations.length];
            int j = 0;
            Iterator<String> i$ = usedIdentifiers.getDeclrClasses().keySet().iterator();
            while (i$.hasNext()) {
                String str;
                declrStr[j] = str = i$.next();
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            for (int i = 0; i < declrStr.length; ++i) {
                declrStr[i] = declarations[i].getIdentifier();
            }
            context.getRule().setRequiredDeclarationsForConsequence(consequenceName, declrStr);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, declarations, null, null, context, "drools", KnowledgeHelper.class, false);
            MVELConsequence expr = new MVELConsequence(unit, dialect.getId());
            if ("default".equals(consequenceName)) {
                context.getRule().setConsequence((Consequence)expr);
            } else {
                context.getRule().addNamedConsequence(consequenceName, (Consequence)expr);
            }
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)context.getRule(), (MVELCompileable)expr);
            expr.compile(data);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, context.getRuleDescr());
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Unable to build expression for 'consequence': " + e.getMessage() + " '" + context.getRuleDescr().getConsequence() + "'"));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELConsequenceBuilder.delimitExpressions(consequence));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String delimitExpressions(String s) {
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        boolean inString = false;
        char lastNonWhite = ';';
        int i = 0;
        while (true) {
            block23: {
                char c;
                block22: {
                    int start;
                    if (i >= cs.length) {
                        return result.toString();
                    }
                    c = cs[i];
                    switch (c) {
                        case '\"': {
                            if (i == 0 || cs[i - 1] != '\\') {
                                inString = !inString;
                            }
                            break block22;
                        }
                        case '/': {
                            if (i < cs.length - 1 && cs[i + 1] == '*' && !inString) {
                                start = i;
                                i += 2;
                                break;
                            }
                            if (i < cs.length - 1 && cs[i + 1] != '/') break block22;
                        }
                        case '#': {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, brace, sqre, crly, lastNonWhite);
                            i = MVELConsequenceBuilder.processLineComment(cs, i, result);
                            break block23;
                        }
                        case '(': {
                            ++brace;
                            break block22;
                        }
                        case '{': {
                            ++crly;
                            break block22;
                        }
                        case '[': {
                            ++sqre;
                            break block22;
                        }
                        case ')': {
                            --brace;
                            break block22;
                        }
                        case '}': {
                            --crly;
                            break block22;
                        }
                        case ']': {
                            --sqre;
                            break block22;
                        }
                    }
                    while (i < cs.length) {
                        if (cs[i] == '*' && i < cs.length - 1 && cs[i + 1] == '/') {
                            ++i;
                            break;
                        }
                        if (cs[i] == '\n' || cs[i] == '\r') {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, brace, sqre, crly, lastNonWhite);
                        }
                        ++i;
                    }
                    result.append(cs, start, i - start);
                }
                if (brace == 0 && sqre == 0 && crly == 0 && (c == '\n' || c == '\r')) {
                    if (lastNonWhite != ';') {
                        result.append(';');
                        lastNonWhite = ';';
                    }
                } else if (!Character.isWhitespace(c)) {
                    lastNonWhite = c;
                }
                result.append(c);
            }
            ++i;
        }
    }

    private static int processLineComment(char[] cs, int i, StringBuilder result) {
        while (i < cs.length) {
            result.append(cs[i]);
            if (cs[i] == '\n' || cs[i] == '\r') break;
            ++i;
        }
        return i;
    }

    private static char checkAndAddSemiColon(StringBuilder result, int brace, int sqre, int crly, char lastNonWhite) {
        if (brace == 0 && sqre == 0 && crly == 0 && lastNonWhite != ';') {
            result.append(';');
            lastNonWhite = (char)59;
        }
        return lastNonWhite;
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        macros.put("entryPoints", new Macro(){

            public String doMacro() {
                return "drools.entryPoints";
            }
        });
        macros.put("exitPoints", new Macro(){

            public String doMacro() {
                return "drools.exitPoints";
            }
        });
        macros.put("don", new Macro(){

            public String doMacro() {
                return "drools.don";
            }
        });
        macros.put("shed", new Macro(){

            public String doMacro() {
                return "drools.shed";
            }
        });
    }
}

