/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.kproject.models.KieBaseModelImpl;
import org.drools.kproject.models.KieSessionModelImpl;
import org.kie.KieBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieModule;
import org.kie.builder.KieRepository;
import org.kie.builder.KieSessionModel;
import org.kie.builder.Message;
import org.kie.builder.ReleaseId;
import org.kie.builder.Results;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieModuleKieProject;
import org.kie.builder.impl.KieProject;
import org.kie.builder.impl.ResultsImpl;
import org.kie.runtime.Environment;
import org.kie.runtime.KieContainer;
import org.kie.runtime.KieSession;
import org.kie.runtime.KieSessionConfiguration;
import org.kie.runtime.StatelessKieSession;
import org.kie.runtime.conf.KieSessionOption;
import org.kie.util.CDIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerImpl
implements KieContainer {
    private static final Logger log = LoggerFactory.getLogger(KieContainerImpl.class);
    private KieProject kProject;
    private final Map<String, KieBase> kBases = new HashMap<String, KieBase>();
    private final KieRepository kr;

    public KieContainerImpl(KieProject kProject, KieRepository kr) {
        this.kr = kr;
        this.kProject = kProject;
        kProject.init();
    }

    public ReleaseId getReleaseId() {
        return this.kProject.getGAV();
    }

    public void updateToVersion(ReleaseId releaseId) {
        this.kBases.clear();
        this.kProject = new KieModuleKieProject((InternalKieModule)this.kr.getKieModule(releaseId), this.kr);
        this.kProject.init();
    }

    public KieBase getKieBase() {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a defualt KieBase");
        }
        return this.getKieBase(defaultKieBaseModel.getName());
    }

    public Results verify() {
        return this.kProject.verify();
    }

    public KieBase getKieBase(String kBaseName) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            ResultsImpl msgs = new ResultsImpl();
            kBase = AbstractKieModule.createKieBase((KieBaseModelImpl)this.kProject.getKieBaseModel(kBaseName), this.kProject, msgs);
            if (kBase == null) {
                throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
            }
            if (kBase != null) {
                this.kBases.put(kBaseName, kBase);
            }
        }
        return kBase;
    }

    public KieSession newKieSession() {
        return this.newKieSession((Environment)null);
    }

    public KieSession newKieSession(Environment environment) {
        KieSessionModel defaultKieSessionModel = this.kProject.getDefaultKieSession();
        if (defaultKieSessionModel == null) {
            throw new RuntimeException("Cannot find a defualt KieSession");
        }
        return this.newKieSession(defaultKieSessionModel.getName(), environment);
    }

    public StatelessKieSession newStatelessKieSession() {
        KieSessionModel defaultKieSessionModel = this.kProject.getDefaultStatelessKieSession();
        if (defaultKieSessionModel == null) {
            throw new RuntimeException("Cannot find a defualt StatelessKieSession");
        }
        return this.newStatelessKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(String kSessionName) {
        return this.newKieSession(kSessionName, null);
    }

    public KieSession newKieSession(String kSessionName, Environment environment) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        KieSession kSession = kBase.newKieSession(this.getKnowledgeSessionConfiguration(kSessionModel), environment);
        CDIHelper.wireListnersAndWIHs(kSessionModel, kSession);
        return kSession;
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionName == null) {
            return null;
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            return null;
        }
        return kBase.newStatelessKieSession(this.getKnowledgeSessionConfiguration(kSessionModel));
    }

    private KieSessionConfiguration getKnowledgeSessionConfiguration(KieSessionModelImpl kSessionModel) {
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksConf.setOption((KieSessionOption)kSessionModel.getClockType());
        return ksConf;
    }

    public void dispose() {
    }

    public KieProject getKieProject() {
        return this.kProject;
    }

    public KieModule getKieModuleForKBase(String kBaseName) {
        return this.kProject.getKieModuleForKBase(kBaseName);
    }

    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kProject.getKieBaseModel(kBaseName);
    }

    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kProject.getKieSessionModel(kSessionName);
    }

    public ClassLoader getClassLoader() {
        return this.kProject.getClassLoader();
    }
}

