/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.runtime.rule.AccumulateFunction;

public class MinAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new MinData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        MinData data = (MinData)context;
        data.min = Double.MAX_VALUE;
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        MinData data = (MinData)context;
        data.min = Math.min(data.min, ((Number)value).doubleValue());
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        MinData data = (MinData)context;
        return new Double(data.min);
    }

    @Override
    public boolean supportsReverse() {
        return false;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class MinData
    implements Externalizable {
        public double min = Double.MAX_VALUE;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.min = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.min);
        }
    }
}

