/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.command.Context;
import org.kie.command.World;

public class ContextImpl
implements Context {
    private World manager;
    private String name;
    private Map<String, Object> context = new ConcurrentHashMap<String, Object>();
    private Context parent;

    public ContextImpl(String name, World manager) {
        this.name = name;
        this.manager = manager;
    }

    public ContextImpl(String name, World manager, Context delegate) {
        this.name = name;
        this.manager = manager;
        this.setParent(delegate);
    }

    public void setParent(Context delegate) {
        this.parent = delegate;
    }

    @Override
    public World getContextManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(String identifier) {
        if (identifier == null || identifier.equals("")) {
            return null;
        }
        Object object = this.context.get(identifier);
        if (object == null && this.parent != null) {
            object = this.parent.get(identifier);
        }
        return object;
    }

    @Override
    public void set(String name, Object object) {
        this.context.put(name, object);
    }

    @Override
    public void remove(String name) {
        this.context.remove(name);
    }

    public String toString() {
        return "ContextImpl [name=" + this.name + ", parent=" + this.parent.getName() + ", context=" + this.context + "]";
    }
}

