/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.drools.core.util.StringUtils;
import org.kie.builder.ReleaseId;

public class ReleaseIdImpl
implements ReleaseId {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public ReleaseIdImpl(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    @Override
    public String toExternalForm() {
        return this.toString();
    }

    public String getPomXmlPath() {
        return "META-INF/maven/" + this.groupId + "/" + this.artifactId + "/pom.xml";
    }

    public String getPomPropertiesPath() {
        return "META-INF/maven/" + this.groupId + "/" + this.artifactId + "/pom.properties";
    }

    public static ReleaseId fromPropertiesString(String string) {
        Properties props = new Properties();
        ReleaseIdImpl releaseId = null;
        try {
            props.load(new StringReader(string));
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            String version = props.getProperty("version");
            if (StringUtils.isEmpty(groupId) || StringUtils.isEmpty(artifactId) || StringUtils.isEmpty(version)) {
                throw new RuntimeException("pom.properties exists but ReleaseId content is malformed\n" + string);
            }
            releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        }
        catch (IOException e) {
            throw new RuntimeException("pom.properties was malformed\n" + string, e);
        }
        return releaseId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseIdImpl that = (ReleaseIdImpl)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

