/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.JavaCompiler;
import org.drools.commons.jci.compilers.JavaCompilerFactory;
import org.drools.commons.jci.compilers.JavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.StringUtils;
import org.drools.io.internal.InternalResource;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.ConditionalBranchDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.NamedConsequenceDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.WindowReferenceDescr;
import org.drools.rule.Function;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConditionalBranchBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.EnabledBuilder;
import org.drools.rule.builder.EngineElementBuilder;
import org.drools.rule.builder.EntryPointBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.FunctionBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.NamedConsequenceBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.WindowReferenceBuilder;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.asm.ASMConsequenceStubBuilder;
import org.drools.rule.builder.dialect.asm.ASMEvalStubBuilder;
import org.drools.rule.builder.dialect.asm.ASMPredicateStubBuilder;
import org.drools.rule.builder.dialect.asm.ASMReturnValueStubBuilder;
import org.drools.rule.builder.dialect.java.JavaAccumulateBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.rule.builder.dialect.java.JavaExprAnalyzer;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.java.JavaRuleClassBuilder;
import org.drools.rule.builder.dialect.java.PackageStore;
import org.drools.rule.builder.dialect.mvel.MVELEnabledBuilder;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.kie.builder.KnowledgeBuilderResult;
import org.kie.io.Resource;

public class JavaDialect
implements Dialect {
    public static final String ID = "java";
    private static final String EXPRESSION_DIALECT_NAME = "mvel";
    protected static PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    protected static QueryBuilder QUERY_BUILDER = new QueryBuilder();
    protected static SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    protected static EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    protected static JavaAccumulateBuilder ACCUMULATE_BUILDER = new JavaAccumulateBuilder();
    protected static RuleConditionBuilder EVAL_BUILDER = new ASMEvalStubBuilder();
    protected static PredicateBuilder PREDICATE_BUILDER = new ASMPredicateStubBuilder();
    protected static ReturnValueBuilder RETURN_VALUE_BUILDER = new ASMReturnValueStubBuilder();
    protected static ConsequenceBuilder CONSEQUENCE_BUILDER = new ASMConsequenceStubBuilder();
    protected static JavaRuleClassBuilder RULE_CLASS_BUILDER = new JavaRuleClassBuilder();
    protected static MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    protected static JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    protected static CollectBuilder COLLECT_BUIDER = new CollectBuilder();
    protected static ForallBuilder FORALL_BUILDER = new ForallBuilder();
    protected static EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    protected static WindowReferenceBuilder WINDOW_REFERENCE_BUILDER = new WindowReferenceBuilder();
    protected static GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    protected static NamedConsequenceBuilder NAMED_CONSEQUENCE_BUILDER = new NamedConsequenceBuilder();
    protected static ConditionalBranchBuilder CONDITIONAL_BRANCH_BUILDER = new ConditionalBranchBuilder();
    private static Map<Class<?>, EngineElementBuilder> builders;
    private static final JavaExprAnalyzer analyzer;
    private final JavaDialectConfiguration configuration;
    private JavaCompiler compiler;
    private final Package pkg;
    private final List<String> generatedClassList;
    private final MemoryResourceReader src;
    private final PackageStore packageStoreWrapper;
    private final Map<String, PackageBuilder.ErrorHandler> errorHandlers;
    private final List<KnowledgeBuilderResult> results;
    private final PackageBuilder packageBuilder;
    private final PackageRegistry packageRegistry;

    public static void setPatternBuilder(PatternBuilder PATTERN_BUILDER) {
        JavaDialect.PATTERN_BUILDER = PATTERN_BUILDER;
    }

    public static void setGEBuilder(GroupElementBuilder GE_BUILDER) {
        JavaDialect.GE_BUILDER = GE_BUILDER;
    }

    public JavaDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg) {
        JavaDialectRuntimeData data;
        this.packageBuilder = builder;
        this.pkg = pkg;
        this.packageRegistry = pkgRegistry;
        this.configuration = (JavaDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration(ID);
        this.errorHandlers = new HashMap<String, PackageBuilder.ErrorHandler>();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.src = new MemoryResourceReader();
        this.generatedClassList = new ArrayList<String>();
        if (pkg.getDialectRuntimeRegistry().getDialectData(ID) == null) {
            data = new JavaDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(ID, data);
            data.onAdd(this.pkg.getDialectRuntimeRegistry(), this.packageBuilder.getRootClassLoader());
        } else {
            data = (JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(ID);
        }
        this.packageStoreWrapper = new PackageStore(data, this.results);
        this.loadCompiler();
    }

    public static synchronized void initBuilder() {
        if (builders != null) {
            return;
        }
        JavaDialect.reinitBuilder();
    }

    public static synchronized void reinitBuilder() {
        builders = new HashMap();
        builders.put(CollectDescr.class, COLLECT_BUIDER);
        builders.put(ForallDescr.class, FORALL_BUILDER);
        builders.put(AndDescr.class, GE_BUILDER);
        builders.put(OrDescr.class, GE_BUILDER);
        builders.put(NotDescr.class, GE_BUILDER);
        builders.put(ExistsDescr.class, GE_BUILDER);
        builders.put(PatternDescr.class, PATTERN_BUILDER);
        builders.put(QueryDescr.class, QUERY_BUILDER);
        builders.put(FromDescr.class, FROM_BUILDER);
        builders.put(AccumulateDescr.class, ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, EVAL_BUILDER);
        builders.put(EntryPointDescr.class, ENTRY_POINT_BUILDER);
        builders.put(WindowReferenceDescr.class, WINDOW_REFERENCE_BUILDER);
        builders.put(NamedConsequenceDescr.class, NAMED_CONSEQUENCE_BUILDER);
        builders.put(ConditionalBranchDescr.class, CONDITIONAL_BRANCH_BUILDER);
    }

    @Override
    public Map<Class<?>, EngineElementBuilder> getBuilders() {
        return builders;
    }

    @Override
    public void init(RuleDescr ruleDescr) {
        String ruleClassName = DialectUtil.getUniqueLegalName(this.pkg.getName(), ruleDescr.getName(), ID, "Rule", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst(ruleClassName));
    }

    @Override
    public void init(ProcessDescr processDescr) {
        String processDescrClassName = DialectUtil.getUniqueLegalName(this.pkg.getName(), processDescr.getName(), ID, "Process", this.src);
        processDescr.setClassName(StringUtils.ucFirst(processDescrClassName));
    }

    @Override
    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    @Override
    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
        return this.analyzeExpression(context, descr, content, availableIdentifiers, null);
    }

    public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers, Map<String, Class<?>> localTypes) {
        JavaAnalysisResult result = null;
        try {
            result = analyzer.analyzeExpression((String)content, availableIdentifiers);
        }
        catch (Exception e) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    @Override
    public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
        JavaAnalysisResult result = null;
        try {
            result = analyzer.analyzeBlock(text, availableIdentifiers);
        }
        catch (Exception e) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    @Override
    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)builders.get(clazz);
    }

    @Override
    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return QUERY_BUILDER;
    }

    @Override
    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    @Override
    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    @Override
    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    @Override
    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    @Override
    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    @Override
    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    @Override
    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    @Override
    public RuleClassBuilder getRuleClassBuilder() {
        return RULE_CLASS_BUILDER;
    }

    public FunctionBuilder getFunctionBuilder() {
        return FUNCTION_BUILDER;
    }

    @Override
    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    @Override
    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    @Override
    public void compileAll() {
        CompilationResult result;
        if (this.generatedClassList.isEmpty()) {
            return;
        }
        String[] classes = new String[this.generatedClassList.size()];
        this.generatedClassList.toArray(classes);
        File dumpDir = this.configuration.getPackageBuilderConfiguration().getDumpDir();
        if (dumpDir != null) {
            this.dumpResources(classes, dumpDir);
        }
        if ((result = this.compiler.compile(classes, this.src, this.packageStoreWrapper, this.packageBuilder.getRootClassLoader())).getErrors().length > 0) {
            for (int i = 0; i < result.getErrors().length; ++i) {
                CompilationProblem err = result.getErrors()[i];
                PackageBuilder.ErrorHandler handler = this.errorHandlers.get(err.getFileName());
                handler.addError(err);
            }
            Collection<PackageBuilder.ErrorHandler> errors = this.errorHandlers.values();
            for (PackageBuilder.ErrorHandler error : errors) {
                PackageBuilder.ErrorHandler handler = error;
                if (!handler.isInError()) continue;
                this.results.add(handler.getError());
            }
        }
        this.generatedClassList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpResources(String[] classes, File dumpDir) {
        for (String aClass : classes) {
            File target = new File(dumpDir, aClass);
            FileOutputStream out = null;
            try {
                File parent = target.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                target.createNewFile();
                out = new FileOutputStream(target);
                out.write(this.src.getBytes(aClass));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    @Override
    public void addRule(RuleBuildContext context) {
        Rule rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        RuleClassBuilder classBuilder = context.getDialect().getRuleClassBuilder();
        String ruleClass = classBuilder.buildRule(context);
        if (ruleClass == null) {
            return;
        }
        this.addClassCompileTask(this.pkg.getName() + "." + ruleDescr.getClassName(), ruleDescr, ruleClass, this.src, new PackageBuilder.RuleErrorHandler(ruleDescr, rule, "Rule Compilation error"));
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData(ID);
        for (Map.Entry<String, String> invokers : context.getInvokers().entrySet()) {
            String className = invokers.getKey();
            Object invoker = context.getInvokerLookups().get(className);
            if (invoker != null) {
                data.putInvoker(className, invoker);
            }
            String text = invokers.getValue();
            BaseDescr descr = (BaseDescr)context.getDescrLookups().get(className);
            this.addClassCompileTask(className, descr, text, this.src, new PackageBuilder.RuleInvokerErrorHandler(descr, rule, "Unable to generate rule invoker."));
        }
        String name = this.pkg.getName() + "." + StringUtils.ucFirst(ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        this.pkg.getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    @Override
    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst(functionDescr.getName());
        functionDescr.setClassName(functionClassName);
        this.pkg.addStaticImport(functionClassName + "." + functionDescr.getName());
        Function function = new Function(functionDescr.getNamespace(), functionDescr.getName(), ID);
        if (resource != null && ((InternalResource)resource).hasURL()) {
            function.setResource(resource);
        }
        this.pkg.addFunction(function);
        String functionSrc = this.getFunctionBuilder().build(this.pkg, functionDescr, typeResolver, this.pkg.getDialectRuntimeRegistry().getLineMappings(), this.results);
        this.addClassCompileTask(functionClassName, functionDescr, functionSrc, this.src, new PackageBuilder.FunctionErrorHandler(functionDescr, "Function Compilation error"));
        LineMappings mapping = new LineMappings(functionClassName);
        mapping.setStartLine(functionDescr.getLine());
        mapping.setOffset(functionDescr.getOffset());
        this.pkg.getDialectRuntimeRegistry().getLineMappings().put(functionClassName, mapping);
    }

    @Override
    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst(functionDescr.getName());
        this.pkg.addStaticImport(functionClassName + "." + functionDescr.getName());
    }

    @Override
    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = this.pkg.getName() + "." + StringUtils.ucFirst(functionDescr.getName());
        ImportDescr importDescr = new ImportDescr(functionClassName + "." + functionDescr.getName());
        importDescr.setResource(functionDescr.getResource());
        importDescr.setNamespace(functionDescr.getNamespace());
        this.packageRegistry.addStaticImport(importDescr);
    }

    public void addSrc(String resourceName, byte[] content) {
        this.src.add(resourceName, content);
        this.errorHandlers.put(resourceName, new PackageBuilder.SrcErrorHandler("Src compile error"));
        this.addClassName(resourceName);
    }

    public void addClassCompileTask(String className, BaseDescr descr, String text, MemoryResourceReader src, PackageBuilder.ErrorHandler handler) {
        String fileName = className.replace('.', '/') + ".java";
        if (src != null) {
            src.add(fileName, text.getBytes());
        } else {
            this.src.add(fileName, text.getBytes());
        }
        this.errorHandlers.put(fileName, handler);
        this.addClassName(fileName);
    }

    public void addClassName(String className) {
        this.generatedClassList.add(className);
    }

    private void loadCompiler() {
        switch (this.configuration.getCompiler()) {
            case 1: {
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("janino");
                break;
            }
            default: {
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("eclipse");
                JavaCompilerSettings settings = this.compiler.createDefaultSettings();
                String lngLevel = this.configuration.getJavaLanguageLevel();
                settings.setTargetVersion(lngLevel);
                settings.setSourceVersion(lngLevel);
                break;
            }
        }
    }

    @Override
    public void addImport(ImportDescr importDescr) {
    }

    @Override
    public void addStaticImport(ImportDescr importDescr) {
    }

    @Override
    public List<KnowledgeBuilderResult> getResults() {
        return this.results;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public PackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    static {
        JavaDialect.initBuilder();
        analyzer = new JavaExprAnalyzer();
    }
}

