/*
 * Decompiled with CFR 0.152.
 */
package org.kie.logger;

import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.logger.KieLoggers;
import org.kie.logger.KnowledgeRuntimeLogger;

public class KnowledgeRuntimeLoggerFactory {
    private static KieLoggers knowledgeRuntimeLoggerFactoryService;

    public static KnowledgeRuntimeLogger newFileLogger(KnowledgeRuntimeEventManager session, String fileName) {
        return (KnowledgeRuntimeLogger)KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newFileLogger(session, fileName);
    }

    public static KnowledgeRuntimeLogger newThreadedFileLogger(KnowledgeRuntimeEventManager session, String fileName, int interval) {
        return (KnowledgeRuntimeLogger)KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newThreadedFileLogger(session, fileName, interval);
    }

    public static KnowledgeRuntimeLogger newConsoleLogger(KnowledgeRuntimeEventManager session) {
        return (KnowledgeRuntimeLogger)KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newConsoleLogger(session);
    }

    private static synchronized void setKnowledgeRuntimeLoggerProvider(KieLoggers provider) {
        knowledgeRuntimeLoggerFactoryService = provider;
    }

    private static synchronized KieLoggers getKnowledgeRuntimeLoggerProvider() {
        if (knowledgeRuntimeLoggerFactoryService == null) {
            KnowledgeRuntimeLoggerFactory.loadProvider();
        }
        return knowledgeRuntimeLoggerFactoryService;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.audit.KnowledgeRuntimeLoggerProviderImpl");
            KnowledgeRuntimeLoggerFactory.setKnowledgeRuntimeLoggerProvider((KieLoggers)cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Provider org.drools.audit.KnowledgeRuntimeLoggerProviderImpl could not be set.", e);
        }
    }
}

