/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import com.google.protobuf.ExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleCache;
import org.drools.compiler.kie.builder.impl.KieModuleCacheHelper;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.io.ResourceTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieModule
implements InternalKieModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractKieModule.class);
    private final Map<String, KnowledgeBuilder> kBuilders = new HashMap<String, KnowledgeBuilder>();
    private final Map<String, Results> resultsCache = new HashMap<String, Results>();
    protected final ReleaseId releaseId;
    private final KieModuleModel kModuleModel;
    private Map<ReleaseId, InternalKieModule> dependencies;
    protected Map<String, Map<String, Map<String, byte[]>>> compilationCache = new HashMap<String, Map<String, Map<String, byte[]>>>();
    private Map<String, TypeMetaInfo> typesMetaInfo;

    public AbstractKieModule(ReleaseId releaseId, KieModuleModel kModuleModel) {
        this.releaseId = releaseId;
        this.kModuleModel = kModuleModel;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.kModuleModel;
    }

    @Override
    public Map<ReleaseId, InternalKieModule> getDependencies() {
        return this.dependencies == null ? Collections.emptyMap() : this.dependencies;
    }

    @Override
    public void addDependency(InternalKieModule dependency) {
        if (this.dependencies == null) {
            this.dependencies = new HashMap<ReleaseId, InternalKieModule>();
        }
        this.dependencies.put(dependency.getReleaseId(), dependency);
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    @Override
    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.kBuilders.get(kieBaseName);
    }

    @Override
    public Collection<KnowledgePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        KnowledgeBuilder kbuilder = this.kBuilders.get(kieBaseName);
        return kbuilder != null ? kbuilder.getKnowledgePackages() : null;
    }

    @Override
    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.kBuilders.put(kieBaseName, kbuilder);
    }

    @Override
    public Map<String, Results> getKnowledgeResultsCache() {
        return this.resultsCache;
    }

    @Override
    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.resultsCache.put(kieBaseName, results);
    }

    @Override
    public Map<String, byte[]> getClassesMap(boolean includeTypeDeclarations) {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith(".class") || !includeTypeDeclarations && this.isTypeDeclaration(fileName)) continue;
            classes.put(fileName, this.getBytes(fileName));
        }
        return classes;
    }

    private boolean isTypeDeclaration(String fileName) {
        Map<String, TypeMetaInfo> info = this.getTypesMetaInfo();
        TypeMetaInfo typeInfo = info == null ? null : info.get(ClassUtils.convertResourceToClassName((String)fileName));
        return typeInfo != null && typeInfo.isDeclaredType();
    }

    private Map<String, TypeMetaInfo> getTypesMetaInfo() {
        byte[] bytes;
        if (this.typesMetaInfo == null && (bytes = this.getBytes(KieModuleModelImpl.KMODULE_INFO_JAR_PATH)) != null) {
            this.typesMetaInfo = TypeMetaInfo.unmarshallMetaInfos((String)new String(bytes));
        }
        return this.typesMetaInfo;
    }

    static KnowledgeBuilder buildKnowledgePackages(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages) {
        AbstractKieModule kModule = (AbstractKieModule)kieProject.getKieModuleForKBase(kBaseModel.getName());
        PackageBuilderConfiguration pconf = new PackageBuilderConfiguration(kieProject.getClonedClassLoader());
        pconf.setCompilationCache(kModule.getCompilationCache(kBaseModel.getName()));
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        Set<String> includes = kBaseModel.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            for (String include : includes) {
                if (StringUtils.isEmpty((CharSequence)include)) continue;
                InternalKieModule includeModule = kieProject.getKieModuleForKBase(include);
                if (includeModule == null) {
                    log.error("Unable to build KieBase, could not find include: " + include);
                    return null;
                }
                AbstractKieModule.addFiles(ckbuilder, kieProject.getKieBaseModel(include), includeModule);
            }
        }
        AbstractKieModule.addFiles(ckbuilder, kBaseModel, kModule);
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                messages.addMessage((KnowledgeBuilderResult)error);
            }
            log.error("Unable to build KieBaseModel:" + kBaseModel.getName() + "\n" + kbuilder.getErrors().toString());
        }
        kModule.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), kbuilder);
        kModule.cacheResultsForKieBase(kBaseModel.getName(), messages);
        return kbuilder;
    }

    private static void addFiles(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, InternalKieModule kieModule) {
        int fileCount = 0;
        for (String fileName : kieModule.getFileNames()) {
            if (!KieBuilderImpl.filterFileInKBase(kieBaseModel, fileName) || fileName.endsWith(".properties")) continue;
            fileCount += AbstractKieModule.addFile(ckbuilder, kieModule, fileName) ? 1 : 0;
        }
        if (fileCount == 0) {
            if (kieModule instanceof FileKieModule) {
                log.warn("No files found for KieBase " + kieBaseModel.getName() + ", searching folder " + kieModule.getFile());
            } else {
                log.warn("No files found for KieBase " + kieBaseModel.getName());
            }
        }
    }

    public static boolean addFile(CompositeKnowledgeBuilder ckbuilder, InternalKieModule kieModule, String fileName) {
        ResourceConfiguration conf = AbstractKieModule.getResourceConfiguration(kieModule, fileName);
        Resource resource = kieModule.getResource(fileName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)fileName));
            } else {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)fileName), conf);
            }
            return true;
        }
        return false;
    }

    @Override
    public Resource getResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        if (bytes != null && bytes.length > 0) {
            return ResourceFactory.newByteArrayResource((byte[])bytes).setSourcePath(fileName);
        }
        return null;
    }

    public static ResourceConfiguration getResourceConfiguration(InternalKieModule kieModule, String fileName) {
        ResourceConfiguration conf = null;
        if (kieModule.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(kieModule.getBytes(fileName + ".properties")));
            }
            catch (IOException e) {
                log.error("Error loading resource configuration from file: " + fileName + ".properties");
            }
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        } else if (ResourceType.DTABLE.matchesExtension(fileName) && fileName.endsWith(".csv")) {
            Properties prop = new Properties();
            prop.setProperty("kie.resource.conf.class", DecisionTableConfigurationImpl.class.getName());
            prop.setProperty("drools.dt.type", DecisionTableInputType.CSV.toString());
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        }
        return conf;
    }

    protected Map<String, Map<String, byte[]>> getCompilationCache(String kbaseName) {
        byte[] fileContents;
        Map<String, Map<String, byte[]>> cache = this.compilationCache.get(kbaseName);
        if (cache == null && (fileContents = this.getBytes(KieBuilderImpl.getCompilationCachePath(this.releaseId, kbaseName))) != null) {
            ExtensionRegistry registry = KieModuleCacheHelper.buildRegistry();
            try {
                KieModuleCache.Header _header = KieModuleCacheHelper.readFromStreamWithHeaderPreloaded(new ByteArrayInputStream(fileContents), registry);
                KieModuleCache.KModuleCache _cache = KieModuleCache.KModuleCache.parseFrom(_header.getPayload());
                cache = new HashMap<String, Map<String, byte[]>>();
                for (KieModuleCache.CompilationData _data : _cache.getCompilationDataList()) {
                    HashMap<String, byte[]> bytecode = new HashMap<String, byte[]>();
                    cache.put(_data.getDialect(), bytecode);
                    for (KieModuleCache.CompDataEntry _entry : _data.getEntryList()) {
                        bytecode.put(_entry.getId(), _entry.getData().toByteArray());
                    }
                }
                this.compilationCache.put(kbaseName, cache);
            }
            catch (Exception e) {
                log.error("Unable to load compilation cache... ", (Throwable)e);
            }
        }
        return cache;
    }
}

