/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.core.util.ClassUtils;

public final class JavaCompilerFactory {
    private static final JavaCompilerFactory INSTANCE = new JavaCompilerFactory();
    private final Map classCache = new HashMap();

    public static JavaCompilerFactory getInstance() {
        return INSTANCE;
    }

    public JavaCompiler createCompiler(String pHint) {
        String className = pHint.indexOf(46) < 0 ? "org.drools.compiler.commons.jci.compilers." + ClassUtils.toJavaCasing((String)pHint) + "JavaCompiler" : pHint;
        Class<?> clazz = (Class<?>)this.classCache.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                this.classCache.put(className, clazz);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            return (JavaCompiler)clazz.newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public JavaCompiler loadCompiler(JavaDialectConfiguration configuration) {
        JavaCompiler compiler;
        switch (configuration.getCompiler()) {
            case 1: {
                compiler = this.createCompiler("janino");
                break;
            }
            case 2: {
                compiler = this.createCompiler("native");
                break;
            }
            default: {
                compiler = this.createCompiler("eclipse");
                JavaCompilerSettings settings = compiler.createDefaultSettings();
                String lngLevel = configuration.getJavaLanguageLevel();
                settings.setTargetVersion(lngLevel);
                settings.setSourceVersion(lngLevel);
                break;
            }
        }
        return compiler;
    }
}

