/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.errors.ErrorHandler;
import org.drools.compiler.builder.impl.errors.SrcErrorHandler;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.JavaConfiguration;
import org.drools.core.util.ClassUtils;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.jci.CompilationProblem;

public class ProjectJavaCompiler {
    private final JavaCompiler compiler;

    public ProjectJavaCompiler(KnowledgeBuilderConfigurationImpl pkgConf) {
        this((JavaConfiguration)pkgConf.getDialectConfiguration("java"));
    }

    public ProjectJavaCompiler(JavaConfiguration configuration) {
        this.compiler = JavaCompilerFactory.INSTANCE.loadCompiler(configuration);
    }

    public List<KnowledgeBuilderResult> compileAll(ProjectClassLoader projectClassLoader, List<String> classList, MemoryResourceReader src) {
        ArrayList<KnowledgeBuilderResult> results = new ArrayList<KnowledgeBuilderResult>();
        if (classList.isEmpty()) {
            return results;
        }
        String[] classes = new String[classList.size()];
        classList.toArray(classes);
        CompilationResult result = this.compiler.compile(classes, src, new ProjectResourceStore(projectClassLoader), (ClassLoader)projectClassLoader);
        if (result.getErrors().length > 0) {
            HashMap<String, ErrorHandler> errorHandlerMap = new HashMap<String, ErrorHandler>();
            for (int i = 0; i < result.getErrors().length; ++i) {
                CompilationProblem err = result.getErrors()[i];
                ErrorHandler handler = (ErrorHandler)errorHandlerMap.get(err.getFileName());
                if (handler == null) {
                    handler = new SrcErrorHandler("Src compile error");
                    errorHandlerMap.put(err.getFileName(), handler);
                }
                handler.addError(err);
            }
            for (ErrorHandler handler : errorHandlerMap.values()) {
                if (!handler.isInError()) continue;
                results.add(handler.getError());
            }
        }
        return results;
    }

    private static class ProjectResourceStore
    implements ResourceStore {
        private final ProjectClassLoader projectClassLoader;

        private ProjectResourceStore(ProjectClassLoader projectClassLoader) {
            this.projectClassLoader = projectClassLoader;
        }

        @Override
        public void write(String pResourceName, byte[] pResourceData) {
            this.projectClassLoader.defineClass(ClassUtils.convertResourceToClassName((String)pResourceName), pResourceName, pResourceData);
        }

        @Override
        public void write(String resourceName, byte[] clazzData, boolean createFolder) {
            this.write(resourceName, clazzData);
        }

        @Override
        public byte[] read(String pResourceName) {
            return this.projectClassLoader.getBytecode(pResourceName);
        }

        @Override
        public void remove(String pResourceName) {
            throw new UnsupportedOperationException("org.drools.compiler.compiler.ProjectJavaCompiler.ProjectResourceStore.remove -> TODO");
        }
    }
}

