/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.drl.ast.descr.AccumulateImportDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.EntryPointDeclarationDescr;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.WindowDeclarationDescr;
import org.kie.api.io.Resource;
import org.kie.internal.builder.ResourceChange;

public class CompositePackageDescr
extends PackageDescr {
    private CompositeAssetFilter filter;

    public CompositePackageDescr() {
    }

    public CompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        super(packageDescr.getNamespace(), packageDescr.getDocumentation());
        this.internalAdd(resource, packageDescr);
    }

    public void addPackageDescr(Resource resource, PackageDescr packageDescr) {
        if (!this.getNamespace().equals(packageDescr.getNamespace())) {
            throw new RuntimeException("Composing PackageDescr (" + packageDescr.getName() + ") in different namespaces (namespace=" + this.getNamespace() + " packageDescr=" + packageDescr.getNamespace() + ")");
        }
        this.internalAdd(resource, packageDescr);
    }

    private void internalAdd(Resource resource, PackageDescr packageDescr) {
        for (ImportDescr descr : packageDescr.getImports()) {
            this.addImport(descr);
            descr.setResource(resource);
        }
        for (ImportDescr descr : packageDescr.getFunctionImports()) {
            this.addFunctionImport((FunctionImportDescr)descr);
            descr.setResource(resource);
        }
        for (ImportDescr descr : packageDescr.getAccumulateImports()) {
            this.addAccumulateImport((AccumulateImportDescr)descr);
            descr.setResource(resource);
        }
        for (ImportDescr descr : packageDescr.getAttributes()) {
            this.addAttribute((AttributeDescr)descr);
            descr.setResource(resource);
        }
        for (ImportDescr descr : packageDescr.getGlobals()) {
            this.addGlobal((GlobalDescr)descr);
            descr.setResource(resource);
        }
        for (ImportDescr descr : packageDescr.getFunctions()) {
            this.addFunction((FunctionDescr)descr);
            descr.setResource(resource);
        }
        for (ImportDescr descr : packageDescr.getRules()) {
            this.addRule((RuleDescr)descr);
            descr.setResource(resource);
        }
        HashSet typeDeclarationDescrs = new HashSet(this.getTypeDeclarations());
        for (TypeDeclarationDescr descr : packageDescr.getTypeDeclarations()) {
            if (typeDeclarationDescrs.contains(descr)) continue;
            this.addTypeDeclaration(descr);
            descr.setResource(resource);
        }
        for (EnumDeclarationDescr enumDescr : packageDescr.getEnumDeclarations()) {
            this.addEnumDeclaration(enumDescr);
            enumDescr.setResource(resource);
        }
        for (TypeDeclarationDescr descr : packageDescr.getEntryPointDeclarations()) {
            this.addEntryPointDeclaration((EntryPointDeclarationDescr)descr);
            descr.setResource(resource);
        }
        for (TypeDeclarationDescr descr : packageDescr.getWindowDeclarations()) {
            this.addWindowDeclaration((WindowDeclarationDescr)descr);
            descr.setResource(resource);
        }
        packageDescr.getPreferredPkgUUID().ifPresent(pkgUUID -> {
            if (this.getPreferredPkgUUID().isPresent() && !pkgUUID.equals(this.getPreferredPkgUUID().get())) {
                throw new RuntimeException(String.format("Trying to overwrite preferredPkgUUID %s with a different value %s", this.getPreferredPkgUUID().get(), pkgUUID));
            }
            this.setPreferredPkgUUID((String)pkgUUID);
        });
    }

    public CompositeAssetFilter getFilter() {
        return this.filter;
    }

    public void addFilter(KnowledgeBuilderImpl.AssetFilter f) {
        if (f != null) {
            if (this.filter == null) {
                this.filter = new CompositeAssetFilter();
            }
            this.filter.filters.add(f);
        }
    }

    public static class CompositeAssetFilter
    implements KnowledgeBuilderImpl.AssetFilter {
        public List<KnowledgeBuilderImpl.AssetFilter> filters = new ArrayList<KnowledgeBuilderImpl.AssetFilter>();

        @Override
        public KnowledgeBuilderImpl.AssetFilter.Action accept(ResourceChange.Type type, String pkgName, String assetName) {
            for (KnowledgeBuilderImpl.AssetFilter filter : this.filters) {
                KnowledgeBuilderImpl.AssetFilter.Action result = filter.accept(type, pkgName, assetName);
                if (KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING.equals((Object)result)) continue;
                return result;
            }
            return KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING;
        }
    }
}

