/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.compiler.builder.impl;

import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;

/**
 * Holds build processing info, warnings and errors.
 */
public interface BuildResultAccumulator {
    void addBuilderResult(KnowledgeBuilderResult result);

    /**
     * This will return true if there were errors in the package building and
     * compiling phase
     */
    boolean hasErrors();

    /**
     * Return the knowledge builder results for the listed severities.
     *
     * @param severities
     */
    KnowledgeBuilderResults getResults(ResultSeverity... severities);

}
