/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.util.StringUtils;
import org.drools.util.io.ByteArrayResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.Resource;

public class CompositePackageDescrTest {
    private static final String NAMESPACE = "namespace";
    private CompositePackageDescr compositePackageDescr;

    @Before
    public void setup() {
        this.compositePackageDescr = new CompositePackageDescr((Resource)new ByteArrayResource(), new PackageDescr(NAMESPACE));
    }

    @Test
    public void addPackageDescrSamePkgUUID() {
        String pkgUUID = StringUtils.generateUUID();
        PackageDescr toAdd = new PackageDescr(NAMESPACE);
        toAdd.setPreferredPkgUUID(pkgUUID);
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), toAdd);
        Assert.assertTrue((boolean)this.compositePackageDescr.getPreferredPkgUUID().isPresent());
        Assert.assertEquals((Object)pkgUUID, this.compositePackageDescr.getPreferredPkgUUID().get());
        toAdd = new PackageDescr(NAMESPACE);
        toAdd.setPreferredPkgUUID(pkgUUID);
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), toAdd);
        Assert.assertEquals((Object)pkgUUID, this.compositePackageDescr.getPreferredPkgUUID().get());
    }

    @Test(expected=RuntimeException.class)
    public void addPackageDescrDifferentPkgUUID() {
        String pkgUUID = StringUtils.generateUUID();
        PackageDescr first = new PackageDescr(NAMESPACE);
        first.setPreferredPkgUUID(pkgUUID);
        Assert.assertTrue((boolean)first.getPreferredPkgUUID().isPresent());
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), first);
        Assert.assertTrue((boolean)this.compositePackageDescr.getPreferredPkgUUID().isPresent());
        Assert.assertEquals((Object)pkgUUID, this.compositePackageDescr.getPreferredPkgUUID().get());
        pkgUUID = StringUtils.generateUUID();
        PackageDescr second = new PackageDescr(NAMESPACE);
        second.setPreferredPkgUUID(pkgUUID);
        Assert.assertTrue((boolean)second.getPreferredPkgUUID().isPresent());
        Assert.assertNotEquals(first.getPreferredPkgUUID().get(), second.getPreferredPkgUUID().get());
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), second);
    }
}

