/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.HashSet;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.GlobalError;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableGlobalCompilationPhase
extends AbstractPackageCompilationPhase {
    protected static final transient Logger logger = LoggerFactory.getLogger(ImmutableGlobalCompilationPhase.class);
    private final GlobalVariableContext globalVariableContext;

    public ImmutableGlobalCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr, GlobalVariableContext globalVariableContext) {
        super(pkgRegistry, packageDescr);
        this.globalVariableContext = globalVariableContext;
    }

    @Override
    public final void process() {
        InternalKnowledgePackage pkg = this.pkgRegistry.getPackage();
        HashSet existingGlobals = new HashSet(pkg.getGlobals().keySet());
        for (GlobalDescr global : this.packageDescr.getGlobals()) {
            String identifier = global.getIdentifier();
            existingGlobals.remove(identifier);
            String className = global.getType();
            while (className.indexOf(60) >= 0) {
                className = className.replaceAll("<[^<>]+?>", "");
            }
            try {
                Class clazz = this.pkgRegistry.getTypeResolver().resolveType(className);
                if (clazz.isPrimitive()) {
                    this.results.add((KnowledgeBuilderResult)new GlobalError(global, " Primitive types are not allowed in globals : " + className));
                    return;
                }
                this.addGlobal(pkg, identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                this.results.add((KnowledgeBuilderResult)new GlobalError(global, e.getMessage()));
                logger.warn("ClassNotFoundException occured!", (Throwable)e);
            }
        }
        for (String toBeRemoved : existingGlobals) {
            this.removeGlobal(pkg, toBeRemoved);
        }
    }

    protected void addGlobal(InternalKnowledgePackage pkg, String identifier, Class<?> clazz) {
        pkg.addGlobal(identifier, clazz);
        this.globalVariableContext.addGlobal(identifier, clazz);
    }

    protected void removeGlobal(InternalKnowledgePackage pkg, String toBeRemoved) {
        pkg.removeGlobal(toBeRemoved);
    }
}

