/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.resources;

import java.io.IOException;
import java.io.StringReader;
import java.util.function.Supplier;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.errors.MissingImplementationException;
import org.drools.compiler.builder.impl.resources.ResourceHandler;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.extensions.GuidedRuleTemplateFactory;
import org.drools.drl.extensions.GuidedRuleTemplateProvider;
import org.drools.drl.extensions.ResourceConversionResult;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;

public class TemplateResourceHandler
extends ResourceHandler {
    private Supplier<DefaultExpander> expander;

    public TemplateResourceHandler(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId, Supplier<DefaultExpander> expander) {
        super(configuration, releaseId);
        this.expander = expander;
    }

    @Override
    public boolean handles(ResourceType type) {
        return type == ResourceType.TEMPLATE;
    }

    @Override
    public PackageDescr process(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        GuidedRuleTemplateProvider guidedRuleTemplateProvider = GuidedRuleTemplateFactory.getGuidedRuleTemplateProvider();
        if (guidedRuleTemplateProvider == null) {
            throw new MissingImplementationException(resource, "drools-workbench-models-guided-template");
        }
        ResourceConversionResult conversionResult = guidedRuleTemplateProvider.loadFromInputStream(resource.getInputStream());
        return this.conversionResultToPackageDescr(resource, conversionResult, this.expander.get());
    }

    private PackageDescr conversionResultToPackageDescr(Resource resource, ResourceConversionResult resourceConversionResult, DefaultExpander expander) throws DroolsParserException {
        ResourceType resourceType = resourceConversionResult.getType();
        if (ResourceType.DSLR.equals((Object)resourceType)) {
            return this.generatedDslrToPackageDescr(resource, resourceConversionResult.getContent(), expander);
        }
        if (ResourceType.DRL.equals((Object)resourceType)) {
            return this.generatedDrlToPackageDescr(resource, resourceConversionResult.getContent());
        }
        throw new DroolsParserException("Converting generated " + resourceType + " into PackageDescr is not supported!");
    }

    PackageDescr generatedDslrToPackageDescr(Resource resource, String dslr, DefaultExpander expander) throws DroolsParserException {
        return this.dslrReaderToPackageDescr(resource, new StringReader(dslr), expander);
    }
}

