/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.consequence.ConflictResolver;
import org.drools.base.rule.consequence.Consequence;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.PropagationContext;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.Queue;
import org.drools.core.util.QueueFactory;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class BinaryHeapQueueTest {
    private List<Integer[]> perms = new ArrayList<Integer[]>();
    private static final int max = 20;

    private void shuffle(Integer[] a, int lim) {
        if (lim == 0) {
            Integer[] p = (Integer[])a.clone();
            this.perms.add(p);
        } else {
            this.shuffle(a, lim - 1);
            Integer h = a[lim];
            a[lim] = a[lim - 1];
            a[lim - 1] = h;
            this.shuffle(a, lim - 1);
        }
    }

    @Test
    public void testShuffled() {
        long time = System.currentTimeMillis();
        for (int k = 0; k < 10; ++k) {
            for (Integer[] perm : this.perms) {
                int i2;
                InternalMatch[] elems;
                Group group = new Group("group");
                for (Integer i2 : perm) {
                    Item item = new Item(group, i2);
                    group.add(item);
                }
                InternalMatch[] internalMatchArray = elems = group.getQueue().toArray(new InternalMatch[0]);
                int n = internalMatchArray.length;
                for (i2 = 0; i2 < n; ++i2) {
                    InternalMatch elem = internalMatchArray[i2];
                    Item item = (Item)elem;
                    if (item.getQueueIndex() % 2 != 0) continue;
                    group.remove(item);
                    group.add(item);
                }
                boolean ok = true;
                StringBuilder sb = new StringBuilder("queue:");
                for (i2 = 19; i2 >= 0; --i2) {
                    int sal = group.getNext().getSalience();
                    sb.append(" ").append(sal);
                    if (sal == i2) continue;
                    ok = false;
                }
                ((AbstractBooleanAssert)AssertionsForClassTypes.assertThat((boolean)ok).as("incorrect order in " + sb.toString(), new Object[0])).isTrue();
            }
        }
        System.out.println("time:" + (System.currentTimeMillis() - time));
    }

    @Before
    public void setup() {
        System.out.println("Running setup");
        Integer[] a = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            a[i] = i;
        }
        this.shuffle(a, 19);
    }

    public static class Group {
        private static final long serialVersionUID = 510L;
        private String name;
        private Queue<Item> queue;

        public Group() {
        }

        public Group(String name) {
            this.name = name;
            this.queue = QueueFactory.createQueue((Comparator)((Object)ItemConflictResolver.INSTANCE));
        }

        public String getName() {
            return this.name;
        }

        public void clear() {
            this.queue.clear();
        }

        public int size() {
            return this.queue.size();
        }

        public void add(Item item) {
            this.queue.enqueue((Queue.QueueEntry)item);
        }

        public Item getNext() {
            return (Item)this.queue.dequeue();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public String toString() {
            return "AgendaGroup '" + this.name + "'";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Group)) {
                return false;
            }
            return ((Group)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void remove(Item agendaItem) {
            this.queue.dequeue((Queue.QueueEntry)agendaItem);
        }

        public Collection<Item> getQueue() {
            return this.queue.getAll();
        }
    }

    public static class Item
    implements InternalMatch {
        private static int actNo = 1;
        private int index;
        private long activationNumber;
        private Group group;
        private int salience;

        public Item(Group group, int salience) {
            this.group = group;
            this.salience = salience;
            this.activationNumber = actNo++;
        }

        public void dequeue() {
            if (this.group != null) {
                this.group.remove(this);
            }
            this.index = -1;
        }

        public void setQueueIndex(int index) {
            this.index = index;
        }

        public int getQueueIndex() {
            return this.index;
        }

        public int getSalience() {
            return this.salience;
        }

        public long getActivationNumber() {
            return this.activationNumber;
        }

        public ActivationGroupNode getActivationGroupNode() {
            return null;
        }

        public ActivationNode getActivationNode() {
            return null;
        }

        public InternalAgendaGroup getAgendaGroup() {
            return null;
        }

        public InternalRuleFlowGroup getRuleFlowGroup() {
            return null;
        }

        public PropagationContext getPropagationContext() {
            return null;
        }

        public RuleImpl getRule() {
            return null;
        }

        public Consequence getConsequence() {
            return null;
        }

        public TupleImpl getTuple() {
            return null;
        }

        public boolean isQueued() {
            return false;
        }

        public void remove() {
        }

        public void setQueued(boolean arg0) {
        }

        public void setActivationGroupNode(ActivationGroupNode arg0) {
        }

        public void setActivationNode(ActivationNode arg0) {
        }

        public List<String> getDeclarationIds() {
            return null;
        }

        public Object getDeclarationValue(String arg0) {
            return null;
        }

        public List<FactHandle> getFactHandles() {
            return null;
        }

        public List<Object> getObjects() {
            return null;
        }

        public InternalFactHandle getActivationFactHandle() {
            return null;
        }

        public boolean isAdded() {
            return false;
        }

        public boolean isMatched() {
            return false;
        }

        public void setMatched(boolean matched) {
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }

        public RuleAgendaItem getRuleAgendaItem() {
            return null;
        }

        public void setActivationFactHandle(InternalFactHandle factHandle) {
        }

        public TerminalNode getTerminalNode() {
            return null;
        }

        public String toExternalForm() {
            return null;
        }

        public Runnable getCallback() {
            return null;
        }

        public void setCallback(Runnable callback) {
        }
    }

    public static class ItemConflictResolver
    implements ConflictResolver<Item> {
        private static final long serialVersionUID = 1L;
        public static final ItemConflictResolver INSTANCE = new ItemConflictResolver();

        public static ItemConflictResolver getInstance() {
            return INSTANCE;
        }

        public final int compare(Item existing, Item adding) {
            int s2;
            int s1 = existing.getSalience();
            if (s1 != (s2 = adding.getSalience())) {
                return s1 - s2;
            }
            return (int)(existing.getActivationNumber() - adding.getActivationNumber());
        }
    }
}

