/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.util.AbstractLinkedListNode;
import org.drools.core.util.DoubleLinkedEntry;
import org.drools.core.util.LinkedList;
import org.junit.Before;
import org.junit.Test;

public class LinkedListTest {
    LinkedList list = null;
    DoubleLinkedEntry node1 = null;
    DoubleLinkedEntry node2 = null;
    DoubleLinkedEntry node3 = null;

    @Before
    public void setUp() throws Exception {
        this.list = new LinkedList();
        this.node1 = new AbstractBaseLinkedListNodeMock();
        this.node2 = new AbstractBaseLinkedListNodeMock();
        this.node3 = new AbstractBaseLinkedListNodeMock();
    }

    @Test
    public void testAdd() {
        this.list.add(this.node1);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1.getPrevious()).as("Node1 previous should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node1.getNext()).as("Node1 next should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("First node should be node1", new Object[0])).isSameAs((Object)this.list.getFirst());
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("Last node should be node1", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.add(this.node2);
        ((ObjectAssert)Assertions.assertThat((Object)this.node2).as("node1 next should be node2", new Object[0])).isSameAs((Object)this.node1.getNext());
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("node2 previous should be node1", new Object[0])).isSameAs((Object)this.node2.getPrevious());
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("First node should be node1", new Object[0])).isSameAs((Object)this.list.getFirst());
        ((ObjectAssert)Assertions.assertThat((Object)this.node2).as("Last node should be node2", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.add(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("node2 next should be node3", new Object[0])).isSameAs((Object)this.node2.getNext());
        ((ObjectAssert)Assertions.assertThat((Object)this.node2).as("node3 previous should be node2", new Object[0])).isSameAs((Object)this.node3.getPrevious());
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.list.size()).as("LinkedList should have 3 nodes", new Object[0])).isEqualTo(3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("First node should be node1", new Object[0])).isSameAs((Object)this.list.getFirst());
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("Last node should be node3", new Object[0])).isSameAs((Object)this.list.getLast());
    }

    @Test
    public void testRemove() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("node2 previous should be node1", new Object[0])).isSameAs((Object)this.node2.getPrevious());
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("node2 next should be node3", new Object[0])).isSameAs((Object)this.node2.getNext());
        this.list.remove(this.node2);
        ((ObjectAssert)Assertions.assertThat((Object)this.node2.getPrevious()).as("Node2 previous should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node2.getNext()).as("Node2 next should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node1.getPrevious()).as("Node1 previous should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("node1 next should be node3", new Object[0])).isSameAs((Object)this.node1.getNext());
        this.list.remove(this.node1);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1.getPrevious()).as("Node1 previous should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node1.getNext()).as("Node1 next should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node3.getPrevious()).as("Node3 previous should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node3.getNext()).as("Node3 next should be null", new Object[0])).isNull();
        this.list.remove(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node3.getPrevious()).as("Node3 previous should be null", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.node3.getNext()).as("Node3 next should be null", new Object[0])).isNull();
    }

    @Test
    public void testGetFirst() {
        ((ObjectAssert)Assertions.assertThat((Object)this.list.getFirst()).as("Empty list should return null on getFirst()", new Object[0])).isNull();
        this.list.add(this.node1);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("First node should be node1", new Object[0])).isSameAs((Object)this.list.getFirst());
        this.list.add(this.node2);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("List should return node1 on getFirst()", new Object[0])).isSameAs((Object)this.list.getFirst());
        this.list.add(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("List should return node1 on getFirst()", new Object[0])).isSameAs((Object)this.list.getFirst());
    }

    @Test
    public void testGetLast() {
        ((ObjectAssert)Assertions.assertThat((Object)this.list.getLast()).as("Empty list should return null on getLast()", new Object[0])).isNull();
        this.list.add(this.node1);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("Last node should be node1", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.add(this.node2);
        ((ObjectAssert)Assertions.assertThat((Object)this.node2).as("Last node should be node2", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.add(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("Last node should be node3", new Object[0])).isSameAs((Object)this.list.getLast());
    }

    @Test
    public void testRemoveFirst() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("First node should be node1", new Object[0])).isSameAs((Object)this.list.getFirst());
        this.list.removeFirst();
        ((ObjectAssert)Assertions.assertThat((Object)this.node2).as("List should return node2 on getFirst()", new Object[0])).isSameAs((Object)this.list.getFirst());
        this.list.removeFirst();
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("List should return node3 on getFirst()", new Object[0])).isSameAs((Object)this.list.getFirst());
        this.list.removeFirst();
        ((ObjectAssert)Assertions.assertThat((Object)this.list.getFirst()).as("Empty list should return null on getFirst()", new Object[0])).isNull();
    }

    @Test
    public void testRemoveLast() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        ((ObjectAssert)Assertions.assertThat((Object)this.node3).as("Last node should be node3", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.removeLast();
        ((ObjectAssert)Assertions.assertThat((Object)this.node2).as("Last node should be node2", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.removeLast();
        ((ObjectAssert)Assertions.assertThat((Object)this.node1).as("Last node should be node1", new Object[0])).isSameAs((Object)this.list.getLast());
        this.list.removeLast();
        ((ObjectAssert)Assertions.assertThat((Object)this.list.getLast()).as("Empty list should return null on getLast()", new Object[0])).isNull();
    }

    @Test
    public void testIsEmpty() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.list.isEmpty()).as("Empty list should return true on isEmpty()", new Object[0])).isTrue();
        this.list.add(this.node1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.list.isEmpty()).as("Not empty list should return false on isEmpty()", new Object[0])).isFalse();
    }

    @Test
    public void testClear() {
        this.list.add(this.node1);
        this.list.add(this.node2);
        this.list.add(this.node3);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.list.size()).as("List size should be 3", new Object[0])).isEqualTo(3);
        this.list.clear();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.list.size()).as("Empty list should have size 0", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testSize() {
        this.list.add(this.node1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.list.size()).as("LinkedList should have 1 node", new Object[0])).isEqualTo(1);
        this.list.add(this.node2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.list.size()).as("LinkedList should have 2 node", new Object[0])).isEqualTo(2);
        this.list.add(this.node3);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.list.size()).as("LinkedList should have 3 node", new Object[0])).isEqualTo(3);
    }

    @Test
    public void testInsertAfter() {
        try {
            this.list.insertAfter(null, this.node1);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Assertions.fail((String)"Should NOT raise NPE!");
        }
    }

    private static class AbstractBaseLinkedListNodeMock
    extends AbstractLinkedListNode<AbstractBaseLinkedListNodeMock> {
        private AbstractBaseLinkedListNodeMock() {
        }
    }
}

