/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.TupleSets;
import org.drools.core.reteoo.TupleImpl;

public class TupleSetsImpl
implements TupleSets {
    private TupleImpl insertFirst;
    private TupleImpl deleteFirst;
    private TupleImpl updateFirst;
    private TupleImpl normalizedDeleteFirst;
    private int insertSize;

    public TupleSetsImpl() {
    }

    TupleSetsImpl(TupleImpl insertFirst, TupleImpl updateFirst, TupleImpl deleteFirst, TupleImpl normalizedDeleteFirst, int insertSize) {
        this.insertFirst = insertFirst;
        this.updateFirst = updateFirst;
        this.deleteFirst = deleteFirst;
        this.normalizedDeleteFirst = normalizedDeleteFirst;
        this.insertSize = insertSize;
    }

    @Override
    public int getInsertSize() {
        return this.insertSize;
    }

    @Override
    public TupleImpl getInsertFirst() {
        return this.insertFirst;
    }

    protected void setInsertFirst(TupleImpl insertFirst) {
        this.insertFirst = insertFirst;
    }

    @Override
    public TupleImpl getDeleteFirst() {
        return this.deleteFirst;
    }

    protected void setDeleteFirst(TupleImpl deleteFirst) {
        this.deleteFirst = deleteFirst;
    }

    @Override
    public TupleImpl getUpdateFirst() {
        return this.updateFirst;
    }

    protected void setUpdateFirst(TupleImpl updateFirst) {
        this.updateFirst = updateFirst;
    }

    @Override
    public TupleImpl getNormalizedDeleteFirst() {
        return this.normalizedDeleteFirst;
    }

    protected void setNormalizedDeleteFirst(TupleImpl normalizedDeleteFirst) {
        this.normalizedDeleteFirst = normalizedDeleteFirst;
    }

    @Override
    public void resetAll() {
        this.setInsertFirst(null);
        this.setDeleteFirst(null);
        this.setUpdateFirst(null);
        this.setNormalizedDeleteFirst(null);
        this.insertSize = 0;
    }

    @Override
    public boolean addInsert(TupleImpl tuple) {
        if (this.getStagedType(tuple) == 2) {
            return false;
        }
        this.setStagedType(tuple, (short)1);
        if (this.insertFirst == null) {
            this.insertFirst = tuple;
            this.insertSize = 1;
            return true;
        }
        this.setNextTuple(tuple, this.insertFirst);
        this.setPreviousTuple(this.insertFirst, tuple);
        this.insertFirst = tuple;
        ++this.insertSize;
        return false;
    }

    @Override
    public boolean addDelete(TupleImpl tuple) {
        switch (this.getStagedType(tuple)) {
            case 1: {
                this.removeInsert(tuple);
                return this.deleteFirst == null;
            }
            case 2: {
                this.removeUpdate(tuple);
            }
        }
        this.setStagedType(tuple, (short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = tuple;
            return true;
        }
        this.setNextTuple(tuple, this.deleteFirst);
        this.setPreviousTuple(this.deleteFirst, tuple);
        this.deleteFirst = tuple;
        return false;
    }

    @Override
    public boolean addNormalizedDelete(TupleImpl tuple) {
        this.setStagedType(tuple, (short)4);
        if (this.normalizedDeleteFirst == null) {
            this.normalizedDeleteFirst = tuple;
            return true;
        }
        this.setNextTuple(tuple, this.normalizedDeleteFirst);
        this.setPreviousTuple(this.normalizedDeleteFirst, tuple);
        this.normalizedDeleteFirst = tuple;
        return false;
    }

    @Override
    public boolean addUpdate(TupleImpl tuple) {
        if (this.getStagedType(tuple) != 0) {
            return false;
        }
        this.setStagedType(tuple, (short)2);
        if (this.updateFirst == null) {
            this.updateFirst = tuple;
            return true;
        }
        this.setNextTuple(tuple, this.updateFirst);
        this.setPreviousTuple(this.updateFirst, tuple);
        this.updateFirst = tuple;
        return false;
    }

    @Override
    public void removeInsert(TupleImpl tuple) {
        if (tuple == this.insertFirst) {
            TupleImpl next = this.getNextTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, null);
            }
            this.setInsertFirst(next);
        } else {
            TupleImpl next = this.getNextTuple(tuple);
            TupleImpl previous = this.getPreviousTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, previous);
            }
            this.setNextTuple(previous, next);
        }
        tuple.clearStaged();
        --this.insertSize;
    }

    @Override
    public void removeDelete(TupleImpl tuple) {
        if (tuple == this.deleteFirst) {
            TupleImpl next = this.getNextTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, null);
            }
            this.deleteFirst = next;
        } else {
            TupleImpl next = this.getNextTuple(tuple);
            TupleImpl previous = this.getPreviousTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, previous);
            }
            this.setNextTuple(previous, next);
        }
        tuple.clearStaged();
    }

    @Override
    public void removeUpdate(TupleImpl tuple) {
        if (tuple == this.updateFirst) {
            TupleImpl next = this.getNextTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, null);
            }
            this.updateFirst = next;
        } else {
            TupleImpl next = this.getNextTuple(tuple);
            TupleImpl previous = this.getPreviousTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, previous);
            }
            this.setNextTuple(previous, next);
        }
        tuple.clearStaged();
    }

    private void addAllInserts(TupleSets tupleSets) {
        if (tupleSets.getInsertFirst() != null) {
            if (this.insertFirst == null) {
                this.setInsertFirst(tupleSets.getInsertFirst());
                this.insertSize = tupleSets.getInsertSize();
            } else {
                TupleImpl current = this.insertFirst;
                TupleImpl last = null;
                while (current != null) {
                    last = current;
                    current = this.getNextTuple(current);
                }
                TupleImpl tuple = tupleSets.getInsertFirst();
                this.setNextTuple(last, tuple);
                this.setPreviousTuple(tuple, last);
                this.insertSize += tupleSets.getInsertSize();
            }
            ((TupleSetsImpl)tupleSets).setInsertFirst(null);
        }
    }

    private void addAllDeletes(TupleSets tupleSets) {
        if (tupleSets.getDeleteFirst() != null) {
            if (this.deleteFirst == null) {
                this.setDeleteFirst(tupleSets.getDeleteFirst());
            } else {
                TupleImpl current = this.deleteFirst;
                TupleImpl last = null;
                while (current != null) {
                    last = current;
                    current = this.getNextTuple(current);
                }
                TupleImpl tuple = tupleSets.getDeleteFirst();
                this.setNextTuple(last, tuple);
                this.setPreviousTuple(tuple, last);
            }
            ((TupleSetsImpl)tupleSets).setDeleteFirst(null);
        }
    }

    private void addAllUpdates(TupleSets tupleSets) {
        if (tupleSets.getUpdateFirst() != null) {
            if (this.updateFirst == null) {
                this.setUpdateFirst(tupleSets.getUpdateFirst());
            } else {
                TupleImpl current = this.updateFirst;
                TupleImpl last = null;
                while (current != null) {
                    last = current;
                    current = this.getNextTuple(current);
                }
                TupleImpl tuple = tupleSets.getUpdateFirst();
                this.setNextTuple(last, tuple);
                this.setPreviousTuple(tuple, last);
            }
            ((TupleSetsImpl)tupleSets).setUpdateFirst(null);
        }
    }

    @Override
    public void addAll(TupleSets source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    @Override
    public void addTo(TupleSets target) {
        target.addAll(this);
    }

    @Override
    public TupleSets takeAll() {
        TupleSetsImpl clone = new TupleSetsImpl(this.insertFirst, this.updateFirst, this.deleteFirst, this.normalizedDeleteFirst, this.insertSize);
        this.resetAll();
        return clone;
    }

    @Override
    public void clear() {
        this.clear(this.getInsertFirst());
        this.clear(this.getDeleteFirst());
        this.clear(this.getUpdateFirst());
        this.clear(this.getNormalizedDeleteFirst());
        this.resetAll();
    }

    private void clear(TupleImpl tuple) {
        while (tuple != null) {
            TupleImpl next = this.getNextTuple(tuple);
            tuple.clearStaged();
            tuple = next;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.insertFirst == null && this.deleteFirst == null && this.updateFirst == null && this.normalizedDeleteFirst == null;
    }

    @Override
    public String toStringSizes() {
        return "TupleSets[hasInsert=" + (this.insertFirst != null) + ", hasDelete=" + (this.deleteFirst != null) + ", hasUpdate=" + (this.updateFirst != null) + "]";
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        this.appendSet(sbuilder, this.getInsertFirst());
        sbuilder.append("Deleted:\n");
        this.appendSet(sbuilder, this.getDeleteFirst());
        sbuilder.append("Updated:\n");
        this.appendSet(sbuilder, this.getUpdateFirst());
        sbuilder.append("Normalized Deleted:\n");
        this.appendSet(sbuilder, this.getNormalizedDeleteFirst());
        return sbuilder.toString();
    }

    private void appendSet(StringBuilder sbuilder, TupleImpl tuple) {
        while (tuple != null) {
            sbuilder.append(" ").append(tuple).append("\n");
            tuple = this.getNextTuple(tuple);
        }
    }

    protected TupleImpl getPreviousTuple(TupleImpl tuple) {
        return tuple.getStagedPrevious();
    }

    protected void setPreviousTuple(TupleImpl tuple, TupleImpl stagedPrevious) {
        tuple.setStagedPrevious(stagedPrevious);
    }

    protected TupleImpl getNextTuple(TupleImpl tuple) {
        return tuple.getStagedNext();
    }

    protected void setNextTuple(TupleImpl tuple, TupleImpl stagedNext) {
        tuple.setStagedNext(stagedNext);
    }

    protected void setStagedType(TupleImpl tuple, short type) {
        tuple.setStagedType(type);
    }

    protected short getStagedType(TupleImpl tuple) {
        return tuple.getStagedType();
    }
}

