/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ClassAwareObjectStoreTest {
    private static final AtomicInteger factCounter = new AtomicInteger(0);

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void iterateObjectsReturnsObjectsOfAllTypes(ClassAwareObjectStore underTest) throws Exception {
        String aStringValue = "a string";
        BigDecimal bigDecimalValue = new BigDecimal("1");
        underTest.addHandle(this.handleFor(aStringValue), (Object)aStringValue);
        underTest.addHandle(this.handleFor(bigDecimalValue), (Object)bigDecimalValue);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects());
        Assertions.assertThat(result).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void iterateByClassFiltersByClass(ClassAwareObjectStore underTest) {
        SimpleClass object = new SimpleClass();
        underTest.addHandle(this.handleFor("some string"), (Object)"some string");
        underTest.addHandle(this.handleFor(object), (Object)object);
        Collection results = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SimpleClass.class));
        Assertions.assertThat(results).hasSize(1);
        Assertions.assertThat(results).contains(new Object[]{object});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void queryBySuperTypeFindsSubType(ClassAwareObjectStore underTest) throws Exception {
        SubClass objectToInsert = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        SuperClass objectToInsert1 = new SuperClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SuperClass.class);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void queryBySubtypeDoesNotReturnSuperType(ClassAwareObjectStore underTest) throws Exception {
        SubClass objectToInsert = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        SuperClass objectToInsert1 = new SuperClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SubClass.class));
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void queryBySubTypeDoesNotPreventInsertionsBeingPropogatedToSuperTypeQueries(ClassAwareObjectStore underTest) throws Exception {
        SuperClass objectToInsert = new SuperClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SubClass.class));
        SubClass objectToInsert1 = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SuperClass.class);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void queryBySuperTypeCanFindSubTypeWhenNoSuperTypeInstancesAreInStore(ClassAwareObjectStore underTest) throws Exception {
        SubClass objectToInsert = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void isOkayToReinsertSameTypeThenQuery(ClassAwareObjectStore underTest) throws Exception {
        SubClass objectToInsert = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        SubClass objectToInsert1 = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(new HashSet(result)).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void onceSuperClassIsSetUpForReadingItCanBecomeSetUpForWritingWithoutGettingDuplicateQueryReturns(ClassAwareObjectStore underTest) throws Exception {
        Assertions.assertThat((boolean)ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SuperClass.class)).isEmpty()).isTrue();
        SubClass objectToInsert = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        SuperClass objectToInsert1 = new SuperClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SuperClass.class));
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat(new HashSet(result)).hasSize(2);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void clearRemovesInsertedObjects(ClassAwareObjectStore underTest) throws Exception {
        SimpleClass objectToInsert = new SimpleClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(underTest.iterateObjects())).hasSize(1);
        underTest.clear();
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(underTest.iterateObjects())).hasSize(0);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void canIterateOverObjectsUsingCustomFilter(ClassAwareObjectStore underTest) throws Exception {
        SuperClass objectToInsert = new SuperClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        SubClass objectToInsert1 = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Collection result = ClassAwareObjectStoreTest.collect(underTest.iterateObjects(SubClass.class::isInstance));
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).hasAtLeastOneElementOfType(SubClass.class);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void iteratingOverFactHandlesHasSameNumberOfResultsAsIteratingOverObjects(ClassAwareObjectStore underTest) throws Exception {
        SuperClass objectToInsert = new SuperClass();
        underTest.addHandle(this.handleFor(objectToInsert), (Object)objectToInsert);
        SubClass objectToInsert1 = new SubClass();
        underTest.addHandle(this.handleFor(objectToInsert1), (Object)objectToInsert1);
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(underTest.iterateFactHandles(SubClass.class))).hasSize(1);
        Assertions.assertThat(ClassAwareObjectStoreTest.collect(underTest.iterateFactHandles(SuperClass.class))).hasSize(2);
    }

    private static <T> Collection<T> collect(Iterator<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        while (objects.hasNext()) {
            result.add(objects.next());
        }
        return result;
    }

    public static Stream<ClassAwareObjectStore> parameters() {
        return Stream.of(new ClassAwareObjectStore(true, (Lock)new ReentrantLock()), new ClassAwareObjectStore(false, (Lock)new ReentrantLock()));
    }

    private InternalFactHandle handleFor(Object object) {
        return new DefaultFactHandle((long)factCounter.getAndIncrement(), object);
    }

    private static class SimpleClass {
        private SimpleClass() {
        }
    }

    private static class SubClass
    extends SuperClass {
        private SubClass() {
        }
    }

    private static class SuperClass {
        private SuperClass() {
        }
    }
}

