/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.drools.io.ByteArrayResource;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ByteArrayResourceToStringTest {
    public static Stream<Arguments> parameters() {
        List<Arguments> parameters = List.of(Arguments.arguments((Object[])new Object[]{Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40), null, "ByteArrayResource[bytes=[10, 20, 30, 40], encoding=null]"}), Arguments.arguments((Object[])new Object[]{Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40, (byte)50, (byte)60, (byte)70, (byte)80, (byte)90, (byte)100), null, "ByteArrayResource[bytes=[10, 20, 30, 40, 50, 60, 70, 80, 90, 100], encoding=null]"}), Arguments.arguments((Object[])new Object[]{Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40, (byte)50, (byte)60, (byte)70, (byte)80, (byte)90, (byte)100, (byte)110, (byte)120), null, "ByteArrayResource[bytes=[10, 20, 30, 40, 50, 60, 70, 80, 90, 100, ...], encoding=null]"}), Arguments.arguments((Object[])new Object[]{Arrays.asList((byte)10, (byte)20, (byte)30, (byte)40, (byte)50, (byte)60, (byte)70, (byte)80, (byte)90, (byte)100, (byte)110, (byte)120), "UTF-8", "ByteArrayResource[bytes=[10, 20, 30, 40, 50, 60, 70, 80, 90, 100, ...], encoding=UTF-8]"}));
        return parameters.stream();
    }

    @ParameterizedTest(name="{index}: bytes={0}, encoding={1}")
    @MethodSource(value={"parameters"})
    public void testToString(List<Byte> bytes, String encoding, String expectedString) {
        byte[] byteArray = ArrayUtils.toPrimitive((Byte[])bytes.toArray(new Byte[0]));
        ByteArrayResource byteArrayResource = new ByteArrayResource(byteArray, encoding);
        Assertions.assertThat((String)byteArrayResource.toString()).isEqualTo(expectedString);
    }
}

