/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.assertj.core.api.Assertions;
import org.drools.core.util.KeyStoreHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class KeyStoreHelperTest {
    private static final String KEYSTORE_SERVER_RESOURCE_NAME = "droolsServer.keystore";
    private static final String KEYSTORE_CLIENT_RESOURCE_NAME = "droolsClient.keystore";
    private static final String KEYSTORE_JCEKS_RESOURCE_NAME = "droolsServer.jceks";
    private static final String KEYSTORE_JCEKS_FILENAME = "target/test-classes/org/drools/core/util/droolsServer.jceks";
    private static final String KEYSTORE_SERVER_PASSWORD = "serverpwd";
    private static final String KEYSTORE_CLIENT_PASSWORD = "clientpwd";
    private static final String KEY_ALIAS = "droolsKey";
    private static final String KEY_PASSWORD = "keypwd";
    private static final String KEY_PHRASE = "secretkey";

    @AfterAll
    public static void cleanup() {
        try {
            new File(KEYSTORE_JCEKS_FILENAME).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSignDataWithPrivateKey() throws UnsupportedEncodingException, UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SignatureException {
        URL serverKeyStoreURL = this.getClass().getResource(KEYSTORE_SERVER_RESOURCE_NAME);
        System.setProperty("drools.serialization.sign", Boolean.TRUE.toString());
        System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.private.keyStorePwd", KEYSTORE_SERVER_PASSWORD);
        System.setProperty("drools.serialization.private.keyAlias", KEY_ALIAS);
        System.setProperty("drools.serialization.private.keyPwd", KEY_PASSWORD);
        KeyStoreHelper serverHelper = new KeyStoreHelper();
        byte[] data = "Hello World".getBytes("UTF8");
        byte[] signature = serverHelper.signDataWithPrivateKey(data);
        URL clientKeyStoreURL = this.getClass().getResource(KEYSTORE_CLIENT_RESOURCE_NAME);
        System.setProperty("drools.serialization.sign", Boolean.TRUE.toString());
        System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.public.keyStorePwd", KEYSTORE_CLIENT_PASSWORD);
        KeyStoreHelper clientHelper = new KeyStoreHelper();
        Assertions.assertThat((boolean)clientHelper.checkDataWithPublicKey(KEY_ALIAS, data, signature)).isTrue();
        Assertions.assertThat((boolean)clientHelper.checkDataWithPublicKey(KEY_ALIAS, "fake".getBytes("UTF8"), signature)).isFalse();
    }

    @Test
    public void testLoadPasswordNoKeystore() {
        KeyStoreHelper serverHelper = new KeyStoreHelper();
        try {
            serverHelper.getPasswordKey(null, null);
            Assertions.fail((String)"Should have failed before");
        }
        catch (RuntimeException re) {
            Assertions.assertThat((boolean)true).isTrue();
        }
    }

    @Test
    public void testLoadPassword() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, InvalidKeyException, InvalidKeySpecException {
        SecretKey storedSecretKey = this.storeKeyIntoKeyStoreFile(KEY_PHRASE);
        URL serverKeyStoreURL = this.getClass().getResource(KEYSTORE_JCEKS_RESOURCE_NAME);
        System.setProperty("kie.keystore.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("kie.keystore.keyStorePwd", KEYSTORE_SERVER_PASSWORD);
        try {
            KeyStoreHelper serverHelper = new KeyStoreHelper();
            String passwordKey = serverHelper.getPasswordKey(KEY_ALIAS, KEY_PASSWORD.toCharArray());
            Assertions.assertThat((String)passwordKey).isEqualTo(new String(storedSecretKey.getEncoded()));
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            Assertions.fail((String)re.getMessage());
        }
    }

    private SecretKey storeKeyIntoKeyStoreFile(String keyPhrase) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, InvalidKeyException, InvalidKeySpecException {
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        keyStore.load(null, KEYSTORE_SERVER_PASSWORD.toCharArray());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey mySecretKey = secretKeyFactory.generateSecret(new DESKeySpec(keyPhrase.getBytes()));
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(mySecretKey);
        keyStore.setEntry(KEY_ALIAS, skEntry, new KeyStore.PasswordProtection(KEY_PASSWORD.toCharArray()));
        try (FileOutputStream fos = new FileOutputStream(KEYSTORE_JCEKS_FILENAME, false);){
            keyStore.store(fos, KEYSTORE_SERVER_PASSWORD.toCharArray());
        }
        return mySecretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignDataWithPrivateKeyWithFallback() throws UnsupportedEncodingException, UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SignatureException {
        try {
            URL serverKeyStoreURL = this.getClass().getResource(KEYSTORE_SERVER_RESOURCE_NAME);
            System.setProperty("drools.serialization.sign", Boolean.TRUE.toString());
            System.setProperty("drools.serialization.verify.old.sign", Boolean.TRUE.toString());
            System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
            System.setProperty("drools.serialization.private.keyStorePwd", KEYSTORE_SERVER_PASSWORD);
            System.setProperty("drools.serialization.private.keyAlias", KEY_ALIAS);
            System.setProperty("drools.serialization.private.keyPwd", KEY_PASSWORD);
            KeyStoreHelper serverHelper = new KeyStoreHelper();
            byte[] data = "Hello World".getBytes("UTF8");
            byte[] signature = serverHelper.signDataWithPrivateKeyWithAlgorithm(data, "MD5withRSA");
            URL clientKeyStoreURL = this.getClass().getResource(KEYSTORE_CLIENT_RESOURCE_NAME);
            System.setProperty("drools.serialization.sign", Boolean.TRUE.toString());
            System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
            System.setProperty("drools.serialization.public.keyStorePwd", KEYSTORE_CLIENT_PASSWORD);
            KeyStoreHelper clientHelper = new KeyStoreHelper();
            Assertions.assertThat((boolean)clientHelper.checkDataWithPublicKey(KEY_ALIAS, data, signature)).isTrue();
            Assertions.assertThat((boolean)clientHelper.checkDataWithPublicKey(KEY_ALIAS, "fake".getBytes("UTF8"), signature)).isFalse();
        }
        finally {
            System.clearProperty("drools.serialization.verify.old.sign");
        }
    }
}

