/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.test.model.Person;
import org.drools.core.util.index.RangeIndex;
import org.junit.jupiter.api.Test;

public class RangeIndexTest {
    final String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule A when\n   Person( age >= 18 )\nthen\nend\nrule B when\n   Person( age < 25 )\nthen\nend\nrule C when\n   Person( age > 8 )\nthen\nend\nrule D when\n   Person( age < 60 )\nthen\nend\nrule E when\n   Person( age > 12 )\nthen\nend\nrule F when\n   Person( age <= 4 )\nthen\nend\n";

    @Test
    public void test() {
        RangeIndex index = new RangeIndex();
        index.addIndex(RangeIndex.IndexType.GE, (Comparable)Integer.valueOf(18), (Object)"A");
        index.addIndex(RangeIndex.IndexType.LT, (Comparable)Integer.valueOf(25), (Object)"B");
        index.addIndex(RangeIndex.IndexType.GT, (Comparable)Integer.valueOf(8), (Object)"C");
        index.addIndex(RangeIndex.IndexType.LT, (Comparable)Integer.valueOf(60), (Object)"D");
        index.addIndex(RangeIndex.IndexType.GT, (Comparable)Integer.valueOf(12), (Object)"E");
        index.addIndex(RangeIndex.IndexType.LE, (Comparable)Integer.valueOf(4), (Object)"F");
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(18))).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "C", "D", "E"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(60))).containsExactlyInAnyOrder((Object[])new String[]{"A", "C", "E"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(59))).containsExactlyInAnyOrder((Object[])new String[]{"A", "C", "D", "E"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(4))).containsExactlyInAnyOrder((Object[])new String[]{"B", "D", "F"});
        Assertions.assertThat((Collection)index.getAllValues()).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "C", "D", "E", "F"});
        index.removeIndex(RangeIndex.IndexType.GT, (Comparable)Integer.valueOf(8));
        index.removeIndex(RangeIndex.IndexType.LT, (Comparable)Integer.valueOf(60));
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(18))).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "E"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(60))).containsExactlyInAnyOrder((Object[])new String[]{"A", "E"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(59))).containsExactlyInAnyOrder((Object[])new String[]{"A", "E"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(4))).containsExactlyInAnyOrder((Object[])new String[]{"B", "F"});
        Assertions.assertThat((Collection)index.getAllValues()).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "E", "F"});
    }

    @Test
    public void testBoundary() {
        RangeIndex index = new RangeIndex();
        index.addIndex(RangeIndex.IndexType.LT, (Comparable)Integer.valueOf(20), (Object)"A");
        index.addIndex(RangeIndex.IndexType.LE, (Comparable)Integer.valueOf(25), (Object)"B");
        index.addIndex(RangeIndex.IndexType.GE, (Comparable)Integer.valueOf(40), (Object)"C");
        index.addIndex(RangeIndex.IndexType.GT, (Comparable)Integer.valueOf(60), (Object)"D");
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(25))).containsExactlyInAnyOrder((Object[])new String[]{"B"});
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(26))).isEmpty();
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(39))).isEmpty();
        Assertions.assertThat((Collection)index.getValues((Comparable)Integer.valueOf(40))).containsExactlyInAnyOrder((Object[])new String[]{"C"});
    }
}

